/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.openide.util.NbBundle;

public enum PayaraJvmMode {
    NORMAL,
    DEBUG,
    PROFILE;

    private static final Logger LOGGER;
    public static final int length;
    private static final String NORMAL_STR = "normalMode";
    private static final String DEBUG_STR = "debugMode";
    private static final String PROFILE_STR = "profileMode";
    private static final Map<String, PayaraJvmMode> stringValuesMap;

    public static PayaraJvmMode toValue(String name) {
        if (name != null) {
            return stringValuesMap.get(name.toUpperCase());
        }
        return null;
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return NORMAL_STR;
            }
            case 1: {
                return DEBUG_STR;
            }
            case 2: {
                return PROFILE_STR;
            }
        }
        throw new IllegalStateException(NbBundle.getMessage(PayaraJvmMode.class, (String)"PayaraJvmMode.toString.invalid"));
    }

    static {
        LOGGER = PayaraLogger.get(PayaraJvmMode.class);
        length = PayaraJvmMode.values().length;
        stringValuesMap = new HashMap<String, PayaraJvmMode>(length);
        for (PayaraJvmMode mode : PayaraJvmMode.values()) {
            stringValuesMap.put(mode.toString().toUpperCase(), mode);
        }
    }
}

