/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.weblogic.common.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.weblogic.common.api.Version;
import org.netbeans.modules.weblogic.common.api.WebLogicLayout;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DomainConfiguration {
    private static final Logger LOGGER = Logger.getLogger(DomainConfiguration.class.getName());
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 7001;
    private static final int DEFAULT_SECURED_PORT = 7002;
    private static final Pattern DOMAIN_NAME_PATTERN = Pattern.compile("(?:[a-z]+\\:)?name");
    private static final Pattern DOMAIN_VERSION_PATTERN = Pattern.compile("(?:[a-z]+\\:)?domain-version");
    private static final Pattern PRODUCTION_MODE_PATTERN = Pattern.compile("(?:[a-z]+\\:)?production-mode-enabled");
    private static final Pattern LISTEN_ADDRESS_PATTERN = Pattern.compile("(?:[a-z]+\\:)?listen-address");
    private static final Pattern SSL_PATTERN = Pattern.compile("(?:[a-z]+\\:)?ssl");
    private static final Pattern ENABLED_PATTERN = Pattern.compile("(?:[a-z]+\\:)?enabled");
    private static final Pattern LISTEN_PORT_PATTERN = Pattern.compile("(?:[a-z]+\\:)?listen-port");
    private static final Pattern NAME_PATTERN = Pattern.compile("(?:[a-z]+\\:)?name");
    private static final Pattern SERVER_PATTERN = Pattern.compile("(?:[a-z]+\\:)?server");
    private static final Pattern ADMIN_SERVER_PATTERN = Pattern.compile("(?:[a-z]+\\:)?admin-server-name");
    private static final Pattern LOG_PATTERN = Pattern.compile("(?:[a-z]+\\:)?log");
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("(?:[a-z]+\\:)?file-name");
    private final File domain;
    private final File domainConfig;
    private DomainChangeListener domainListener;
    private String name;
    private Version version;
    private String adminServer;
    private String host;
    private int port;
    private boolean secured;
    private boolean production;
    private File logFile;

    private DomainConfiguration(File domain, File domainConfig) {
        this.domain = domain;
        this.domainConfig = domainConfig;
    }

    @CheckForNull
    static DomainConfiguration getInstance(File domain, boolean listen) {
        File domainConfig = WebLogicLayout.getDomainConfigFile(domain);
        if (!domainConfig.isFile()) {
            return null;
        }
        DomainConfiguration instance = new DomainConfiguration(domain, domainConfig);
        if (listen) {
            instance.init();
        }
        instance.reload();
        return instance;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized Version getVersion() {
        return this.version;
    }

    public synchronized String getAdminServer() {
        return this.adminServer;
    }

    public synchronized String getHost() {
        return this.host;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized boolean isSecured() {
        return this.secured;
    }

    public synchronized boolean isProduction() {
        return this.production;
    }

    public synchronized File getLogFile() {
        return this.logFile;
    }

    private void init() {
        if (this.domainConfig != null) {
            this.domainListener = new DomainChangeListener();
            FileUtil.addFileChangeListener((FileChangeListener)this.domainListener, (File)this.domainConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reload() {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.domainConfig);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            LinkedHashMap<String, Server> servers = new LinkedHashMap<String, Server>();
            block13: for (int j = 0; j < children.getLength(); ++j) {
                boolean parsedServerSecured;
                int parsedServerPort;
                NodeList nl;
                Node child = children.item(j);
                if (DOMAIN_NAME_PATTERN.matcher(child.getNodeName()).matches()) {
                    String domainName;
                    this.name = domainName = child.getFirstChild().getNodeValue();
                    continue;
                }
                if (DOMAIN_VERSION_PATTERN.matcher(child.getNodeName()).matches()) {
                    String domainVersion = child.getFirstChild().getNodeValue();
                    if (domainVersion != null) {
                        this.version = Version.fromJsr277OrDottedNotationWithFallback(domainVersion);
                        continue;
                    }
                    this.version = null;
                    continue;
                }
                if (PRODUCTION_MODE_PATTERN.matcher(child.getNodeName()).matches()) {
                    String domainProduction = child.getFirstChild().getNodeValue();
                    this.production = Boolean.parseBoolean(domainProduction);
                    continue;
                }
                if (ADMIN_SERVER_PATTERN.matcher(child.getNodeName()).matches()) {
                    this.adminServer = child.getFirstChild().getNodeValue();
                    continue;
                }
                if (LOG_PATTERN.matcher(child.getNodeName()).matches()) {
                    nl = child.getChildNodes();
                    for (int k = 0; k < nl.getLength(); ++k) {
                        Node ch = nl.item(k);
                        if (!FILE_NAME_PATTERN.matcher(ch.getNodeName()).matches()) continue;
                        String value = ch.getFirstChild().getNodeValue();
                        this.logFile = new File(value);
                        continue block13;
                    }
                    continue;
                }
                if (!SERVER_PATTERN.matcher(child.getNodeName()).matches()) continue;
                nl = child.getChildNodes();
                String serverName = null;
                String serverPort = null;
                String serverHost = null;
                String serverSecured = null;
                for (int k = 0; k < nl.getLength(); ++k) {
                    Node enabled;
                    Node ch = nl.item(k);
                    if (NAME_PATTERN.matcher(ch.getNodeName()).matches()) {
                        serverName = ch.getFirstChild().getNodeValue();
                    }
                    if (LISTEN_PORT_PATTERN.matcher(ch.getNodeName()).matches()) {
                        serverPort = ch.getFirstChild().getNodeValue();
                    }
                    if (LISTEN_ADDRESS_PATTERN.matcher(ch.getNodeName()).matches() && ch.hasChildNodes()) {
                        serverHost = ch.getFirstChild().getNodeValue();
                    }
                    if (!SSL_PATTERN.matcher(ch.getNodeName()).matches() || !ENABLED_PATTERN.matcher((enabled = ch.getFirstChild()).getNodeName()).matches()) continue;
                    serverSecured = ch.getFirstChild().getNodeValue();
                }
                if (serverName != null) {
                    serverName = serverName.trim();
                }
                if (serverHost != null) {
                    serverHost = serverHost.trim();
                }
                if (serverPort != null) {
                    serverPort = serverPort.trim();
                }
                if (serverSecured != null) {
                    serverSecured = serverSecured.trim();
                }
                if (serverName == null || serverName.isEmpty()) continue;
                if (serverHost == null || serverHost.isEmpty()) {
                    serverHost = DEFAULT_HOST;
                }
                int n = parsedServerPort = (parsedServerSecured = false) ? 7002 : 7001;
                if (serverPort != null && !serverPort.isEmpty()) {
                    try {
                        parsedServerPort = Integer.parseInt(serverPort);
                    }
                    catch (NumberFormatException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                }
                servers.put(serverName, new Server(serverName, serverHost, parsedServerPort, parsedServerSecured));
            }
            if (this.name != null && this.name.isEmpty()) {
                this.name = null;
            }
            Server admin = null;
            if (this.adminServer != null) {
                admin = (Server)servers.get(this.adminServer);
            }
            if (admin == null && !servers.isEmpty()) {
                admin = (Server)servers.entrySet().iterator().next().getValue();
            }
            if (admin != null) {
                this.host = admin.getHost();
                this.port = admin.getPort();
                this.secured = admin.isSecured();
            } else {
                this.host = DEFAULT_HOST;
                this.port = 7001;
                this.secured = false;
            }
            if (this.logFile == null) {
                this.logFile = new File("logs" + File.separator + this.name + ".log");
            }
            if (!this.logFile.isAbsolute()) {
                this.logFile = admin != null ? new File(this.domain, "servers" + File.separator + admin.getName() + File.separator + this.logFile.getPath()) : new File(this.domain, "servers" + File.separator + "AdminServer" + File.separator + this.logFile.getPath());
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
    }

    private class DomainChangeListener
    implements FileChangeListener {
        private DomainChangeListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            DomainConfiguration.this.reload();
        }

        public void fileDataCreated(FileEvent fe) {
            DomainConfiguration.this.reload();
        }

        public void fileDeleted(FileEvent fe) {
            DomainConfiguration.this.reload();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
            DomainConfiguration.this.reload();
        }
    }

    private static class Server {
        private final String name;
        private final String host;
        private final int port;
        private final boolean secured;

        public Server(String name, String host, int port, boolean secured) {
            this.name = name;
            this.host = host;
            this.port = port;
            this.secured = secured;
        }

        public String getName() {
            return this.name;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isSecured() {
            return this.secured;
        }
    }
}

