/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WrappedImportKey
extends ExplicitlySetBmcModel {
    @JsonProperty(value="keyMaterial")
    private final String keyMaterial;
    @JsonProperty(value="wrappingAlgorithm")
    private final WrappingAlgorithm wrappingAlgorithm;

    @Deprecated
    @ConstructorProperties(value={"keyMaterial", "wrappingAlgorithm"})
    public WrappedImportKey(String keyMaterial, WrappingAlgorithm wrappingAlgorithm) {
        this.keyMaterial = keyMaterial;
        this.wrappingAlgorithm = wrappingAlgorithm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKeyMaterial() {
        return this.keyMaterial;
    }

    public WrappingAlgorithm getWrappingAlgorithm() {
        return this.wrappingAlgorithm;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WrappedImportKey(");
        sb.append("super=").append(super.toString());
        sb.append("keyMaterial=").append(String.valueOf(this.keyMaterial));
        sb.append(", wrappingAlgorithm=").append(String.valueOf((Object)this.wrappingAlgorithm));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WrappedImportKey)) {
            return false;
        }
        WrappedImportKey other = (WrappedImportKey)((Object)o);
        return Objects.equals(this.keyMaterial, other.keyMaterial) && Objects.equals((Object)this.wrappingAlgorithm, (Object)other.wrappingAlgorithm) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.keyMaterial == null ? 43 : this.keyMaterial.hashCode());
        result = result * 59 + (this.wrappingAlgorithm == null ? 43 : this.wrappingAlgorithm.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum WrappingAlgorithm implements BmcEnum
    {
        RsaOaepSha256("RSA_OAEP_SHA256"),
        RsaOaepAesSha256("RSA_OAEP_AES_SHA256");

        private final String value;
        private static Map<String, WrappingAlgorithm> map;

        private WrappingAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static WrappingAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid WrappingAlgorithm: " + key);
        }

        static {
            map = new HashMap<String, WrappingAlgorithm>();
            for (WrappingAlgorithm v : WrappingAlgorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="keyMaterial")
        private String keyMaterial;
        @JsonProperty(value="wrappingAlgorithm")
        private WrappingAlgorithm wrappingAlgorithm;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder keyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
            this.__explicitlySet__.add("keyMaterial");
            return this;
        }

        public Builder wrappingAlgorithm(WrappingAlgorithm wrappingAlgorithm) {
            this.wrappingAlgorithm = wrappingAlgorithm;
            this.__explicitlySet__.add("wrappingAlgorithm");
            return this;
        }

        public WrappedImportKey build() {
            WrappedImportKey model = new WrappedImportKey(this.keyMaterial, this.wrappingAlgorithm);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WrappedImportKey model) {
            if (model.wasPropertyExplicitlySet("keyMaterial")) {
                this.keyMaterial(model.getKeyMaterial());
            }
            if (model.wasPropertyExplicitlySet("wrappingAlgorithm")) {
                this.wrappingAlgorithm(model.getWrappingAlgorithm());
            }
            return this;
        }
    }
}

