/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.keymanagement.model.GenerateKeyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GenerateDataEncryptionKeyRequest
extends BmcRequest<GenerateKeyDetails> {
    private GenerateKeyDetails generateKeyDetails;
    private String opcRequestId;

    public GenerateKeyDetails getGenerateKeyDetails() {
        return this.generateKeyDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public GenerateKeyDetails getBody$() {
        return this.generateKeyDetails;
    }

    public Builder toBuilder() {
        return new Builder().generateKeyDetails(this.generateKeyDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",generateKeyDetails=").append(String.valueOf((Object)this.generateKeyDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateDataEncryptionKeyRequest)) {
            return false;
        }
        GenerateDataEncryptionKeyRequest other = (GenerateDataEncryptionKeyRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.generateKeyDetails, (Object)other.generateKeyDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.generateKeyDetails == null ? 43 : this.generateKeyDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GenerateDataEncryptionKeyRequest, GenerateKeyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private GenerateKeyDetails generateKeyDetails = null;
        private String opcRequestId = null;

        public Builder generateKeyDetails(GenerateKeyDetails generateKeyDetails) {
            this.generateKeyDetails = generateKeyDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GenerateDataEncryptionKeyRequest o) {
            this.generateKeyDetails(o.getGenerateKeyDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GenerateDataEncryptionKeyRequest build() {
            GenerateDataEncryptionKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(GenerateKeyDetails body) {
            this.generateKeyDetails(body);
            return this;
        }

        public GenerateDataEncryptionKeyRequest buildWithoutInvocationCallback() {
            GenerateDataEncryptionKeyRequest request = new GenerateDataEncryptionKeyRequest();
            request.generateKeyDetails = this.generateKeyDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

