/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.cookies.ErrorLocator;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SectionPanel
extends JPanel
implements NodeSectionPanel,
ErrorLocator {
    private SectionView sectionView;
    private String title;
    private Node node;
    private boolean active;
    private SectionInnerPanel innerPanel;
    private Object key;
    private int index;
    private static final Image IMAGE_UNSELECTED = ImageUtilities.loadImage((String)"/org/netbeans/modules/xml/multiview/resources/plus.gif");
    private static final Image IMAGE_SELECTED = ImageUtilities.loadImage((String)"/org/netbeans/modules/xml/multiview/resources/minus.gif");
    private FocusListener sectionFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            SectionPanel.this.setActive(true);
        }
    };
    private ToolBarDesignEditor toolBarDesignEditor;
    private JPanel actionPanel;
    private JSeparator fillerEnd;
    private JSeparator fillerLine;
    private JToggleButton foldButton;
    private JSeparator headerSeparator;
    private JButton titleButton;
    private JPanel titlePanel;
    private HeaderButton[] headerButtons;

    public SectionPanel(SectionView sectionView, Node explorerNode, Object key) {
        this(sectionView, explorerNode, key, false);
    }

    public SectionPanel(SectionView sectionView, Node explorerNode, Object key, boolean autoExpand) {
        this(sectionView, explorerNode, explorerNode.getDisplayName(), key, autoExpand);
    }

    public SectionPanel(SectionView sectionView, Node node, String title, Object key) {
        this(sectionView, node, title, key, false);
    }

    public SectionPanel(SectionView sectionView, Node node, String title, Object key, boolean autoExpand, boolean addFocusListenerToButton) {
        this.sectionView = sectionView;
        this.title = title;
        this.node = node;
        this.key = key;
        this.initComponents();
        this.foldButton.setIcon(new ImageIcon(IMAGE_UNSELECTED));
        this.foldButton.setSelectedIcon(new ImageIcon(IMAGE_SELECTED));
        this.headerSeparator.setForeground(SectionVisualTheme.getSectionHeaderLineColor());
        this.fillerLine.setForeground(SectionVisualTheme.getFoldLineColor());
        this.fillerEnd.setForeground(SectionVisualTheme.getFoldLineColor());
        this.fillerLine.setVisible(false);
        this.fillerEnd.setVisible(false);
        this.titleButton.setText(title);
        this.titleButton.setToolTipText(this.titleButton.getText());
        this.titleButton.addMouseListener((MouseListener)new MouseUtils.PopupMouseAdapter(){

            protected void showPopup(MouseEvent e) {
                if (!SectionPanel.this.isActive()) {
                    SectionPanel.this.setActive(true);
                }
                JPopupMenu popup = SectionPanel.this.getNode().getContextMenu();
                popup.show(SectionPanel.this.titleButton, e.getX(), e.getY());
            }
        });
        if (autoExpand) {
            this.open();
        }
        if (addFocusListenerToButton) {
            this.titleButton.addFocusListener(this.sectionFocusListener);
        }
    }

    public SectionPanel(SectionView sectionView, Node node, String title, Object key, boolean autoExpand) {
        this(sectionView, node, title, key, autoExpand, true);
    }

    public SectionView getSectionView() {
        return this.sectionView;
    }

    protected void openInnerPanel() {
        if (this.toolBarDesignEditor == null) {
            this.toolBarDesignEditor = this.sectionView.getToolBarDesignEditor();
            if (this.toolBarDesignEditor != null) {
                this.toolBarDesignEditor.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                        if ("Flush Data".equals(evt.getPropertyName()) && evt.getNewValue() == null && SectionPanel.this.innerPanel != null && !SectionPanel.this.innerPanel.canClose()) {
                            throw new PropertyVetoException("", evt);
                        }
                    }
                });
            }
        }
        if (this.innerPanel != null) {
            return;
        }
        this.innerPanel = this.createInnerpanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.fillerLine.setVisible(true);
        this.fillerEnd.setVisible(true);
        this.innerPanel.addFocusListener(this.sectionFocusListener);
        this.add((Component)this.innerPanel, gridBagConstraints);
        Utils.scrollToVisible(this);
    }

    protected SectionInnerPanel createInnerpanel() {
        return this.sectionView.getInnerPanelFactory().createInnerPanel(this.key);
    }

    protected void closeInnerPanel() {
        if (this.innerPanel != null) {
            this.innerPanel.removeFocusListener(this.sectionFocusListener);
            this.remove(this.innerPanel);
            this.innerPanel = null;
        }
        this.fillerLine.setVisible(false);
        this.fillerEnd.setVisible(false);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        Mnemonics.setLocalizedText((AbstractButton)this.titleButton, (String)title);
        this.title = this.titleButton.getText();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void open() {
        this.foldButton.setSelected(true);
        this.openInnerPanel();
    }

    @Override
    public void scroll() {
        Utils.scrollToVisible(this);
    }

    @Override
    public void setActive(boolean active) {
        if (active && !this.equals(this.sectionView.getActivePanel())) {
            this.sectionView.sectionSelected(true);
            this.sectionView.setActivePanel(this);
            this.sectionView.selectNode(this.node);
        }
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    private void initComponents() {
        this.foldButton = new JToggleButton();
        this.headerSeparator = new JSeparator();
        this.actionPanel = new JPanel();
        this.fillerLine = new JSeparator();
        this.fillerEnd = new JSeparator();
        this.titlePanel = new JPanel();
        this.titleButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.foldButton.setToolTipText(NbBundle.getMessage(SectionPanel.class, (String)"HINT_FOLD_BUTTON"));
        this.foldButton.setBorder(null);
        this.foldButton.setBorderPainted(false);
        this.foldButton.setContentAreaFilled(false);
        this.foldButton.setFocusPainted(false);
        this.foldButton.setFocusable(false);
        this.foldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SectionPanel.this.foldButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(6, 2, 0, 2);
        this.add((Component)this.foldButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.headerSeparator, gridBagConstraints);
        this.actionPanel.setLayout(new FlowLayout(2, 2, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.actionPanel, gridBagConstraints);
        this.fillerLine.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.fillerLine, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 6, 0, 2);
        this.add((Component)this.fillerEnd, gridBagConstraints);
        this.titlePanel.setLayout(new BorderLayout());
        this.titleButton.setFont(this.titleButton.getFont().deriveFont(this.titleButton.getFont().getStyle() | 1, this.titleButton.getFont().getSize() + 2));
        this.titleButton.setBorderPainted(false);
        this.titleButton.setContentAreaFilled(false);
        this.titleButton.setFocusPainted(false);
        this.titleButton.setHorizontalAlignment(2);
        this.titleButton.setMargin(new Insets(0, 4, 0, 4));
        this.titleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SectionPanel.this.titleButtonActionPerformed(evt);
            }
        });
        this.titlePanel.add((Component)this.titleButton, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.titlePanel, gridBagConstraints);
    }

    private void titleButtonActionPerformed(ActionEvent evt) {
        if (!this.foldButton.isSelected()) {
            this.openInnerPanel();
            this.foldButton.setSelected(true);
        } else if (this.isActive()) {
            this.closeInnerPanel();
            this.foldButton.setSelected(false);
        }
        if (!this.isActive()) {
            this.setActive(true);
        }
    }

    private void foldButtonActionPerformed(ActionEvent evt) {
        if (this.foldButton.isSelected()) {
            this.openInnerPanel();
        } else {
            this.closeInnerPanel();
        }
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public JComponent getErrorComponent(String errorId) {
        if (this.innerPanel != null) {
            return this.innerPanel.getErrorComponent(errorId);
        }
        return null;
    }

    public SectionInnerPanel getInnerPanel() {
        return this.innerPanel;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setHeaderActions(Action[] actions) {
        this.headerButtons = new HeaderButton[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            this.headerButtons[i] = new HeaderButton(this, actions[i]);
            this.headerButtons[i].setOpaque(false);
            this.actionPanel.add(this.headerButtons[i]);
        }
    }

    public HeaderButton[] getHeaderButtons() {
        return this.headerButtons;
    }

    protected JComponent getFillerLine() {
        return this.fillerLine;
    }

    protected JComponent getFillerEnd() {
        return this.fillerEnd;
    }

    protected JToggleButton getFoldButton() {
        return this.foldButton;
    }

    protected JSeparator getHeaderSeparator() {
        return this.headerSeparator;
    }

    protected JButton getTitleButton() {
        return this.titleButton;
    }

    public static class HeaderButton
    extends JButton {
        private SectionPanel panel;

        public HeaderButton(SectionPanel panel, Action action) {
            super(action);
            this.panel = panel;
            this.setMargin(new Insets(0, 14, 0, 14));
        }

        public SectionPanel getSectionPanel() {
            return this.panel;
        }
    }
}

