/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.wizard;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.j2seembedded.platform.ConnectionMethod;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatform;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatformProbe;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatformProvider;
import org.netbeans.modules.java.j2seembedded.wizard.SetUpRemotePlatform;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;

class RemotePlatformIt
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    public static final String PROP_DISPLAYNAME = "displayName";
    public static final String PROP_HOST = "host";
    public static final String PROP_PORT = "port";
    public static final String PROP_USERNAME = "username";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_KEYFILE = "keyfile";
    public static final String PROP_PASSPHRASE = "passphrase";
    public static final String PROP_JREPATH = "jrePath";
    public static final String PROP_WORKINGDIR = "workingDir";
    public static final String PROP_SYS_PROPERTIES = "sysProperties";
    public static final String PROP_BUILDSCRIPT = "buildscript";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private WizardDescriptor wizard;
    private String[] names;
    private int index;

    RemotePlatformIt() {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public String name() {
        return this.names[this.index];
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        ++this.index;
    }

    public void previousPanel() {
        --this.index;
    }

    public void addChangeListener(@NonNull ChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(@NonNull ChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.changeSupport.removeChangeListener(listener);
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.panels = new WizardDescriptor.Panel[]{new SetUpRemotePlatform.Panel()};
        this.names = new String[]{NbBundle.getMessage(RemotePlatformIt.class, (String)"TXT_SetUpRemotePlatform")};
        this.index = 0;
        ((JComponent)this.panels[0].getComponent()).putClientProperty("WizardPanel_contentData", this.names);
    }

    public Set<JavaPlatform> instantiate() throws IOException {
        String displayName = (String)this.wizard.getProperty(PROP_DISPLAYNAME);
        String host = (String)this.wizard.getProperty(PROP_HOST);
        int port = (Integer)this.wizard.getProperty(PROP_PORT);
        String username = (String)this.wizard.getProperty(PROP_USERNAME);
        String password = null;
        String keyFile = null;
        String passphrase = null;
        if (this.wizard.getProperty(PROP_PASSWORD) != null) {
            password = (String)this.wizard.getProperty(PROP_PASSWORD);
        } else {
            keyFile = (String)this.wizard.getProperty(PROP_KEYFILE);
            passphrase = (String)this.wizard.getProperty(PROP_PASSPHRASE);
        }
        String jrePath = (String)this.wizard.getProperty(PROP_JREPATH);
        String workingDir = this.wizard.getProperty(PROP_WORKINGDIR) != null && ((String)this.wizard.getProperty(PROP_WORKINGDIR)).length() > 0 ? (String)this.wizard.getProperty(PROP_WORKINGDIR) : "/home/" + username + "/NetBeansProjects/";
        Pair<Map<String, String>, Map<String, String>> p = RemotePlatformProbe.getSystemProperties((Properties)this.wizard.getProperty(PROP_SYS_PROPERTIES));
        RemotePlatform prototype = RemotePlatform.prototype(displayName, (Map)p.first(), (Map)p.second());
        try {
            prototype.setInstallFolder(new URI(jrePath));
            prototype.setWorkFolder(new URI(workingDir));
            ConnectionMethod cm = password != null ? ConnectionMethod.sshPassword(host, port, username, password) : ConnectionMethod.sshKey(host, port, username, new File(keyFile), passphrase);
            prototype.setConnectionMethod(cm);
            return Collections.singleton(RemotePlatformProvider.createNewPlatform(prototype));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
        this.names = null;
        this.index = -1;
        File buildScript = (File)wizard.getProperty(PROP_BUILDSCRIPT);
        if (buildScript != null) {
            buildScript.delete();
        }
    }
}

