/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.spi.java.queries.MultipleRootsUnitTestForSourceQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class UnitTestForSourceQueryImpl
implements MultipleRootsUnitTestForSourceQueryImplementation {
    private NbModuleProject project;

    public UnitTestForSourceQueryImpl(NbModuleProject project) {
        this.project = project;
    }

    public URL[] findUnitTests(FileObject source) {
        return this.find(source, "src.dir", "test.unit.src.dir");
    }

    public URL[] findSources(FileObject unitTest) {
        return this.find(unitTest, "test.unit.src.dir", "src.dir");
    }

    private URL[] find(FileObject file, String from, String to) {
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        if (p == null) {
            return null;
        }
        AntProjectHelper helper = this.project.getHelper();
        String val = this.project.evaluator().getProperty(from);
        assert (val != null) : "No value for " + from + " in " + String.valueOf(this.project);
        FileObject fromRoot = helper.resolveFileObject(val);
        if (!file.equals(fromRoot)) {
            return null;
        }
        val = this.project.evaluator().getProperty(to);
        assert (val != null) : "No value for " + to + " in " + String.valueOf(this.project);
        try {
            File f = helper.resolveFile(val);
            if (!f.exists()) {
                URI u = Utilities.toURI((File)f);
                String path = u.getPath();
                if (!path.endsWith("/")) {
                    path = path.concat("/");
                }
                try {
                    u = new URI(u.getScheme(), u.getHost(), path, u.getFragment());
                    return new URL[]{u.toURL()};
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(UnitTestForSourceQueryImpl.class.getName()).log(Level.WARNING, "Problems getting URI for " + String.valueOf(f), ex);
                }
            }
            return new URL[]{Utilities.toURI((File)f).toURL()};
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }
}

