/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.modules.apisupport.project.universe.JavadocRootsProvider;
import org.openide.util.Parameters;

public final class JavadocRootsSupport
implements JavadocRootsProvider {
    private URL[] javadocRoots;
    private JavadocRootsProvider delegate;
    private PropertyChangeSupport pcs;

    public JavadocRootsSupport(URL[] javadocRoots, JavadocRootsProvider delegate) {
        if (javadocRoots == null) {
            throw new NullPointerException("javadocRoots must not be null.");
        }
        this.javadocRoots = javadocRoots;
        this.pcs = new PropertyChangeSupport(this);
        this.delegate = delegate;
    }

    @Override
    public URL[] getDefaultJavadocRoots() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getDefaultJavadocRoots();
    }

    @Override
    public URL[] getJavadocRoots() {
        URL[] defaults;
        if (this.javadocRoots.length == 0 && (defaults = this.getDefaultJavadocRoots()) != null) {
            return defaults;
        }
        return this.javadocRoots;
    }

    private void maybeUpdateDefaultJavadoc() {
        URL[] defaults;
        if (this.javadocRoots.length == 0 && (defaults = this.getDefaultJavadocRoots()) != null) {
            this.javadocRoots = defaults;
            this.pcs.firePropertyChange("javadocRoots", null, null);
        }
    }

    @Override
    public void addJavadocRoot(URL root) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"root", (Object)root);
        if (JavadocRootsSupport.containsRoot(this, root)) {
            throw new IllegalArgumentException("Root '" + String.valueOf(root) + "' already present in javadoc.");
        }
        this.maybeUpdateDefaultJavadoc();
        URL[] newJavadocRoots = new URL[this.javadocRoots.length + 1];
        System.arraycopy(this.javadocRoots, 0, newJavadocRoots, 0, this.javadocRoots.length);
        newJavadocRoots[this.javadocRoots.length] = root;
        this.setJavadocRootsInternal(newJavadocRoots);
    }

    @Override
    public void removeJavadocRoots(URL[] urlsToRemove) throws IOException {
        this.maybeUpdateDefaultJavadoc();
        ArrayList<URL> newJavadocs = new ArrayList<URL>(Arrays.asList(this.javadocRoots));
        newJavadocs.removeAll(Arrays.asList(urlsToRemove));
        assert (newJavadocs.size() + urlsToRemove.length >= this.javadocRoots.length) : "Too many roots removed, one of " + Arrays.toString(urlsToRemove) + " was contained more than once";
        URL[] javadocs = new URL[newJavadocs.size()];
        this.setJavadocRootsInternal(newJavadocs.toArray(javadocs));
    }

    @Override
    public void moveJavadocRootUp(int indexToUp) throws IOException {
        this.maybeUpdateDefaultJavadoc();
        if (indexToUp <= 0) {
            return;
        }
        URL[] newJavadocRoots = new URL[this.javadocRoots.length];
        System.arraycopy(this.javadocRoots, 0, newJavadocRoots, 0, this.javadocRoots.length);
        newJavadocRoots[indexToUp - 1] = this.javadocRoots[indexToUp];
        newJavadocRoots[indexToUp] = this.javadocRoots[indexToUp - 1];
        this.setJavadocRootsInternal(newJavadocRoots);
    }

    @Override
    public void moveJavadocRootDown(int indexToDown) throws IOException {
        this.maybeUpdateDefaultJavadoc();
        if (indexToDown >= this.javadocRoots.length - 1) {
            return;
        }
        URL[] newJavadocRoots = new URL[this.javadocRoots.length];
        System.arraycopy(this.javadocRoots, 0, newJavadocRoots, 0, this.javadocRoots.length);
        newJavadocRoots[indexToDown + 1] = this.javadocRoots[indexToDown];
        newJavadocRoots[indexToDown] = this.javadocRoots[indexToDown + 1];
        this.setJavadocRootsInternal(newJavadocRoots);
    }

    private void setJavadocRootsInternal(URL[] roots) throws IOException {
        if (this.delegate != null) {
            this.delegate.setJavadocRoots(roots);
        } else {
            this.setJavadocRoots(roots);
        }
    }

    @Override
    public void setJavadocRoots(URL[] roots) throws IOException {
        this.javadocRoots = roots;
        this.pcs.firePropertyChange("javadocRoots", null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public static boolean containsRoot(JavadocRootsProvider provider, URL root) {
        Parameters.notNull((CharSequence)"provider", (Object)provider);
        Parameters.notNull((CharSequence)"root", (Object)root);
        for (URL r2 : provider.getJavadocRoots()) {
            if (!root.equals(r2)) continue;
            return true;
        }
        return false;
    }
}

