/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.lucene.search.IndexSearcher;
import org.apache.maven.model.Dependency;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.ui.Bundle;
import org.netbeans.modules.maven.hints.ui.nodes.ArtifactNode;
import org.netbeans.modules.maven.hints.ui.nodes.VersionNode;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class SearchDependencyUI
extends JPanel
implements ExplorerManager.Provider {
    private static final String WAIT = "org/netbeans/modules/maven/hints/wait.gif";
    private static final String EMPTY_IMAGE = "org/netbeans/modules/maven/hints/empty.png";
    private ExplorerManager explorerManager = new ExplorerManager();
    private JButton addButton = new JButton(Bundle.BTN_Add());
    private BeanTreeView beanTreeView;
    private NBVersionInfo nbvi;
    private Tsk task = null;
    private static final RequestProcessor RP = new RequestProcessor(SearchDependencyUI.class.getName(), 10);
    private Project project;
    private ResultsRootNode resultsRootNode;
    private JCheckBox cbSearchLocal;
    private JLabel lblClassName;
    private JLabel lblMatchingArtifacts;
    private JTextField lblSelected;
    private JScrollPane treeView;
    private JTextField txtClassName;
    private static Node noResultsNode;
    private static Node searchingNode;
    private static Node tooGeneralNode;

    public SearchDependencyUI(String clazz, Project mavProj) {
        this.initComponents();
        this.project = mavProj;
        this.beanTreeView = (BeanTreeView)this.treeView;
        this.beanTreeView.setPopupAllowed(false);
        this.beanTreeView.setRootVisible(false);
        this.beanTreeView.setDefaultActionAllowed(true);
        this.addButton.setEnabled(false);
        this.txtClassName.setText(clazz);
        this.txtClassName.selectAll();
        this.explorerManager.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("selectedNodes")) {
                Node[] selectedNodes;
                for (Node node : selectedNodes = this.explorerManager.getSelectedNodes()) {
                    if (node instanceof VersionNode) {
                        this.nbvi = ((VersionNode)node).getNBVersionInfo();
                        break;
                    }
                    if (!(node instanceof ArtifactNode)) continue;
                    ArtifactNode an = (ArtifactNode)node;
                    List<NBVersionInfo> infos = an.getVersionInfos();
                    this.nbvi = infos.isEmpty() ? null : infos.get(0);
                }
                if (this.nbvi != null) {
                    this.lblSelected.setText(this.nbvi.getGroupId() + " : " + this.nbvi.getArtifactId() + " : " + this.nbvi.getVersion() + " [ " + this.nbvi.getType() + (String)(this.nbvi.getClassifier() != null ? "," + this.nbvi.getClassifier() : "") + " ]");
                } else {
                    this.lblSelected.setText(null);
                }
                this.addButton.setEnabled(this.nbvi != null);
            }
        });
        this.resultsRootNode = new ResultsRootNode();
        this.explorerManager.setRootContext((Node)this.resultsRootNode);
        this.createSearchTask();
        this.load();
        this.txtClassName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchDependencyUI.this.load();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchDependencyUI.this.load();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchDependencyUI.this.load();
            }
        });
    }

    public NBVersionInfo getSelectedVersion() {
        return this.nbvi;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    private RequestProcessor.Task createSearchTask() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = new Tsk();
        return RP.create((Runnable)this.task, true);
    }

    public final synchronized void load() {
        this.createSearchTask().schedule(500);
    }

    public String getClassSearchName() {
        return this.txtClassName.getText().trim();
    }

    private void initComponents() {
        this.lblClassName = new JLabel();
        this.txtClassName = new JTextField();
        this.treeView = new BeanTreeView();
        this.lblMatchingArtifacts = new JLabel();
        this.cbSearchLocal = new JCheckBox();
        this.lblSelected = new JTextField();
        this.lblClassName.setText(NbBundle.getMessage(SearchDependencyUI.class, (String)"LBL_Class_Name"));
        this.treeView.setBorder(BorderFactory.createEtchedBorder(null, UIManager.getDefaults().getColor("ComboBox.selectionBackground")));
        this.lblMatchingArtifacts.setText(NbBundle.getMessage(SearchDependencyUI.class, (String)"LBL_Matching_artifacts"));
        this.cbSearchLocal.setText(NbBundle.getMessage(SearchDependencyUI.class, (String)"SearchDependencyUI.cbSearchLocal.text"));
        this.cbSearchLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDependencyUI.this.cbSearchLocalActionPerformed(evt);
            }
        });
        this.lblSelected.setEditable(false);
        this.lblSelected.setText(NbBundle.getMessage(SearchDependencyUI.class, (String)"SearchDependencyUI.lblSelected.text"));
        this.lblSelected.setBorder(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.treeView).addComponent(this.lblMatchingArtifacts, -1, -1, Short.MAX_VALUE).addComponent(this.lblClassName, -1, 430, Short.MAX_VALUE).addComponent(this.txtClassName).addGroup(layout.createSequentialGroup().addComponent(this.lblSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSearchLocal))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblClassName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtClassName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMatchingArtifacts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.treeView, -1, 284, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbSearchLocal).addComponent(this.lblSelected)).addContainerGap()));
    }

    private void cbSearchLocalActionPerformed(ActionEvent evt) {
        this.load();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private static Node getSearchingNode() {
        if (searchingNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)SearchDependencyUI.WAIT);
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Searching");
            nd.setDisplayName(Bundle.Node_Loading());
            searchingNode = nd;
        }
        return new FilterNode(searchingNode, Children.LEAF);
    }

    public static Node getNoResultsNode() {
        if (noResultsNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)SearchDependencyUI.EMPTY_IMAGE);
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Empty");
            nd.setDisplayName(Bundle.Node_Empty());
            noResultsNode = nd;
        }
        return new FilterNode(noResultsNode, Children.LEAF);
    }

    private static Node getTooGeneralNode() {
        if (tooGeneralNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)SearchDependencyUI.EMPTY_IMAGE);
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Too General");
            nd.setDisplayName(Bundle.Node_TooGeneral());
            tooGeneralNode = nd;
        }
        return new FilterNode(tooGeneralNode, Children.LEAF);
    }

    void updateResult(List<NBVersionInfo> infos, boolean partial) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (NBVersionInfo ver : infos) {
            String key = ver.getGroupId() + " : " + ver.getArtifactId();
            map.computeIfAbsent(key, k -> new ArrayList()).add(ver);
        }
        ArrayList keyList = new ArrayList(map.keySet());
        keyList.sort(new HeuristicsComparator());
        SwingUtilities.invokeLater(() -> this.updateResultNodes(keyList, map, partial));
    }

    private void updateResultNodes(List<String> keyList, Map<String, List<NBVersionInfo>> map, boolean partial) {
        if (keyList.size() > 0) {
            HashMap<String, Node> currentNodes = new HashMap<String, Node>();
            for (Object nd : this.resultsRootNode.getChildren().getNodes()) {
                currentNodes.put(nd.getName(), (Node)nd);
            }
            ArrayList<Node> newNodes = new ArrayList<Node>(keyList.size() + 1);
            if (partial) {
                newNodes.add(SearchDependencyUI.getSearchingNode());
            }
            for (String key : keyList) {
                Object nd;
                nd = (Node)currentNodes.get(key);
                if (null != nd) {
                    ((ArtifactNode)((Object)nd)).setVersionInfos(map.get(key));
                } else {
                    nd = new ArtifactNode(key, map.get(key));
                }
                newNodes.add((Node)nd);
            }
            this.resultsRootNode.setNewChildren(newNodes);
        } else if (partial) {
            this.resultsRootNode.setOneChild(SearchDependencyUI.getSearchingNode());
        } else {
            this.resultsRootNode.setOneChild(SearchDependencyUI.getNoResultsNode());
        }
    }

    private class Tsk
    implements Runnable,
    Cancellable {
        private volatile boolean cancelled = false;

        private Tsk() {
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            String[] search = new String[1];
            try {
                SwingUtilities.invokeAndWait(() -> {
                    SearchDependencyUI.this.lblSelected.setText(null);
                    search[0] = SearchDependencyUI.this.getClassSearchName();
                });
            }
            catch (InterruptedException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            SwingUtilities.invokeLater(() -> SearchDependencyUI.this.resultsRootNode.setOneChild(SearchDependencyUI.getSearchingNode()));
            if (search[0].length() > 0) {
                try {
                    RepositoryQueries.Result result = RepositoryQueries.findVersionsByClassResult((String)search[0], SearchDependencyUI.this.cbSearchLocal.isSelected() ? Arrays.asList(RepositoryPreferences.getInstance().getLocalRepository()) : null);
                    if (this.cancelled) {
                        return;
                    }
                    SearchDependencyUI.this.updateResult(result.getResults(), result.isPartial());
                    if (result.isPartial()) {
                        result.waitForSkipped();
                        if (this.cancelled) {
                            return;
                        }
                        SearchDependencyUI.this.updateResult(result.getResults(), false);
                    }
                }
                catch (IndexSearcher.TooManyClauses exc) {
                    if (this.cancelled) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> SearchDependencyUI.this.resultsRootNode.setOneChild(SearchDependencyUI.getTooGeneralNode()));
                }
                catch (OutOfMemoryError oome) {
                    if (this.cancelled) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> SearchDependencyUI.this.resultsRootNode.setOneChild(SearchDependencyUI.getTooGeneralNode()));
                }
            } else {
                SwingUtilities.invokeLater(() -> SearchDependencyUI.this.resultsRootNode.setOneChild(SearchDependencyUI.getNoResultsNode()));
            }
        }

        public synchronized boolean cancel() {
            this.cancelled = true;
            return true;
        }
    }

    private class ResultsRootNode
    extends AbstractNode {
        private ResultsRootChildren resultsChildren;

        public ResultsRootNode() {
            this(new InstanceContent());
        }

        private ResultsRootNode(InstanceContent content) {
            super((Children)new ResultsRootChildren(), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
            content.add((Object)this);
            this.resultsChildren = (ResultsRootChildren)this.getChildren();
        }

        public void setOneChild(Node n) {
            ArrayList<Node> ch = new ArrayList<Node>(1);
            ch.add(n);
            this.setNewChildren(ch);
        }

        public void setNewChildren(List<Node> ch) {
            this.resultsChildren.setNewChildren(ch);
        }
    }

    private class HeuristicsComparator
    implements Comparator<String> {
        private final Set<String> privilegedGroupIds = new HashSet<String>();

        private HeuristicsComparator() {
            String packaging = ((NbMavenProject)SearchDependencyUI.this.project.getLookup().lookup(NbMavenProject.class)).getPackagingType();
            if ("nbm".equalsIgnoreCase(packaging)) {
                this.privilegedGroupIds.add("org.netbeans.api");
            }
            if ("war".equalsIgnoreCase(packaging) || "ear".equalsIgnoreCase(packaging) || "ejb".equalsIgnoreCase(packaging)) {
                this.privilegedGroupIds.add("javax.activation");
                this.privilegedGroupIds.add("javax.ejb");
                this.privilegedGroupIds.add("javax.faces");
                this.privilegedGroupIds.add("javax.j2ee");
                this.privilegedGroupIds.add("javax.jdo");
                this.privilegedGroupIds.add("javax.jms");
                this.privilegedGroupIds.add("javax.mail");
                this.privilegedGroupIds.add("javax.management");
                this.privilegedGroupIds.add("javax.naming");
                this.privilegedGroupIds.add("javax.persistence");
                this.privilegedGroupIds.add("javax.portlet");
                this.privilegedGroupIds.add("javax.resource");
                this.privilegedGroupIds.add("javax.security");
                this.privilegedGroupIds.add("javax.servlet");
                this.privilegedGroupIds.add("javax.sql");
                this.privilegedGroupIds.add("javax.transaction");
                this.privilegedGroupIds.add("javax.xml");
            }
            NbMavenProject mavenproject = (NbMavenProject)SearchDependencyUI.this.project.getLookup().lookup(NbMavenProject.class);
            List deps = mavenproject.getMavenProject().getDependencies();
            for (Dependency d : deps) {
                this.privilegedGroupIds.add(d.getGroupId());
            }
        }

        @Override
        public int compare(String s1, String s2) {
            String[] split1 = s1.split(":");
            String[] split2 = s2.split(":");
            boolean b1 = this.privilegedGroupIds.contains(split1[0].trim());
            boolean b2 = this.privilegedGroupIds.contains(split2[0].trim());
            if (b1 && !b2) {
                return -1;
            }
            if (!b1 && b2) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    private class ResultsRootChildren
    extends Children.Keys<Node> {
        List<Node> myNodes = Collections.emptyList();

        private void setNewChildren(List<Node> ch) {
            this.myNodes = ch;
            this.refreshList();
        }

        protected void addNotify() {
            this.refreshList();
        }

        private void refreshList() {
            this.setKeys(new ArrayList<Node>(this.myNodes));
        }

        protected Node[] createNodes(Node key) {
            return new Node[]{key};
        }
    }
}

