/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.ext;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.CompletionItem;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.LibrarySupport;
import org.netbeans.api.languages.SyntaxContext;

public class NBS {
    private static final String DOC = "org/netbeans/modules/languages/resources/NBS-Library.xml";
    private static LibrarySupport library;

    public static List<CompletionItem> completion(Context context) {
        if (context instanceof SyntaxContext) {
            SyntaxContext sContext = (SyntaxContext)context;
            ASTPath path = sContext.getASTPath();
            String c = "root";
            ListIterator<ASTItem> it = path.listIterator(path.size() - 1);
            boolean properties = false;
            while (it.hasPrevious()) {
                String p;
                ASTItem item = it.previous();
                if (item instanceof ASTToken) continue;
                ASTNode node = (ASTNode)item;
                if (node.getNT().equals("regularExpression")) {
                    return Collections.emptyList();
                }
                if (node.getNT().equals("selector")) {
                    return Collections.emptyList();
                }
                if (node.getNT().equals("value")) {
                    properties = true;
                    continue;
                }
                if (!node.getNT().equals("command") || (p = node.getTokenTypeIdentifier("keyword")) == null || !properties) continue;
                c = p;
                break;
            }
            return NBS.getLibrary().getCompletionItems(c);
        }
        return Collections.emptyList();
    }

    private static LibrarySupport getLibrary() {
        if (library == null) {
            library = LibrarySupport.create(DOC);
        }
        return library;
    }

    public static boolean tokenComand(SyntaxContext context) {
        ASTPath path = context.getASTPath();
        if (path.size() < 3) {
            return false;
        }
        ASTNode node = (ASTNode)path.get(path.size() - 3);
        ASTToken keywordToken = node.getTokenType("keyword");
        return keywordToken != null && keywordToken.getIdentifier().equals("TOKEN");
    }

    public static boolean notTokenComand(SyntaxContext context) {
        ASTPath path = context.getASTPath();
        ListIterator<ASTItem> it = path.listIterator();
        while (it.hasNext()) {
            ASTNode node;
            ASTItem item = (ASTItem)it.next();
            if (!(item instanceof ASTNode) || !(node = (ASTNode)item).getNT().equals("command")) continue;
            ASTToken keywordToken = node.getTokenType("keyword");
            return keywordToken != null && !keywordToken.getIdentifier().equals("TOKEN");
        }
        return false;
    }
}

