/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.openide.util.NbBundle;

public final class BeanUtils {
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";
    public static final String IS_PREFIX = "is";
    public static final String ADD_PREFIX = "add";
    public static final String REMOVE_PREFIX = "remove";
    static final String[] WELL_KNOWN_LISTENERS = new String[]{"java.awt.event.ActionListener", "java.awt.event.ContainerListener", "java.awt.event.FocusListener", "java.awt.event.ItemListener", "java.awt.event.KeyListener", "java.awt.event.MouseListener", "java.awt.event.MouseMotionListener", "java.awt.event.WindowListener", "java.beans.PropertyChangeListener", "java.beans.VetoableChangeListener", "javax.swing.event.CaretListener", "javax.swing.event.ChangeListener", "javax.swing.event.DocumentListener", "javax.swing.event.HyperlinkListener", "javax.swing.event.MenuListener", "javax.swing.event.MouseInputListener", "javax.swing.event.PopupMenuListener", "javax.swing.event.TableColumnModelListener", "javax.swing.event.TableModelListener", "javax.swing.event.TreeModelListener", "javax.swing.event.UndoableEditListener"};
    public static final String PROP_TYPE = "type";
    public static final String PROP_MODE = "mode";
    public static final String PROP_NAME = "name";
    public static final String PROP_GETTER = "getter";
    public static final String PROP_SETTER = "setter";
    public static final String PROP_ESTIMATEDFIELD = "estimatedField";
    public static final String PROP_INDEXEDTYPE = "indexedType";
    public static final String PROP_INDEXEDGETTER = "indexedGetter";
    public static final String PROP_INDEXEDSETTER = "indexedSetter";
    public static final String PROP_ADDLISTENER = "addListener";
    public static final String PROP_REMOVELISTENER = "removeListener";
    public static final String PROP_ISUNICAST = "isUnicast";

    private BeanUtils() {
    }

    static String capitalizeFirstLetter(String str) {
        if (str == null || str.length() <= 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String nameAsString(Element e) {
        return e.getSimpleName().toString();
    }

    public static boolean isThrowing(CompilationInfo ci, ExecutableElement method, String name) {
        TypeElement ex = ci.getElements().getTypeElement(name);
        if (ex == null) {
            return false;
        }
        TypeMirror eType = ex.asType();
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            if (!ci.getTypes().isSubtype(typeMirror, eType)) continue;
            return true;
        }
        return false;
    }

    public static String getString(String key) {
        return NbBundle.getMessage(BeanUtils.class, (String)key);
    }

    public static String typeAsString(TypeMirror type) {
        switch (type.getKind()) {
            case DECLARED: {
                return BeanUtils.nameAsString(((DeclaredType)type).asElement());
            }
            case ARRAY: {
                return BeanUtils.typeAsString(((ArrayType)type).getComponentType()) + "[]";
            }
        }
        return type.toString();
    }

    public static List<? extends ExecutableElement> methodsIn(TypeElement clazz, CompilationInfo javac) {
        List<ExecutableElement> result = ElementFilter.methodsIn(javac.getElements().getAllMembers(clazz));
        TypeElement objectElement = javac.getElements().getTypeElement("java.lang.Object");
        for (int i = result.size() - 1; i >= 0; --i) {
            ExecutableElement method = result.get(i);
            if (method.getModifiers().contains((Object)Modifier.PUBLIC) && objectElement != method.getEnclosingElement()) continue;
            result.remove(i);
        }
        return result;
    }
}

