/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui.actions;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.modules.testng.api.TestNGUtils;
import org.netbeans.modules.testng.spi.TestConfig;
import org.netbeans.modules.testng.spi.TestNGSupportImplementation;
import org.netbeans.modules.testng.ui.actions.Bundle;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public class RunSuiteAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(RunSuiteAction.class.getName());

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        Lookup l = activatedNodes[0].getLookup();
        FileObject fo = (FileObject)l.lookup(FileObject.class);
        if (fo != null) {
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            return TestNGSupport.isActionSupported((TestNGSupport.Action)TestNGSupport.Action.RUN_TESTSUITE, (Project)p);
        }
        SingleMethod sm = (SingleMethod)l.lookup(SingleMethod.class);
        if (sm != null) {
            Project p = FileOwnerQuery.getOwner((FileObject)sm.getFile());
            return TestNGSupport.isActionSupported((TestNGSupport.Action)TestNGSupport.Action.RUN_TESTSUITE, (Project)p);
        }
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        Lookup l = activatedNodes[0].getLookup();
        FileObject fo = (FileObject)l.lookup(FileObject.class);
        assert (fo != null);
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        TestNGSupportImplementation.TestExecutor exec = TestNGSupport.findTestNGSupport((Project)p).createExecutor(p);
        TestConfig conf = TestNGUtils.getTestConfig((FileObject)fo, (boolean)false, null, null, null);
        try {
            exec.execute(TestNGSupport.Action.RUN_TESTSUITE, conf);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public String getName() {
        return Bundle.CTL_RunSuiteAction();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

