/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.jtreg;

import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.openjdk.jtreg.Bundle;
import org.netbeans.modules.java.openjdk.jtreg.Tag;
import org.netbeans.modules.java.openjdk.jtreg.TagParser;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;

public class TagOrderHint {
    public static ErrorDescription computeWarning(HintContext ctx) {
        TagParser.Result tags = TagParser.parseTags(ctx.getInfo());
        List<Tag> sorted = TagOrderHint.sortTags(tags);
        if (!tags.getTags().equals(sorted)) {
            ErrorDescription idealED = org.netbeans.spi.java.hints.ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_TagOrderHint(), (Fix[])new Fix[]{new FixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix()});
            List<Tag> test = tags.getName2Tag().get("test");
            return ErrorDescriptionFactory.createErrorDescription((Severity)idealED.getSeverity(), (String)idealED.getDescription(), (LazyFixList)idealED.getFixes(), (FileObject)ctx.getInfo().getFileObject(), (int)test.get(0).getTagStart(), (int)test.get(0).getTagEnd());
        }
        return null;
    }

    private static List<Tag> sortTags(TagParser.Result tags) {
        ArrayList<Tag> sorted = new ArrayList<Tag>(tags.getTags());
        sorted.sort(new Comparator<Tag>(){

            @Override
            public int compare(Tag o1, Tag o2) {
                int pos1 = TagParser.RECOMMENDED_TAGS_ORDER.indexOf(o1.getName());
                int pos2 = TagParser.RECOMMENDED_TAGS_ORDER.indexOf(o2.getName());
                if (pos1 < 0) {
                    pos1 = Integer.MAX_VALUE;
                }
                if (pos2 < 0) {
                    pos2 = Integer.MAX_VALUE;
                }
                return pos1 - pos2;
            }
        });
        return sorted;
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_TagOrderHint();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            List<Tag> sorted = TagOrderHint.sortTags(TagParser.parseTags((CompilationInfo)ctx.getWorkingCopy()));
            StringBuilder newText = new StringBuilder();
            int min = Integer.MAX_VALUE;
            int max = 0;
            for (Tag t : sorted) {
                min = Math.min(min, t.getStart());
                max = Math.max(max, t.getEnd());
                newText.append(ctx.getWorkingCopy().getText().substring(t.getStart(), t.getEnd()));
            }
            ctx.getWorkingCopy().rewriteInComment(min, max - min, newText.toString());
        }
    }
}

