/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.module.graph;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

final class ModuleNode
implements GraphNodeImplementation {
    private final String moduleName;
    private final boolean unnamed;
    private List<ModuleNode> children;
    private ModuleNode parent;
    private final String toolTipText;
    private final boolean jdk;

    ModuleNode(@NonNull String moduleName, boolean unnamed, boolean jdk, @NonNull FileObject moduleInfo) {
        Parameters.notNull((CharSequence)"moduleNode", (Object)moduleName);
        this.moduleName = moduleName;
        this.unnamed = unnamed;
        this.jdk = jdk;
        String string = this.toolTipText = unnamed ? ModuleNode.getUnnamedModuleToolTip(moduleInfo) : null;
        assert (!unnamed || moduleName.isEmpty());
    }

    @NonNull
    public String getName() {
        return this.unnamed ? NbBundle.getMessage(ModuleNode.class, (String)"LBL_UnnamedModule") : this.moduleName;
    }

    boolean isUnnamed() {
        return this.unnamed;
    }

    public boolean isJdk() {
        return this.jdk;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ModuleNode)) {
            return false;
        }
        ModuleNode otherNode = (ModuleNode)other;
        return this.moduleName == null ? otherNode.moduleName == null : this.moduleName.equals(otherNode.moduleName);
    }

    public int hashCode() {
        return this.moduleName == null ? 0 : this.moduleName.hashCode();
    }

    public String toString() {
        return String.format("Module: %s", this.getName());
    }

    public synchronized List<ModuleNode> getChildren() {
        return this.children != null ? Collections.unmodifiableList(this.children) : null;
    }

    public GraphNodeImplementation getParent() {
        return this.parent;
    }

    public String getTooltipText() {
        return this.toolTipText != null ? this.toolTipText : this.getName();
    }

    public String getQualifiedName() {
        return this.getName();
    }

    synchronized void addChild(ModuleNode child) {
        if (this.children == null) {
            this.children = new LinkedList<ModuleNode>();
        }
        this.children.add(child);
    }

    void setParent(ModuleNode parent) {
        this.parent = parent;
    }

    @NonNull
    private static String getUnnamedModuleToolTip(@NonNull FileObject moduleInfo) {
        return Optional.ofNullable(ClassPath.getClassPath((FileObject)moduleInfo, (String)"modules/classpath")).map(cp -> cp.entries().stream().map(e -> FileUtil.archiveOrDirForURL((URL)e.getURL())).filter(f -> f != null).map(f -> f.getName()).collect(Collectors.joining(File.pathSeparator))).orElse("");
    }
}

