/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.circuitbreaker.internal.resilience4j;

import com.oracle.bmc.circuitbreaker.CallNotAllowedException;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.OciCircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OciCircuitBreakerImpl
implements OciCircuitBreaker {
    private static final Logger LOG = LoggerFactory.getLogger(OciCircuitBreakerImpl.class);
    private final CircuitBreaker r4jCircuitBreaker;
    private final int numberOfRecordedHistoryResponses;
    private Deque<OciCircuitBreaker.ErrorHistoryItem> historyQueue;
    private volatile long openedTimestampMillis;

    public OciCircuitBreakerImpl(CircuitBreaker r4jCircuitBreaker, int numberOfRecordedHistoryResponses) {
        if (r4jCircuitBreaker == null) {
            throw new IllegalArgumentException("r4jCircuitBreaker must be non-null");
        }
        if (r4jCircuitBreaker.getName() == null) {
            String circuitBreakerName = "CircuitBreaker" + System.identityHashCode(this);
            r4jCircuitBreaker = CircuitBreaker.of((String)circuitBreakerName, (CircuitBreakerConfig)r4jCircuitBreaker.getCircuitBreakerConfig());
        }
        r4jCircuitBreaker.getEventPublisher().onStateTransition(event -> {
            CircuitBreaker.StateTransition transition = event.getStateTransition();
            LOG.info("Circuit breaker {} transitioned from {} to {}", new Object[]{this.getName(), transition.getFromState(), transition.getToState()});
            if (transition.getFromState() == CircuitBreaker.State.CLOSED && transition.getToState() == CircuitBreaker.State.OPEN) {
                this.openedTimestampMillis = System.currentTimeMillis();
            }
        });
        this.r4jCircuitBreaker = r4jCircuitBreaker;
        this.historyQueue = new ArrayDeque<OciCircuitBreaker.ErrorHistoryItem>();
        this.numberOfRecordedHistoryResponses = numberOfRecordedHistoryResponses;
    }

    public OciCircuitBreakerImpl(CircuitBreakerConfiguration circuitBreakerConfiguration, Predicate<Throwable> recordExceptionPredicate) {
        this(CircuitBreaker.of((String)"default", (CircuitBreakerConfig)CircuitBreakerConfig.custom().enableAutomaticTransitionFromOpenToHalfOpen().slidingWindowType(CircuitBreakerConfig.SlidingWindowType.TIME_BASED).failureRateThreshold((float)circuitBreakerConfiguration.getFailureRateThreshold()).slowCallRateThreshold((float)circuitBreakerConfiguration.getSlowCallRateThreshold()).slowCallDurationThreshold(circuitBreakerConfiguration.getSlowCallDurationThreshold()).permittedNumberOfCallsInHalfOpenState(circuitBreakerConfiguration.getPermittedNumberOfCallsInHalfOpenState()).slidingWindowSize(circuitBreakerConfiguration.getSlidingWindowSize()).minimumNumberOfCalls(circuitBreakerConfiguration.getMinimumNumberOfCalls()).writableStackTraceEnabled(circuitBreakerConfiguration.isWritableStackTraceEnabled()).waitDurationInOpenState(circuitBreakerConfiguration.getWaitDurationInOpenState()).recordExceptions(circuitBreakerConfiguration.getRecordExceptions().toArray(new Class[0])).recordException(recordExceptionPredicate).build()), circuitBreakerConfiguration.getNumberOfRecordedHistoryResponses());
    }

    @Override
    public CircuitBreaker getR4jCircuitBreaker() {
        return this.r4jCircuitBreaker;
    }

    @Override
    public String getName() {
        return this.r4jCircuitBreaker.getName();
    }

    @Override
    public CircuitBreaker.State getState() {
        return this.r4jCircuitBreaker.getState();
    }

    @Override
    public boolean tryAcquirePermission() {
        return this.r4jCircuitBreaker.tryAcquirePermission();
    }

    @Override
    public void releasePermission() {
        this.r4jCircuitBreaker.releasePermission();
    }

    @Override
    public void acquirePermission() {
        this.r4jCircuitBreaker.acquirePermission();
    }

    @Override
    public long getCurrentTimestamp() {
        return this.r4jCircuitBreaker.getCurrentTimestamp();
    }

    @Override
    public TimeUnit getTimestampUnit() {
        return this.r4jCircuitBreaker.getTimestampUnit();
    }

    @Override
    public void onError(long duration, TimeUnit durationUnit, Throwable throwable) {
        this.r4jCircuitBreaker.onError(duration, durationUnit, throwable);
    }

    @Override
    public void onSuccess(long duration, TimeUnit durationUnit) {
        this.r4jCircuitBreaker.onSuccess(duration, durationUnit);
    }

    @Override
    public void onResult(long duration, TimeUnit durationUnit, Object result) {
        this.r4jCircuitBreaker.onResult(duration, durationUnit, result);
    }

    @Override
    public OciCircuitBreaker.Config getCircuitBreakerConfig() {
        return new OciCircuitBreakerConfigImpl(this.r4jCircuitBreaker.getCircuitBreakerConfig());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OciCircuitBreakerImpl that = (OciCircuitBreakerImpl)o;
        return Objects.equals(this.r4jCircuitBreaker, that.r4jCircuitBreaker);
    }

    public int hashCode() {
        return Objects.hash(this.r4jCircuitBreaker);
    }

    public String toString() {
        return "OciCircuitBreakerImpl{r4jCircuitBreaker=" + this.r4jCircuitBreaker + '}';
    }

    @Override
    public CallNotAllowedException createCallNotAllowedException() {
        return CallNotAllowedException.createCallNotAllowedException("CircuitBreaker '" + this.getName() + "' is " + this.getState() + " and does not permit further calls", this.getCircuitBreakerConfig().isWritableStackTraceEnabled());
    }

    @Override
    public String circuitBreakerCallNotPermittedErrorMessage(String requestUri) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("CircuitBreaker has been OPEN for ").append((double)this.getCircuitBreakerOpenTime() / 1000.0).append(" seconds and all the requests sent in a window of ").append(this.r4jCircuitBreaker.getCircuitBreakerConfig().getWaitDurationInOpenState().getSeconds()).append(" seconds will be rejected.\n");
        if (requestUri != null) {
            messageBuilder.append("URL which CircuitBreaker rejected is - ").append(requestUri + "\n");
        }
        String historyAsString = this.getHistoryAsString();
        int numberOfCurrentRecordsinHistory = Math.min(this.numberOfRecordedHistoryResponses, this.historyQueue.size());
        if (historyAsString != null && !historyAsString.trim().isEmpty()) {
            messageBuilder.append("The CircuitBreaker was opened because requests failed too frequently. Here are the last ").append(numberOfCurrentRecordsinHistory).append(" failed requests:\n").append(historyAsString);
        }
        return messageBuilder.toString();
    }

    private long getCircuitBreakerOpenTime() {
        return System.currentTimeMillis() - this.openedTimestampMillis;
    }

    @Override
    public synchronized void addToHistory(Throwable throwable, Integer status, Map<String, String> messages) {
        if (this.historyQueue.size() >= this.numberOfRecordedHistoryResponses) {
            this.historyQueue.removeFirst();
        }
        this.historyQueue.add(new OciCircuitBreaker.ErrorHistoryItem(throwable, status, messages));
    }

    @Override
    public synchronized List<OciCircuitBreaker.ErrorHistoryItem> getHistory() {
        return Collections.unmodifiableList(new ArrayList<OciCircuitBreaker.ErrorHistoryItem>(this.historyQueue));
    }

    @Override
    public synchronized String getHistoryAsString() {
        StringBuilder sb = new StringBuilder();
        int index = 1;
        for (OciCircuitBreaker.ErrorHistoryItem item : this.historyQueue) {
            if (index > 1) {
                sb.append(System.lineSeparator());
            }
            sb.append(index).append(". ").append(item.toString());
            ++index;
        }
        return sb.toString();
    }

    public static class OciCircuitBreakerConfigImpl
    implements OciCircuitBreaker.Config {
        private final CircuitBreakerConfig r4jConfig;

        public OciCircuitBreakerConfigImpl(CircuitBreakerConfig r4jConfig) {
            this.r4jConfig = r4jConfig;
        }

        @Override
        public boolean isWritableStackTraceEnabled() {
            return this.r4jConfig.isWritableStackTraceEnabled();
        }

        @Override
        public float getFailureRateThreshold() {
            return this.r4jConfig.getFailureRateThreshold();
        }

        public OciCircuitBreaker.Config.IntervalFunction getWaitIntervalFunctionInOpenState() {
            return numberOfAttempts -> (Long)this.r4jConfig.getWaitIntervalFunctionInOpenState().apply(numberOfAttempts);
        }

        @Override
        public int getSlidingWindowSize() {
            return this.r4jConfig.getSlidingWindowSize();
        }

        @Override
        public Predicate<Throwable> getRecordExceptionPredicate() {
            return this.r4jConfig.getRecordExceptionPredicate();
        }

        public Predicate<Object> getRecordResultPredicate() {
            return this.r4jConfig.getRecordResultPredicate();
        }

        public Predicate<Throwable> getIgnoreExceptionPredicate() {
            return this.r4jConfig.getIgnoreExceptionPredicate();
        }

        public Function<Clock, Long> getCurrentTimestampFunction() {
            return this.r4jConfig.getCurrentTimestampFunction();
        }

        public TimeUnit getTimestampUnit() {
            return this.r4jConfig.getTimestampUnit();
        }

        public boolean isAutomaticTransitionFromOpenToHalfOpenEnabled() {
            return this.r4jConfig.isAutomaticTransitionFromOpenToHalfOpenEnabled();
        }

        @Override
        public int getMinimumNumberOfCalls() {
            return this.r4jConfig.getMinimumNumberOfCalls();
        }

        @Override
        public int getPermittedNumberOfCallsInHalfOpenState() {
            return this.r4jConfig.getPermittedNumberOfCallsInHalfOpenState();
        }

        @Override
        public OciCircuitBreaker.Config.SlidingWindowType getSlidingWindowType() {
            return OciCircuitBreaker.Config.SlidingWindowType.valueOf(this.r4jConfig.getSlidingWindowType().name());
        }

        @Override
        public float getSlowCallRateThreshold() {
            return this.r4jConfig.getSlowCallRateThreshold();
        }

        @Override
        public Duration getSlowCallDurationThreshold() {
            return this.r4jConfig.getSlowCallDurationThreshold();
        }

        public Duration getMaxWaitDurationInHalfOpenState() {
            return this.r4jConfig.getMaxWaitDurationInHalfOpenState();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OciCircuitBreakerConfigImpl that = (OciCircuitBreakerConfigImpl)o;
            return Objects.equals(this.r4jConfig, that.r4jConfig);
        }

        public int hashCode() {
            return Objects.hash(this.r4jConfig);
        }

        public String toString() {
            return "OciCircuitBreakerConfigImpl{r4jConfig=" + this.r4jConfig + '}';
        }
    }
}

