/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.netbeans.modules.image.CustomZoomPanel;
import org.netbeans.modules.image.ImageViewer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;

public class CustomZoomAction
extends CallableSystemAction {
    static final long serialVersionUID = 8247068408606777895L;

    public void performAction() {
        final Dialog[] dialogs = new Dialog[1];
        final CustomZoomPanel zoomPanel = new CustomZoomPanel();
        zoomPanel.setEnlargeFactor(1);
        zoomPanel.setDecreaseFactor(1);
        DialogDescriptor dd = new DialogDescriptor((Object)zoomPanel, NbBundle.getMessage(CustomZoomAction.class, (String)"LBL_CustomZoomAction"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){
            final /* synthetic */ CustomZoomAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource() == DialogDescriptor.OK_OPTION) {
                    int decreaseFactor;
                    int enlargeFactor;
                    try {
                        enlargeFactor = zoomPanel.getEnlargeFactor();
                        decreaseFactor = zoomPanel.getDecreaseFactor();
                    }
                    catch (NumberFormatException nfe) {
                        this.notifyInvalidInput();
                        return;
                    }
                    if (enlargeFactor == 0 || decreaseFactor == 0) {
                        this.notifyInvalidInput();
                        return;
                    }
                    this.this$0.performZoom(enlargeFactor, decreaseFactor);
                    dialogs[0].setVisible(false);
                    dialogs[0].dispose();
                } else {
                    dialogs[0].setVisible(false);
                    dialogs[0].dispose();
                }
            }

            private void notifyInvalidInput() {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomZoomAction.class, (String)"MSG_InvalidValues"), 0));
            }
        });
        dialogs[0] = DialogDisplayer.getDefault().createDialog(dd);
        dialogs[0].setVisible(true);
    }

    private void performZoom(int enlargeFactor, int decreaseFactor) {
        TopComponent currentComponent = TopComponent.getRegistry().getActivated();
        if (currentComponent instanceof ImageViewer) {
            ((ImageViewer)currentComponent).customZoom(enlargeFactor, decreaseFactor);
        }
    }

    public String getName() {
        return NbBundle.getMessage(CustomZoomAction.class, (String)"LBL_CustomZoom");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.image.CustomZoomAction");
    }

    protected String iconResource() {
        return "org/netbeans/modules/image/customZoom.gif";
    }

    protected boolean asynchronous() {
        return false;
    }
}

