/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.basic;

import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.modules.profiler.heapwalk.details.basic.ArrayValueView;
import org.netbeans.modules.profiler.heapwalk.details.basic.Bundle;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public final class ArrayDetailsProvider
extends DetailsProvider {
    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (instance instanceof PrimitiveArrayInstance) {
            if ("char[]".equals(instance.getJavaClass().getName())) {
                return DetailsUtils.getPrimitiveArrayString(instance, 0, -1, null, "...");
            }
            return ArrayDetailsProvider.getItemsString(((PrimitiveArrayInstance)instance).getLength());
        }
        if (instance instanceof ObjectArrayInstance) {
            return ArrayDetailsProvider.getItemsString(((ObjectArrayInstance)instance).getLength());
        }
        return null;
    }

    @Override
    public DetailsProvider.View getDetailsView(String className, Instance instance, Heap heap) {
        if (instance instanceof PrimitiveArrayInstance) {
            return new ArrayValueView(className, instance, heap);
        }
        return null;
    }

    private static String getItemsString(int length) {
        return length == 1 ? Bundle.ArrayDetailsProvider_OneItemString() : Bundle.ArrayDetailsProvider_ItemsNumberString(length);
    }
}

