/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.layout;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;

public class SceneElementComparator
implements Comparator<SceneElement> {
    private final PageFlowScene scene;

    public SceneElementComparator(PageFlowScene scene) {
        this.scene = scene;
    }

    @Override
    public int compare(SceneElement s1, SceneElement s2) {
        assert (s1 != null);
        assert (s2 != null);
        Point p1 = s1.p;
        Point p2 = s2.p;
        assert (p1 != null);
        assert (p2 != null);
        PageFlowSceneElement e1 = s1.element;
        PageFlowSceneElement e2 = s2.element;
        if (p1.x == p2.x) {
            if (p1.y == p2.y) {
                return this.scene.getIdentityCode(s1.element).compareTo(this.scene.getIdentityCode(s2.element));
            }
            return p1.y - p2.y;
        }
        return p1.x - p2.x;
    }

    public static PageFlowSceneElement getNextSelectableElement(PageFlowScene scene, boolean reverse, boolean nodesSelectable, boolean edgesSelectable, boolean pinsSelectable) {
        Object selObj;
        Object obj2;
        ArrayList selectedObjs = new ArrayList(scene.getSelectedObjects());
        ArrayList objs = new ArrayList();
        ArrayList<SceneElement> sortedElements = new ArrayList<SceneElement>();
        if (nodesSelectable) {
            objs.addAll(scene.getNodes());
        }
        if (edgesSelectable) {
            objs.addAll(scene.getEdges());
        }
        if (pinsSelectable) {
            objs.addAll(scene.getPins());
            for (Page page : scene.getNodes()) {
                Pin pin = scene.getDefaultPin(page);
                sortedElements.remove(pin);
                objs.remove(pin);
            }
        }
        for (Object obj2 : objs) {
            Point p = scene.findWidget(obj2).getLocation();
            SceneElement se = new SceneElement((PageFlowSceneElement)obj2, p);
            sortedElements.add(se);
        }
        SceneElement mySelectedSceneElement = null;
        obj2 = selectedObjs.iterator();
        while (obj2.hasNext() && !sortedElements.contains(mySelectedSceneElement = new SceneElement((PageFlowSceneElement)(selObj = obj2.next()), scene.findWidget(selObj).getLocation()))) {
        }
        PageFlowSceneElement nextElement = null;
        if (!sortedElements.isEmpty()) {
            sortedElements.sort(new SceneElementComparator(scene));
            if (reverse) {
                Collections.reverse(sortedElements);
            }
            if (mySelectedSceneElement != null && sortedElements.contains(mySelectedSceneElement)) {
                int index = sortedElements.indexOf(mySelectedSceneElement);
                if (sortedElements.size() > index + 1) {
                    nextElement = ((SceneElement)sortedElements.get((int)(index + 1))).element;
                } else {
                    return null;
                }
            }
            if (nextElement == null) {
                nextElement = ((SceneElement)sortedElements.get((int)0)).element;
            }
        }
        return nextElement;
    }

    public static class SceneElement {
        public PageFlowSceneElement element;
        public Point p;

        public SceneElement(PageFlowSceneElement element, Point p) {
            this.p = p;
            this.element = element;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                throw new IllegalArgumentException("Can not compare null object");
            }
            if (!(obj instanceof SceneElement)) {
                return false;
            }
            SceneElement e = (SceneElement)obj;
            return this.element.equals(e.element) && this.p.equals(e.p);
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + (this.element != null ? this.element.hashCode() : 0);
            hash = 53 * hash + (this.p != null ? this.p.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.element.toString() + ":" + this.p.toString();
        }
    }
}

