/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.FilterMappingPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.FilterMappingsTableModel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.FiltersMultiViewElement;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class FilterMappingsTablePanel
extends DefaultTablePanel {
    private FilterMappingsTableModel model;
    private WebApp webApp;
    private DDDataObject dObj;
    private SectionView view;

    public FilterMappingsTablePanel(final SectionView view, final DDDataObject dObj, final FilterMappingsTableModel model) {
        super((AbstractTableModel)model);
        this.model = model;
        this.dObj = dObj;
        this.view = view;
        this.webApp = dObj.getWebApp();
        this.removeButton.addActionListener(new ActionListener(){
            final /* synthetic */ FilterMappingsTablePanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                int row = this.this$0.getTable().getSelectedRow();
                String filterName = (String)model.getValueAt(row, 0);
                dObj.modelUpdatedFromUI();
                dObj.setChangedFromUI(true);
                model.removeRow(row);
                dObj.setChangedFromUI(false);
                Filter filter = (Filter)this.this$0.webApp.findBeanByName("Filter", "FilterName", filterName);
                if (filter != null) {
                    SectionPanel panel = view.findSectionPanel((Object)filter);
                    panel.setTitle(((FiltersMultiViewElement.FiltersView)view).getFilterTitle(filter));
                }
            }
        });
        this.addButton.addActionListener(new TableActionListener(true));
        this.editButton.addActionListener(new TableActionListener(false));
    }

    void setModel(WebApp webApp, FilterMapping[] mappings) {
        this.model.setData((CommonDDBean)webApp, (CommonDDBean[])mappings);
        this.webApp = webApp;
    }

    private static boolean isWebApp25(WebApp webApp) {
        BigDecimal ver = new BigDecimal(webApp.getVersion());
        return ver.compareTo(new BigDecimal("2.5")) >= 0;
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String[] allFilters = DDUtils.getFilterNames(FilterMappingsTablePanel.this.webApp);
            String[] allServlets = DDUtils.getServletNames(FilterMappingsTablePanel.this.webApp);
            int row = this.add ? -1 : FilterMappingsTablePanel.this.getTable().getSelectedRow();
            FilterMapping mapping = null;
            if (this.add) {
                try {
                    mapping = (FilterMapping)FilterMappingsTablePanel.this.webApp.createBean("FilterMapping");
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                mapping = FilterMappingsTablePanel.this.webApp.getFilterMapping(row);
            }
            final FilterMappingPanel dialogPanel = new FilterMappingPanel(mapping, allFilters, allServlets, FilterMappingsTablePanel.isWebApp25(FilterMappingsTablePanel.this.webApp));
            final EditDialog dialog = new EditDialog(this, dialogPanel, NbBundle.getMessage(FilterMappingsTablePanel.class, (String)"TTL_filterMapping"), this.add){
                final /* synthetic */ TableActionListener this$1;
                {
                    this.this$1 = this$1;
                    super(panel, title, adding);
                }

                protected String validate() {
                    String[] names;
                    if (!dialogPanel.hasFilterNames()) {
                        return NbBundle.getMessage(FilterMappingsTablePanel.class, (String)"LBL_no_filters");
                    }
                    String urlPattern = dialogPanel.getUrlPattern();
                    if (urlPattern == null) {
                        urlPattern = "";
                    }
                    urlPattern = urlPattern.replace(',', ' ').trim();
                    if (dialogPanel.getUrlRB().isSelected() && urlPattern.length() == 0) {
                        return NbBundle.getMessage(FilterMappingsTablePanel.class, (String)"TXT_missingURL");
                    }
                    if (dialogPanel.getServletNameRB().isSelected() && ((names = dialogPanel.getServletNames()) == null || names.length == 0)) {
                        return NbBundle.getMessage(FilterMappingsTablePanel.class, (String)"TXT_missingServletName");
                    }
                    return null;
                }
            };
            if (allFilters == null || allFilters.length == 0) {
                dialog.checkValues();
            } else if (this.add) {
                dialog.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getUrlTF().getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getServletNamesList().getSelectionModel().addListSelectionListener(new ListSelectionListener(){
                final /* synthetic */ TableActionListener this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void valueChanged(ListSelectionEvent arg0) {
                    dialog.checkValues();
                }
            });
            dialogPanel.getUrlRB().addActionListener(new ActionListener(){
                final /* synthetic */ TableActionListener this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    dialog.checkValues();
                }
            });
            dialogPanel.getServletNameRB().addActionListener(new ActionListener(){
                final /* synthetic */ TableActionListener this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    dialog.checkValues();
                }
            });
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getUrlTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                FilterMappingsTablePanel.this.dObj.modelUpdatedFromUI();
                FilterMappingsTablePanel.this.dObj.setChangedFromUI(true);
                String filterName = dialogPanel.getFilterName();
                String urlPattern = dialogPanel.getUrlPattern();
                String[] servletNames = dialogPanel.getServletNames();
                String[] dispatcher = dialogPanel.getDispatcherTypes();
                if (this.add) {
                    FilterMappingsTablePanel.this.model.addRow(new Object[]{filterName, urlPattern, servletNames, dispatcher});
                } else {
                    Filter filter;
                    String oldName = (String)FilterMappingsTablePanel.this.model.getValueAt(row, 0);
                    FilterMappingsTablePanel.this.model.editRow(row, new Object[]{filterName, urlPattern, servletNames, dispatcher});
                    if (!filterName.equals(oldName) && (filter = (Filter)FilterMappingsTablePanel.this.webApp.findBeanByName("Filter", "FilterName", oldName)) != null) {
                        SectionPanel panel = FilterMappingsTablePanel.this.view.findSectionPanel((Object)filter);
                        panel.setTitle(((FiltersMultiViewElement.FiltersView)FilterMappingsTablePanel.this.view).getFilterTitle(filter));
                    }
                }
                FilterMappingsTablePanel.this.dObj.setChangedFromUI(false);
                Filter filter = (Filter)FilterMappingsTablePanel.this.webApp.findBeanByName("Filter", "FilterName", filterName);
                if (filter != null) {
                    SectionPanel panel = FilterMappingsTablePanel.this.view.findSectionPanel((Object)filter);
                    panel.setTitle(((FiltersMultiViewElement.FiltersView)FilterMappingsTablePanel.this.view).getFilterTitle(filter));
                }
            }
        }
    }
}

