/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.DeadlockDetectorImpl;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.ui.actions.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class CheckDeadlocksAction
extends AbstractAction
implements Runnable {
    private final EnableListener listener = new EnableListener(this);

    public CheckDeadlocksAction() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this.listener);
        this.putValue("Name", CheckDeadlocksAction.getDisplayName());
        this.checkEnabled();
    }

    public static String getDisplayName() {
        return Bundle.CTL_CheckDeadlocks();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (de == null) {
            return;
        }
        final JPDADebuggerImpl debugger = (JPDADebuggerImpl)de.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            return;
        }
        debugger.getRequestProcessor().post(new Runnable(){
            final /* synthetic */ CheckDeadlocksAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                CheckDeadlocksAction.checkForDeadlock(debugger);
            }
        });
    }

    public static void checkForDeadlock(JPDADebuggerImpl debugger) {
        if (debugger.getState() == 4) {
            return;
        }
        VirtualMachine vm = debugger.getVirtualMachine();
        if (vm == null) {
            return;
        }
        try {
            VirtualMachineWrapper.suspend((VirtualMachine)vm);
            ArrayList<JPDAThreadImpl> threadsToNotify = new ArrayList<JPDAThreadImpl>();
            for (ThreadReference threadRef : VirtualMachineWrapper.allThreads((VirtualMachine)vm)) {
                try {
                    if (ThreadReferenceWrapper.suspendCount((ThreadReference)threadRef) != 1) continue;
                    JPDAThreadImpl jpdaThread = debugger.getThread(threadRef);
                    jpdaThread.notifySuspended();
                    threadsToNotify.add(jpdaThread);
                }
                catch (ObjectCollectedExceptionWrapper jpdaThread) {
                }
                catch (IllegalThreadStateExceptionWrapper jpdaThread) {}
            }
            DeadlockDetector detector = debugger.getThreadsCollector().getDeadlockDetector();
            try {
                ((DeadlockDetectorImpl)detector).waitForUnfinishedTasks(5000L);
            }
            catch (InterruptedException threadRef) {
                // empty catch block
            }
            Set dealocks = detector.getDeadlocks();
            if (dealocks == null || dealocks.isEmpty()) {
                String msg = Bundle.CTL_No_Deadlock();
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                for (JPDAThreadImpl thread : threadsToNotify) {
                    thread.notifyToBeResumed();
                }
                VirtualMachineWrapper.resume((VirtualMachine)vm);
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    private synchronized boolean canBeEnabled() {
        DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (de == null) {
            return false;
        }
        JPDADebugger debugger = (JPDADebugger)de.lookupFirst(null, JPDADebugger.class);
        return debugger != null;
    }

    private void checkEnabled() {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        this.setEnabled(this.canBeEnabled());
    }

    protected void finalize() throws Throwable {
        try {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this.listener);
        }
        finally {
            super.finalize();
        }
    }

    private static class EnableListener
    extends DebuggerManagerAdapter {
        private final Reference<CheckDeadlocksAction> actionRef;

        public EnableListener(CheckDeadlocksAction action) {
            this.actionRef = new WeakReference<CheckDeadlocksAction>(action);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            CheckDeadlocksAction action = this.actionRef.get();
            if (action != null) {
                action.checkEnabled();
            }
        }
    }
}

