/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.debugger.jpda.ui.models.NumericDisplayFilter;
import org.netbeans.modules.debugger.jpda.ui.models.ResultsSwitchViewAction;
import org.netbeans.modules.debugger.jpda.ui.models.WatchesSwitchViewAction;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.actions.Presenter;

public class VariablesSwitchViewAction
implements NodeActionsProviderFilter {
    static final String ID = "LocalsView";
    static final String treeNodeFormat = "{DefaultLocalsColumn} = ({LocalsType}) {LocalsValue}";
    private static final String VIEW_PREFERENCES_NAME = "view_preferences";
    private static final String VIEW_TYPE = "view_type";
    private static final String VIEW_TREE_DISPLAY_FORMAT = "view_tree_display_format";
    private static final String VIEW_TYPE_TABLE = "table";
    private static final String VIEW_TYPE_TREE = "tree";
    private static final String IS_SHOW_WATCHES = "show_watches";
    private static final String IS_SHOW_EVALUTOR_RESULT = "show_evaluator_result";
    private static final String VAR_PREFERENCES_NAME = "variables_view";
    private static final Map<String, SwitchViewAction> switchActions = new HashMap<String, SwitchViewAction>();
    private Action switchViewAction;

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        original.performDefaultAction(node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Action[] actions = original.getActions(node);
        int n = actions.length;
        Action[] newActions = new Action[n + 1];
        System.arraycopy(actions, 0, newActions, 0, n);
        if (this.switchViewAction == null) {
            this.switchViewAction = VariablesSwitchViewAction.getSwitchViewAction();
        }
        newActions[n] = this.switchViewAction;
        return newActions;
    }

    static Action getSwitchViewAction() {
        return VariablesSwitchViewAction.getSwitchViewAction(ID, treeNodeFormat);
    }

    private static boolean isWatchesViewNested() {
        Preferences preferences = NbPreferences.forModule(ContextProvider.class).node(VAR_PREFERENCES_NAME);
        return preferences.getBoolean(IS_SHOW_WATCHES, true);
    }

    private static boolean isResultsViewNested() {
        Preferences preferences = NbPreferences.forModule(ContextProvider.class).node(VAR_PREFERENCES_NAME);
        return preferences.getBoolean(IS_SHOW_EVALUTOR_RESULT, true);
    }

    static synchronized Action getSwitchViewAction(String viewId, String treeNodeFormat) {
        SwitchViewAction a = switchActions.get(viewId);
        if (a == null) {
            a = new SwitchViewAction(viewId, treeNodeFormat);
            switchActions.put(viewId, a);
        }
        return a;
    }

    private static synchronized SwitchViewAction getSwitchViewAction(String viewId) {
        SwitchViewAction a = switchActions.get(viewId);
        return a;
    }

    private static final class SwitchViewAction
    extends AbstractAction
    implements Presenter.Popup {
        private String id;
        private String treeNodeFormat;
        private Preferences preferences;

        SwitchViewAction(String id, String treeNodeFormat) {
            this.id = id;
            this.treeNodeFormat = treeNodeFormat;
            this.preferences = NbPreferences.forModule(ContextProvider.class).node(VariablesSwitchViewAction.VIEW_PREFERENCES_NAME).node(id);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String toType;
            String type = this.preferences.get(VariablesSwitchViewAction.VIEW_TYPE, null);
            if (type == null || type.equals(VariablesSwitchViewAction.VIEW_TYPE_TABLE)) {
                toType = VariablesSwitchViewAction.VIEW_TYPE_TREE;
                this.preferences.put(VariablesSwitchViewAction.VIEW_TYPE, toType);
                this.preferences.put(VariablesSwitchViewAction.VIEW_TREE_DISPLAY_FORMAT, this.treeNodeFormat);
            } else {
                toType = VariablesSwitchViewAction.VIEW_TYPE_TABLE;
                this.preferences.put(VariablesSwitchViewAction.VIEW_TYPE, toType);
                this.preferences.remove(VariablesSwitchViewAction.VIEW_TREE_DISPLAY_FORMAT);
            }
            this.checkNested(toType);
        }

        private void onViewAs(String type, boolean checkForNested) {
            this.preferences.put(VariablesSwitchViewAction.VIEW_TYPE, type);
            if (type.equals(VariablesSwitchViewAction.VIEW_TYPE_TREE)) {
                this.preferences.put(VariablesSwitchViewAction.VIEW_TREE_DISPLAY_FORMAT, this.treeNodeFormat);
            } else {
                this.preferences.remove(VariablesSwitchViewAction.VIEW_TREE_DISPLAY_FORMAT);
            }
            if (checkForNested) {
                this.checkNested(type);
            }
        }

        private void checkNested(String type) {
            if (this.id.equals("WatchesView") && VariablesSwitchViewAction.isWatchesViewNested()) {
                ((SwitchViewAction)VariablesSwitchViewAction.getSwitchViewAction()).onViewAs(type, false);
                if (VariablesSwitchViewAction.isResultsViewNested()) {
                    ((SwitchViewAction)ResultsSwitchViewAction.getSwitchViewAction()).onViewAs(type, false);
                }
            }
            if (this.id.equals("ResultsView") && VariablesSwitchViewAction.isResultsViewNested()) {
                ((SwitchViewAction)VariablesSwitchViewAction.getSwitchViewAction()).onViewAs(type, false);
                if (VariablesSwitchViewAction.isWatchesViewNested()) {
                    ((SwitchViewAction)WatchesSwitchViewAction.getSwitchViewAction()).onViewAs(type, false);
                }
            }
            if (this.id.equals(VariablesSwitchViewAction.ID)) {
                if (VariablesSwitchViewAction.isWatchesViewNested()) {
                    ((SwitchViewAction)WatchesSwitchViewAction.getSwitchViewAction()).onViewAs(type, false);
                }
                if (VariablesSwitchViewAction.isResultsViewNested()) {
                    ((SwitchViewAction)ResultsSwitchViewAction.getSwitchViewAction()).onViewAs(type, false);
                }
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenu viewAsPopup = new JMenu(NbBundle.getMessage(SwitchViewAction.class, (String)"CTL_ViewAs_Popup"));
            ViewAsMenuItem tableView = new ViewAsMenuItem(VariablesSwitchViewAction.VIEW_TYPE_TABLE);
            ViewAsMenuItem treeView = new ViewAsMenuItem(VariablesSwitchViewAction.VIEW_TYPE_TREE);
            String type = this.preferences.get(VariablesSwitchViewAction.VIEW_TYPE, null);
            if (type == null || type.equals(VariablesSwitchViewAction.VIEW_TYPE_TABLE)) {
                tableView.setSelected(true);
            } else {
                treeView.setSelected(true);
            }
            viewAsPopup.add(tableView);
            viewAsPopup.add(treeView);
            return viewAsPopup;
        }

        private class ViewAsMenuItem
        extends JRadioButtonMenuItem {
            public ViewAsMenuItem(final String type) {
                super(new AbstractAction(SwitchViewAction.this, NbBundle.getMessage(NumericDisplayFilter.class, (String)("CTL_View_" + type))){
                    final /* synthetic */ SwitchViewAction this$0;
                    {
                        this.this$0 = this$0;
                        super(name);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.this$0.onViewAs(type, true);
                    }
                });
            }
        }
    }
}

