"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DSLFacet = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class DSLFacet {
  constructor(client) {
    this.client = client;
    _defineProperty(this, "fetch", async (request, format, responseFormat) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const params = {
          query: JSON.stringify(request.body)
        };
        const queryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        const dslDataSource = queryRes;
        res.success = true;
        res.data = dslDataSource;
      } catch (err) {
        console.error(err);
        res.data = err.body;
      }
      return res;
    });
    _defineProperty(this, "describeQuery", async request => {
      return this.fetch(request, 'dsl.dslQuery', 'json');
    });
    this.client = client;
  }
}
exports.DSLFacet = DSLFacet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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