/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform;

import javax.xml.stream.events.XMLEvent;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.Template;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.StaxUnmarshallerContext;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Unmarshaller;

public class TemplateStaxUnmarshaller
implements Unmarshaller<Template, StaxUnmarshallerContext> {
    private static TemplateStaxUnmarshaller instance;

    @Override
    public Template unmarshall(StaxUnmarshallerContext context) throws Exception {
        Template template = new Template();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return template;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TemplateName", targetDepth)) {
                    template.setTemplateName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SubjectPart", targetDepth)) {
                    template.setSubjectPart(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TextPart", targetDepth)) {
                    template.setTextPart(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("HtmlPart", targetDepth)) continue;
                template.setHtmlPart(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return template;
    }

    public static TemplateStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TemplateStaxUnmarshaller();
        }
        return instance;
    }
}

