/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkBinomialBlurImageFilter_h
#define sitkBinomialBlurImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class BinomialBlurImageFilter
\brief Performs a separable blur on each dimension of an image.

The binomial blur consists of a nearest neighbor average along each image dimension. The net result after n-iterations approaches convolution with a gaussian.
\sa itk::simple::BinomialBlur for the procedural interface
\sa itk::BinomialBlurImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT BinomialBlurImageFilter : public ImageFilter {
    public:
      using Self = BinomialBlurImageFilter;

      /** Destructor */
      virtual ~BinomialBlurImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      BinomialBlurImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Get and set the number of times to repeat the filter.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetRepetitions ( unsigned int Repetitions ) { this->m_Repetitions = Repetitions; return *this; }

      /**
       * Get and set the number of times to repeat the filter.
       */
      unsigned int GetRepetitions() const { return this->m_Repetitions; }

      /** Name of this class */
      std::string GetName() const { return std::string ("BinomialBlurImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInternal on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      unsigned int  m_Repetitions{1u};


    };

    /**\
     * \brief Performs a separable blur on each dimension of an image.
     *
     * This function directly calls the execute method of BinomialBlurImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::BinomialBlurImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image BinomialBlur ( const Image& image1, unsigned int repetitions = 1u );

     /** @} */
}
#endif
