/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_TRITONGPUACCELERATEMATMUL
#define GEN_PASS_DECL_TRITONGPUCOALESCE
#define GEN_PASS_DECL_TRITONGPUCOALESCEASYNCCOPY
#define GEN_PASS_DECL_TRITONGPUCOMBINETENSORSELECTANDIF
#define GEN_PASS_DECL_TRITONGPUF32DOTTC
#define GEN_PASS_DECL_TRITONGPUFUSENESTEDLOOPS
#define GEN_PASS_DECL_TRITONGPULOOPSCHEDULING
#define GEN_PASS_DECL_TRITONGPUOPTIMIZEACCUMULATORINIT
#define GEN_PASS_DECL_TRITONGPUOPTIMIZEDOTOPERANDS
#define GEN_PASS_DECL_TRITONGPUOPTIMIZETHREADLOCALITY
#define GEN_PASS_DECL_TRITONGPUPIPELINE
#define GEN_PASS_DECL_TRITONGPUPREFETCH
#define GEN_PASS_DECL_TRITONGPUREDUCEDATADUPLICATION
#define GEN_PASS_DECL_TRITONGPUREMOVELAYOUTCONVERSIONS
#define GEN_PASS_DECL_TRITONGPUREORDERINSTRUCTIONS
#define GEN_PASS_DECL_TRITONGPUTESTPIPELINEASSIGNLATENCIES
#define GEN_PASS_DECL_TRITONGPUTESTPIPELINESCHEDULELOOP
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// TritonGPUAccelerateMatmul
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUACCELERATEMATMUL
std::unique_ptr<::mlir::Pass> createTritonGPUAccelerateMatmul();
#undef GEN_PASS_DECL_TRITONGPUACCELERATEMATMUL
#endif // GEN_PASS_DECL_TRITONGPUACCELERATEMATMUL
#ifdef GEN_PASS_DEF_TRITONGPUACCELERATEMATMUL

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUAccelerateMatmul();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUAccelerateMatmulBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUAccelerateMatmulBase;

  TritonGPUAccelerateMatmulBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUAccelerateMatmulBase(const TritonGPUAccelerateMatmulBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUAccelerateMatmulBase& operator=(const TritonGPUAccelerateMatmulBase &) = delete;
  TritonGPUAccelerateMatmulBase(TritonGPUAccelerateMatmulBase &&) = delete;
  TritonGPUAccelerateMatmulBase& operator=(TritonGPUAccelerateMatmulBase &&) = delete;
  ~TritonGPUAccelerateMatmulBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-accelerate-matmul");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-accelerate-matmul"; }

  ::llvm::StringRef getDescription() const override { return "accelerate matmul"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUAccelerateMatmul");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUAccelerateMatmul"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvidia_gpu::TritonNvidiaGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUAccelerateMatmulBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUAccelerateMatmul() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUAccelerateMatmul() {
  return impl::createTritonGPUAccelerateMatmul();
}
#undef GEN_PASS_DEF_TRITONGPUACCELERATEMATMUL
#endif // GEN_PASS_DEF_TRITONGPUACCELERATEMATMUL

//===----------------------------------------------------------------------===//
// TritonGPUCoalesce
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUCOALESCE
std::unique_ptr<::mlir::Pass> createTritonGPUCoalesce();
#undef GEN_PASS_DECL_TRITONGPUCOALESCE
#endif // GEN_PASS_DECL_TRITONGPUCOALESCE
#ifdef GEN_PASS_DEF_TRITONGPUCOALESCE

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUCoalesce();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUCoalesceBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUCoalesceBase;

  TritonGPUCoalesceBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUCoalesceBase(const TritonGPUCoalesceBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUCoalesceBase& operator=(const TritonGPUCoalesceBase &) = delete;
  TritonGPUCoalesceBase(TritonGPUCoalesceBase &&) = delete;
  TritonGPUCoalesceBase& operator=(TritonGPUCoalesceBase &&) = delete;
  ~TritonGPUCoalesceBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-coalesce");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-coalesce"; }

  ::llvm::StringRef getDescription() const override { return "coalesce"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUCoalesce");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUCoalesce"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUCoalesceBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUCoalesce() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUCoalesce() {
  return impl::createTritonGPUCoalesce();
}
#undef GEN_PASS_DEF_TRITONGPUCOALESCE
#endif // GEN_PASS_DEF_TRITONGPUCOALESCE

//===----------------------------------------------------------------------===//
// TritonGPUCoalesceAsyncCopy
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUCOALESCEASYNCCOPY
std::unique_ptr<::mlir::Pass> createTritonGPUCoalesceAsyncCopy();
#undef GEN_PASS_DECL_TRITONGPUCOALESCEASYNCCOPY
#endif // GEN_PASS_DECL_TRITONGPUCOALESCEASYNCCOPY
#ifdef GEN_PASS_DEF_TRITONGPUCOALESCEASYNCCOPY

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUCoalesceAsyncCopy();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUCoalesceAsyncCopyBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUCoalesceAsyncCopyBase;

  TritonGPUCoalesceAsyncCopyBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUCoalesceAsyncCopyBase(const TritonGPUCoalesceAsyncCopyBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUCoalesceAsyncCopyBase& operator=(const TritonGPUCoalesceAsyncCopyBase &) = delete;
  TritonGPUCoalesceAsyncCopyBase(TritonGPUCoalesceAsyncCopyBase &&) = delete;
  TritonGPUCoalesceAsyncCopyBase& operator=(TritonGPUCoalesceAsyncCopyBase &&) = delete;
  ~TritonGPUCoalesceAsyncCopyBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-coalesce-async-copy");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-coalesce-async-copy"; }

  ::llvm::StringRef getDescription() const override { return "Improve coalescing for async global to local copies"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUCoalesceAsyncCopy");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUCoalesceAsyncCopy"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUCoalesceAsyncCopyBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUCoalesceAsyncCopy() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUCoalesceAsyncCopy() {
  return impl::createTritonGPUCoalesceAsyncCopy();
}
#undef GEN_PASS_DEF_TRITONGPUCOALESCEASYNCCOPY
#endif // GEN_PASS_DEF_TRITONGPUCOALESCEASYNCCOPY

//===----------------------------------------------------------------------===//
// TritonGPUCombineTensorSelectAndIf
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUCOMBINETENSORSELECTANDIF
std::unique_ptr<::mlir::Pass> createTritonGPUCombineTensorSelectAndIf();
#undef GEN_PASS_DECL_TRITONGPUCOMBINETENSORSELECTANDIF
#endif // GEN_PASS_DECL_TRITONGPUCOMBINETENSORSELECTANDIF
#ifdef GEN_PASS_DEF_TRITONGPUCOMBINETENSORSELECTANDIF

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUCombineTensorSelectAndIf();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUCombineTensorSelectAndIfBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUCombineTensorSelectAndIfBase;

  TritonGPUCombineTensorSelectAndIfBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUCombineTensorSelectAndIfBase(const TritonGPUCombineTensorSelectAndIfBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUCombineTensorSelectAndIfBase& operator=(const TritonGPUCombineTensorSelectAndIfBase &) = delete;
  TritonGPUCombineTensorSelectAndIfBase(TritonGPUCombineTensorSelectAndIfBase &&) = delete;
  TritonGPUCombineTensorSelectAndIfBase& operator=(TritonGPUCombineTensorSelectAndIfBase &&) = delete;
  ~TritonGPUCombineTensorSelectAndIfBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-combine-tensor-select-and-if");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-combine-tensor-select-and-if"; }

  ::llvm::StringRef getDescription() const override { return "Combine tensor select and if"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUCombineTensorSelectAndIf");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUCombineTensorSelectAndIf"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUCombineTensorSelectAndIfBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUCombineTensorSelectAndIf() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUCombineTensorSelectAndIf() {
  return impl::createTritonGPUCombineTensorSelectAndIf();
}
#undef GEN_PASS_DEF_TRITONGPUCOMBINETENSORSELECTANDIF
#endif // GEN_PASS_DEF_TRITONGPUCOMBINETENSORSELECTANDIF

//===----------------------------------------------------------------------===//
// TritonGPUF32DotTC
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUF32DOTTC
std::unique_ptr<::mlir::Pass> createTritonGPUF32DotTC();
#undef GEN_PASS_DECL_TRITONGPUF32DOTTC
#endif // GEN_PASS_DECL_TRITONGPUF32DOTTC
#ifdef GEN_PASS_DEF_TRITONGPUF32DOTTC

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUF32DotTC();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUF32DotTCBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUF32DotTCBase;

  TritonGPUF32DotTCBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUF32DotTCBase(const TritonGPUF32DotTCBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUF32DotTCBase& operator=(const TritonGPUF32DotTCBase &) = delete;
  TritonGPUF32DotTCBase(TritonGPUF32DotTCBase &&) = delete;
  TritonGPUF32DotTCBase& operator=(TritonGPUF32DotTCBase &&) = delete;
  ~TritonGPUF32DotTCBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-F32DotTC");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-F32DotTC"; }

  ::llvm::StringRef getDescription() const override { return "3xTF32 trick"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUF32DotTC");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUF32DotTC"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvidia_gpu::TritonNvidiaGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUF32DotTCBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUF32DotTC() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUF32DotTC() {
  return impl::createTritonGPUF32DotTC();
}
#undef GEN_PASS_DEF_TRITONGPUF32DOTTC
#endif // GEN_PASS_DEF_TRITONGPUF32DOTTC

//===----------------------------------------------------------------------===//
// TritonGPUFuseNestedLoops
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUFUSENESTEDLOOPS
std::unique_ptr<::mlir::Pass> createTritonGPUFuseNestedLoops();
#undef GEN_PASS_DECL_TRITONGPUFUSENESTEDLOOPS
#endif // GEN_PASS_DECL_TRITONGPUFUSENESTEDLOOPS
#ifdef GEN_PASS_DEF_TRITONGPUFUSENESTEDLOOPS

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUFuseNestedLoops();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUFuseNestedLoopsBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUFuseNestedLoopsBase;

  TritonGPUFuseNestedLoopsBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUFuseNestedLoopsBase(const TritonGPUFuseNestedLoopsBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUFuseNestedLoopsBase& operator=(const TritonGPUFuseNestedLoopsBase &) = delete;
  TritonGPUFuseNestedLoopsBase(TritonGPUFuseNestedLoopsBase &&) = delete;
  TritonGPUFuseNestedLoopsBase& operator=(TritonGPUFuseNestedLoopsBase &&) = delete;
  ~TritonGPUFuseNestedLoopsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-fuse-nested-loops");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-fuse-nested-loops"; }

  ::llvm::StringRef getDescription() const override { return "fuse nested loops for pipelining"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUFuseNestedLoops");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUFuseNestedLoops"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::arith::ArithDialect>();
    registry.insert<mlir::ub::UBDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUFuseNestedLoopsBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUFuseNestedLoops() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUFuseNestedLoops() {
  return impl::createTritonGPUFuseNestedLoops();
}
#undef GEN_PASS_DEF_TRITONGPUFUSENESTEDLOOPS
#endif // GEN_PASS_DEF_TRITONGPUFUSENESTEDLOOPS

//===----------------------------------------------------------------------===//
// TritonGPULoopScheduling
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPULOOPSCHEDULING
struct TritonGPULoopSchedulingOptions {
  int32_t numStages = 3;
};
std::unique_ptr<::mlir::Pass> createTritonGPULoopScheduling();
std::unique_ptr<::mlir::Pass> createTritonGPULoopScheduling(TritonGPULoopSchedulingOptions options);
#undef GEN_PASS_DECL_TRITONGPULOOPSCHEDULING
#endif // GEN_PASS_DECL_TRITONGPULOOPSCHEDULING
#ifdef GEN_PASS_DEF_TRITONGPULOOPSCHEDULING

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPULoopScheduling();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPULoopScheduling(TritonGPULoopSchedulingOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPULoopSchedulingBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPULoopSchedulingBase;

  TritonGPULoopSchedulingBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPULoopSchedulingBase(const TritonGPULoopSchedulingBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPULoopSchedulingBase& operator=(const TritonGPULoopSchedulingBase &) = delete;
  TritonGPULoopSchedulingBase(TritonGPULoopSchedulingBase &&) = delete;
  TritonGPULoopSchedulingBase& operator=(TritonGPULoopSchedulingBase &&) = delete;
  ~TritonGPULoopSchedulingBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-loop-scheduling");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-loop-scheduling"; }

  ::llvm::StringRef getDescription() const override { return "Generate loop scheduling for SWP"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPULoopScheduling");
  }
  ::llvm::StringRef getName() const override { return "TritonGPULoopScheduling"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPULoopSchedulingBase<DerivedT>)

  TritonGPULoopSchedulingBase(TritonGPULoopSchedulingOptions options) : TritonGPULoopSchedulingBase() {
    numStages = std::move(options.numStages);
  }
protected:
  ::mlir::Pass::Option<int32_t> numStages{*this, "num-stages", ::llvm::cl::desc("number of pipeline stages"), ::llvm::cl::init(3)};
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPULoopScheduling() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createTritonGPULoopScheduling(TritonGPULoopSchedulingOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPULoopScheduling() {
  return impl::createTritonGPULoopScheduling();
}

std::unique_ptr<::mlir::Pass> createTritonGPULoopScheduling(TritonGPULoopSchedulingOptions options) {
  return impl::createTritonGPULoopScheduling(std::move(options));
}
#undef GEN_PASS_DEF_TRITONGPULOOPSCHEDULING
#endif // GEN_PASS_DEF_TRITONGPULOOPSCHEDULING

//===----------------------------------------------------------------------===//
// TritonGPUOptimizeAccumulatorInit
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUOPTIMIZEACCUMULATORINIT
std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeAccumulatorInit();
#undef GEN_PASS_DECL_TRITONGPUOPTIMIZEACCUMULATORINIT
#endif // GEN_PASS_DECL_TRITONGPUOPTIMIZEACCUMULATORINIT
#ifdef GEN_PASS_DEF_TRITONGPUOPTIMIZEACCUMULATORINIT

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeAccumulatorInit();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUOptimizeAccumulatorInitBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUOptimizeAccumulatorInitBase;

  TritonGPUOptimizeAccumulatorInitBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUOptimizeAccumulatorInitBase(const TritonGPUOptimizeAccumulatorInitBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUOptimizeAccumulatorInitBase& operator=(const TritonGPUOptimizeAccumulatorInitBase &) = delete;
  TritonGPUOptimizeAccumulatorInitBase(TritonGPUOptimizeAccumulatorInitBase &&) = delete;
  TritonGPUOptimizeAccumulatorInitBase& operator=(TritonGPUOptimizeAccumulatorInitBase &&) = delete;
  ~TritonGPUOptimizeAccumulatorInitBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-optimize-accumulator-init");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-optimize-accumulator-init"; }

  ::llvm::StringRef getDescription() const override { return "Replace accumulator zero-initialization with the flag indicating first use of the accumulator"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUOptimizeAccumulatorInit");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUOptimizeAccumulatorInit"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUOptimizeAccumulatorInitBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeAccumulatorInit() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeAccumulatorInit() {
  return impl::createTritonGPUOptimizeAccumulatorInit();
}
#undef GEN_PASS_DEF_TRITONGPUOPTIMIZEACCUMULATORINIT
#endif // GEN_PASS_DEF_TRITONGPUOPTIMIZEACCUMULATORINIT

//===----------------------------------------------------------------------===//
// TritonGPUOptimizeDotOperands
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUOPTIMIZEDOTOPERANDS
struct TritonGPUOptimizeDotOperandsOptions {
  bool hoistLayoutConversion = true;
};
std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeDotOperands();
std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeDotOperands(TritonGPUOptimizeDotOperandsOptions options);
#undef GEN_PASS_DECL_TRITONGPUOPTIMIZEDOTOPERANDS
#endif // GEN_PASS_DECL_TRITONGPUOPTIMIZEDOTOPERANDS
#ifdef GEN_PASS_DEF_TRITONGPUOPTIMIZEDOTOPERANDS

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeDotOperands();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeDotOperands(TritonGPUOptimizeDotOperandsOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUOptimizeDotOperandsBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUOptimizeDotOperandsBase;

  TritonGPUOptimizeDotOperandsBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUOptimizeDotOperandsBase(const TritonGPUOptimizeDotOperandsBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUOptimizeDotOperandsBase& operator=(const TritonGPUOptimizeDotOperandsBase &) = delete;
  TritonGPUOptimizeDotOperandsBase(TritonGPUOptimizeDotOperandsBase &&) = delete;
  TritonGPUOptimizeDotOperandsBase& operator=(TritonGPUOptimizeDotOperandsBase &&) = delete;
  ~TritonGPUOptimizeDotOperandsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-optimize-dot-operands");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-optimize-dot-operands"; }

  ::llvm::StringRef getDescription() const override { return "fuse transpositions"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUOptimizeDotOperands");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUOptimizeDotOperands"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvidia_gpu::TritonNvidiaGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUOptimizeDotOperandsBase<DerivedT>)

  TritonGPUOptimizeDotOperandsBase(TritonGPUOptimizeDotOperandsOptions options) : TritonGPUOptimizeDotOperandsBase() {
    hoistLayoutConversion = std::move(options.hoistLayoutConversion);
  }
protected:
  ::mlir::Pass::Option<bool> hoistLayoutConversion{*this, "hoist-layout-conversion", ::llvm::cl::desc("whether to move conver to dot operand earlier pass elementwise ops"), ::llvm::cl::init(true)};
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeDotOperands() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeDotOperands(TritonGPUOptimizeDotOperandsOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeDotOperands() {
  return impl::createTritonGPUOptimizeDotOperands();
}

std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeDotOperands(TritonGPUOptimizeDotOperandsOptions options) {
  return impl::createTritonGPUOptimizeDotOperands(std::move(options));
}
#undef GEN_PASS_DEF_TRITONGPUOPTIMIZEDOTOPERANDS
#endif // GEN_PASS_DEF_TRITONGPUOPTIMIZEDOTOPERANDS

//===----------------------------------------------------------------------===//
// TritonGPUOptimizeThreadLocality
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUOPTIMIZETHREADLOCALITY
std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeThreadLocality();
#undef GEN_PASS_DECL_TRITONGPUOPTIMIZETHREADLOCALITY
#endif // GEN_PASS_DECL_TRITONGPUOPTIMIZETHREADLOCALITY
#ifdef GEN_PASS_DEF_TRITONGPUOPTIMIZETHREADLOCALITY

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeThreadLocality();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUOptimizeThreadLocalityBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUOptimizeThreadLocalityBase;

  TritonGPUOptimizeThreadLocalityBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUOptimizeThreadLocalityBase(const TritonGPUOptimizeThreadLocalityBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUOptimizeThreadLocalityBase& operator=(const TritonGPUOptimizeThreadLocalityBase &) = delete;
  TritonGPUOptimizeThreadLocalityBase(TritonGPUOptimizeThreadLocalityBase &&) = delete;
  TritonGPUOptimizeThreadLocalityBase& operator=(TritonGPUOptimizeThreadLocalityBase &&) = delete;
  ~TritonGPUOptimizeThreadLocalityBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-optimize-thread-locality");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-optimize-thread-locality"; }

  ::llvm::StringRef getDescription() const override { return "Reduce the cost of synchronization between threads in an SM"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUOptimizeThreadLocality");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUOptimizeThreadLocality"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUOptimizeThreadLocalityBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeThreadLocality() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUOptimizeThreadLocality() {
  return impl::createTritonGPUOptimizeThreadLocality();
}
#undef GEN_PASS_DEF_TRITONGPUOPTIMIZETHREADLOCALITY
#endif // GEN_PASS_DEF_TRITONGPUOPTIMIZETHREADLOCALITY

//===----------------------------------------------------------------------===//
// TritonGPUPipeline
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUPIPELINE
struct TritonGPUPipelineOptions {
  int32_t numStages = 3;
};
std::unique_ptr<::mlir::Pass> createTritonGPUPipeline();
std::unique_ptr<::mlir::Pass> createTritonGPUPipeline(TritonGPUPipelineOptions options);
#undef GEN_PASS_DECL_TRITONGPUPIPELINE
#endif // GEN_PASS_DECL_TRITONGPUPIPELINE
#ifdef GEN_PASS_DEF_TRITONGPUPIPELINE

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUPipeline();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUPipeline(TritonGPUPipelineOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUPipelineBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUPipelineBase;

  TritonGPUPipelineBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUPipelineBase(const TritonGPUPipelineBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUPipelineBase& operator=(const TritonGPUPipelineBase &) = delete;
  TritonGPUPipelineBase(TritonGPUPipelineBase &&) = delete;
  TritonGPUPipelineBase& operator=(TritonGPUPipelineBase &&) = delete;
  ~TritonGPUPipelineBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-pipeline");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-pipeline"; }

  ::llvm::StringRef getDescription() const override { return "pipeline"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUPipeline");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUPipeline"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvidia_gpu::TritonNvidiaGPUDialect>();
    registry.insert<mlir::scf::SCFDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUPipelineBase<DerivedT>)

  TritonGPUPipelineBase(TritonGPUPipelineOptions options) : TritonGPUPipelineBase() {
    numStages = std::move(options.numStages);
  }
protected:
  ::mlir::Pass::Option<int32_t> numStages{*this, "num-stages", ::llvm::cl::desc("number of pipeline stages"), ::llvm::cl::init(3)};
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUPipeline() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createTritonGPUPipeline(TritonGPUPipelineOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUPipeline() {
  return impl::createTritonGPUPipeline();
}

std::unique_ptr<::mlir::Pass> createTritonGPUPipeline(TritonGPUPipelineOptions options) {
  return impl::createTritonGPUPipeline(std::move(options));
}
#undef GEN_PASS_DEF_TRITONGPUPIPELINE
#endif // GEN_PASS_DEF_TRITONGPUPIPELINE

//===----------------------------------------------------------------------===//
// TritonGPUPrefetch
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUPREFETCH
std::unique_ptr<::mlir::Pass> createTritonGPUPrefetch();
#undef GEN_PASS_DECL_TRITONGPUPREFETCH
#endif // GEN_PASS_DECL_TRITONGPUPREFETCH
#ifdef GEN_PASS_DEF_TRITONGPUPREFETCH

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUPrefetch();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUPrefetchBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUPrefetchBase;

  TritonGPUPrefetchBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUPrefetchBase(const TritonGPUPrefetchBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUPrefetchBase& operator=(const TritonGPUPrefetchBase &) = delete;
  TritonGPUPrefetchBase(TritonGPUPrefetchBase &&) = delete;
  TritonGPUPrefetchBase& operator=(TritonGPUPrefetchBase &&) = delete;
  ~TritonGPUPrefetchBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-prefetch");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-prefetch"; }

  ::llvm::StringRef getDescription() const override { return "prefetch"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUPrefetch");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUPrefetch"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::scf::SCFDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUPrefetchBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUPrefetch() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUPrefetch() {
  return impl::createTritonGPUPrefetch();
}
#undef GEN_PASS_DEF_TRITONGPUPREFETCH
#endif // GEN_PASS_DEF_TRITONGPUPREFETCH

//===----------------------------------------------------------------------===//
// TritonGPUReduceDataDuplication
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUREDUCEDATADUPLICATION
std::unique_ptr<::mlir::Pass> createTritonGPUReduceDataDuplication();
#undef GEN_PASS_DECL_TRITONGPUREDUCEDATADUPLICATION
#endif // GEN_PASS_DECL_TRITONGPUREDUCEDATADUPLICATION
#ifdef GEN_PASS_DEF_TRITONGPUREDUCEDATADUPLICATION

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUReduceDataDuplication();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUReduceDataDuplicationBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUReduceDataDuplicationBase;

  TritonGPUReduceDataDuplicationBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUReduceDataDuplicationBase(const TritonGPUReduceDataDuplicationBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUReduceDataDuplicationBase& operator=(const TritonGPUReduceDataDuplicationBase &) = delete;
  TritonGPUReduceDataDuplicationBase(TritonGPUReduceDataDuplicationBase &&) = delete;
  TritonGPUReduceDataDuplicationBase& operator=(TritonGPUReduceDataDuplicationBase &&) = delete;
  ~TritonGPUReduceDataDuplicationBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-reduce-data-duplication");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-reduce-data-duplication"; }

  ::llvm::StringRef getDescription() const override { return "Reduce data duplication in register by decomposing convert[distributed -> dotOperand] into convert[distributed -> shared -> dotOperand]"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUReduceDataDuplication");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUReduceDataDuplication"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUReduceDataDuplicationBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUReduceDataDuplication() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUReduceDataDuplication() {
  return impl::createTritonGPUReduceDataDuplication();
}
#undef GEN_PASS_DEF_TRITONGPUREDUCEDATADUPLICATION
#endif // GEN_PASS_DEF_TRITONGPUREDUCEDATADUPLICATION

//===----------------------------------------------------------------------===//
// TritonGPURemoveLayoutConversions
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUREMOVELAYOUTCONVERSIONS
std::unique_ptr<::mlir::Pass> createTritonGPURemoveLayoutConversions();
#undef GEN_PASS_DECL_TRITONGPUREMOVELAYOUTCONVERSIONS
#endif // GEN_PASS_DECL_TRITONGPUREMOVELAYOUTCONVERSIONS
#ifdef GEN_PASS_DEF_TRITONGPUREMOVELAYOUTCONVERSIONS

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPURemoveLayoutConversions();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPURemoveLayoutConversionsBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPURemoveLayoutConversionsBase;

  TritonGPURemoveLayoutConversionsBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPURemoveLayoutConversionsBase(const TritonGPURemoveLayoutConversionsBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPURemoveLayoutConversionsBase& operator=(const TritonGPURemoveLayoutConversionsBase &) = delete;
  TritonGPURemoveLayoutConversionsBase(TritonGPURemoveLayoutConversionsBase &&) = delete;
  TritonGPURemoveLayoutConversionsBase& operator=(TritonGPURemoveLayoutConversionsBase &&) = delete;
  ~TritonGPURemoveLayoutConversionsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-remove-layout-conversions");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-remove-layout-conversions"; }

  ::llvm::StringRef getDescription() const override { return "remove superfluous layout conversions"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPURemoveLayoutConversions");
  }
  ::llvm::StringRef getName() const override { return "TritonGPURemoveLayoutConversions"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPURemoveLayoutConversionsBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPURemoveLayoutConversions() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPURemoveLayoutConversions() {
  return impl::createTritonGPURemoveLayoutConversions();
}
#undef GEN_PASS_DEF_TRITONGPUREMOVELAYOUTCONVERSIONS
#endif // GEN_PASS_DEF_TRITONGPUREMOVELAYOUTCONVERSIONS

//===----------------------------------------------------------------------===//
// TritonGPUReorderInstructions
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUREORDERINSTRUCTIONS
std::unique_ptr<::mlir::Pass> createTritonGPUReorderInstructions();
#undef GEN_PASS_DECL_TRITONGPUREORDERINSTRUCTIONS
#endif // GEN_PASS_DECL_TRITONGPUREORDERINSTRUCTIONS
#ifdef GEN_PASS_DEF_TRITONGPUREORDERINSTRUCTIONS

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUReorderInstructions();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUReorderInstructionsBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUReorderInstructionsBase;

  TritonGPUReorderInstructionsBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUReorderInstructionsBase(const TritonGPUReorderInstructionsBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUReorderInstructionsBase& operator=(const TritonGPUReorderInstructionsBase &) = delete;
  TritonGPUReorderInstructionsBase(TritonGPUReorderInstructionsBase &&) = delete;
  TritonGPUReorderInstructionsBase& operator=(TritonGPUReorderInstructionsBase &&) = delete;
  ~TritonGPUReorderInstructionsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-reorder-instructions");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-reorder-instructions"; }

  ::llvm::StringRef getDescription() const override { return "Reorder instructions"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUReorderInstructions");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUReorderInstructions"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUReorderInstructionsBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUReorderInstructions() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUReorderInstructions() {
  return impl::createTritonGPUReorderInstructions();
}
#undef GEN_PASS_DEF_TRITONGPUREORDERINSTRUCTIONS
#endif // GEN_PASS_DEF_TRITONGPUREORDERINSTRUCTIONS

//===----------------------------------------------------------------------===//
// TritonGPUTestPipelineAssignLatencies
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUTESTPIPELINEASSIGNLATENCIES
struct TritonGPUTestPipelineAssignLatenciesOptions {
  int32_t numStages = 3;
};
std::unique_ptr<::mlir::Pass> createTritonGPUTestPipelineAssignLatencies();
std::unique_ptr<::mlir::Pass> createTritonGPUTestPipelineAssignLatencies(TritonGPUTestPipelineAssignLatenciesOptions options);
#undef GEN_PASS_DECL_TRITONGPUTESTPIPELINEASSIGNLATENCIES
#endif // GEN_PASS_DECL_TRITONGPUTESTPIPELINEASSIGNLATENCIES
#ifdef GEN_PASS_DEF_TRITONGPUTESTPIPELINEASSIGNLATENCIES

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUTestPipelineAssignLatencies();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUTestPipelineAssignLatencies(TritonGPUTestPipelineAssignLatenciesOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUTestPipelineAssignLatenciesBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUTestPipelineAssignLatenciesBase;

  TritonGPUTestPipelineAssignLatenciesBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUTestPipelineAssignLatenciesBase(const TritonGPUTestPipelineAssignLatenciesBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUTestPipelineAssignLatenciesBase& operator=(const TritonGPUTestPipelineAssignLatenciesBase &) = delete;
  TritonGPUTestPipelineAssignLatenciesBase(TritonGPUTestPipelineAssignLatenciesBase &&) = delete;
  TritonGPUTestPipelineAssignLatenciesBase& operator=(TritonGPUTestPipelineAssignLatenciesBase &&) = delete;
  ~TritonGPUTestPipelineAssignLatenciesBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-test-pipeline-assign-latencies");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-test-pipeline-assign-latencies"; }

  ::llvm::StringRef getDescription() const override { return "test assigning latencies to interesting ops ahead of pipelining"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUTestPipelineAssignLatencies");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUTestPipelineAssignLatencies"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvidia_gpu::TritonNvidiaGPUDialect>();
    registry.insert<mlir::scf::SCFDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUTestPipelineAssignLatenciesBase<DerivedT>)

  TritonGPUTestPipelineAssignLatenciesBase(TritonGPUTestPipelineAssignLatenciesOptions options) : TritonGPUTestPipelineAssignLatenciesBase() {
    numStages = std::move(options.numStages);
  }
protected:
  ::mlir::Pass::Option<int32_t> numStages{*this, "num-stages", ::llvm::cl::desc("number of pipeline stages"), ::llvm::cl::init(3)};
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUTestPipelineAssignLatencies() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createTritonGPUTestPipelineAssignLatencies(TritonGPUTestPipelineAssignLatenciesOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUTestPipelineAssignLatencies() {
  return impl::createTritonGPUTestPipelineAssignLatencies();
}

std::unique_ptr<::mlir::Pass> createTritonGPUTestPipelineAssignLatencies(TritonGPUTestPipelineAssignLatenciesOptions options) {
  return impl::createTritonGPUTestPipelineAssignLatencies(std::move(options));
}
#undef GEN_PASS_DEF_TRITONGPUTESTPIPELINEASSIGNLATENCIES
#endif // GEN_PASS_DEF_TRITONGPUTESTPIPELINEASSIGNLATENCIES

//===----------------------------------------------------------------------===//
// TritonGPUTestPipelineScheduleLoop
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TRITONGPUTESTPIPELINESCHEDULELOOP
std::unique_ptr<::mlir::Pass> createTritonGPUTestPipelineScheduleLoop();
#undef GEN_PASS_DECL_TRITONGPUTESTPIPELINESCHEDULELOOP
#endif // GEN_PASS_DECL_TRITONGPUTESTPIPELINESCHEDULELOOP
#ifdef GEN_PASS_DEF_TRITONGPUTESTPIPELINESCHEDULELOOP

namespace impl {
  std::unique_ptr<::mlir::Pass> createTritonGPUTestPipelineScheduleLoop();
} // namespace impl
namespace impl {

template <typename DerivedT>
class TritonGPUTestPipelineScheduleLoopBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUTestPipelineScheduleLoopBase;

  TritonGPUTestPipelineScheduleLoopBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUTestPipelineScheduleLoopBase(const TritonGPUTestPipelineScheduleLoopBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUTestPipelineScheduleLoopBase& operator=(const TritonGPUTestPipelineScheduleLoopBase &) = delete;
  TritonGPUTestPipelineScheduleLoopBase(TritonGPUTestPipelineScheduleLoopBase &&) = delete;
  TritonGPUTestPipelineScheduleLoopBase& operator=(TritonGPUTestPipelineScheduleLoopBase &&) = delete;
  ~TritonGPUTestPipelineScheduleLoopBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-test-pipeline-schedule-loop");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-test-pipeline-schedule-loop"; }

  ::llvm::StringRef getDescription() const override { return "test scheduling a loop for software pipelining"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUTestPipelineScheduleLoop");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUTestPipelineScheduleLoop"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvidia_gpu::TritonNvidiaGPUDialect>();
    registry.insert<mlir::scf::SCFDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUTestPipelineScheduleLoopBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createTritonGPUTestPipelineScheduleLoop() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTritonGPUTestPipelineScheduleLoop() {
  return impl::createTritonGPUTestPipelineScheduleLoop();
}
#undef GEN_PASS_DEF_TRITONGPUTESTPIPELINESCHEDULELOOP
#endif // GEN_PASS_DEF_TRITONGPUTESTPIPELINESCHEDULELOOP
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// TritonGPUAccelerateMatmul Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUAccelerateMatmul() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUAccelerateMatmul();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUAccelerateMatmulPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUAccelerateMatmul();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUCoalesce Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUCoalesce() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUCoalesce();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUCoalescePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUCoalesce();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUCoalesceAsyncCopy Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUCoalesceAsyncCopy() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUCoalesceAsyncCopy();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUCoalesceAsyncCopyPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUCoalesceAsyncCopy();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUCombineTensorSelectAndIf Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUCombineTensorSelectAndIf() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUCombineTensorSelectAndIf();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUCombineTensorSelectAndIfPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUCombineTensorSelectAndIf();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUF32DotTC Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUF32DotTC() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUF32DotTC();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUF32DotTCPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUF32DotTC();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUFuseNestedLoops Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUFuseNestedLoops() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUFuseNestedLoops();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUFuseNestedLoopsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUFuseNestedLoops();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPULoopScheduling Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPULoopScheduling() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPULoopScheduling();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPULoopSchedulingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPULoopScheduling();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUOptimizeAccumulatorInit Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUOptimizeAccumulatorInit() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUOptimizeAccumulatorInit();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUOptimizeAccumulatorInitPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUOptimizeAccumulatorInit();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUOptimizeDotOperands Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUOptimizeDotOperands() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUOptimizeDotOperands();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUOptimizeDotOperandsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUOptimizeDotOperands();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUOptimizeThreadLocality Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUOptimizeThreadLocality() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUOptimizeThreadLocality();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUOptimizeThreadLocalityPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUOptimizeThreadLocality();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUPipeline Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUPipeline() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUPipeline();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUPipelinePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUPipeline();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUPrefetch Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUPrefetch() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUPrefetch();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUPrefetchPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUPrefetch();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUReduceDataDuplication Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUReduceDataDuplication() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUReduceDataDuplication();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUReduceDataDuplicationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUReduceDataDuplication();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPURemoveLayoutConversions Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPURemoveLayoutConversions() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPURemoveLayoutConversions();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPURemoveLayoutConversionsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPURemoveLayoutConversions();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUReorderInstructions Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUReorderInstructions() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUReorderInstructions();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUReorderInstructionsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUReorderInstructions();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUTestPipelineAssignLatencies Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUTestPipelineAssignLatencies() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUTestPipelineAssignLatencies();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUTestPipelineAssignLatenciesPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUTestPipelineAssignLatencies();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPUTestPipelineScheduleLoop Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUTestPipelineScheduleLoop() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUTestPipelineScheduleLoop();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTritonGPUTestPipelineScheduleLoopPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTritonGPUTestPipelineScheduleLoop();
  });
}

//===----------------------------------------------------------------------===//
// TritonGPU Registration
//===----------------------------------------------------------------------===//

inline void registerTritonGPUPasses() {
  registerTritonGPUAccelerateMatmul();
  registerTritonGPUCoalesce();
  registerTritonGPUCoalesceAsyncCopy();
  registerTritonGPUCombineTensorSelectAndIf();
  registerTritonGPUF32DotTC();
  registerTritonGPUFuseNestedLoops();
  registerTritonGPULoopScheduling();
  registerTritonGPUOptimizeAccumulatorInit();
  registerTritonGPUOptimizeDotOperands();
  registerTritonGPUOptimizeThreadLocality();
  registerTritonGPUPipeline();
  registerTritonGPUPrefetch();
  registerTritonGPUReduceDataDuplication();
  registerTritonGPURemoveLayoutConversions();
  registerTritonGPUReorderInstructions();
  registerTritonGPUTestPipelineAssignLatencies();
  registerTritonGPUTestPipelineScheduleLoop();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
// Deprecated. Please use the new per-pass macros.
#ifdef GEN_PASS_CLASSES

template <typename DerivedT>
class TritonGPUAccelerateMatmulBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUAccelerateMatmulBase;

  TritonGPUAccelerateMatmulBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUAccelerateMatmulBase(const TritonGPUAccelerateMatmulBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUAccelerateMatmulBase& operator=(const TritonGPUAccelerateMatmulBase &) = delete;
  TritonGPUAccelerateMatmulBase(TritonGPUAccelerateMatmulBase &&) = delete;
  TritonGPUAccelerateMatmulBase& operator=(TritonGPUAccelerateMatmulBase &&) = delete;
  ~TritonGPUAccelerateMatmulBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-accelerate-matmul");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-accelerate-matmul"; }

  ::llvm::StringRef getDescription() const override { return "accelerate matmul"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUAccelerateMatmul");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUAccelerateMatmul"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvidia_gpu::TritonNvidiaGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUAccelerateMatmulBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TritonGPUCoalesceBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUCoalesceBase;

  TritonGPUCoalesceBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUCoalesceBase(const TritonGPUCoalesceBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUCoalesceBase& operator=(const TritonGPUCoalesceBase &) = delete;
  TritonGPUCoalesceBase(TritonGPUCoalesceBase &&) = delete;
  TritonGPUCoalesceBase& operator=(TritonGPUCoalesceBase &&) = delete;
  ~TritonGPUCoalesceBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-coalesce");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-coalesce"; }

  ::llvm::StringRef getDescription() const override { return "coalesce"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUCoalesce");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUCoalesce"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUCoalesceBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TritonGPUCoalesceAsyncCopyBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUCoalesceAsyncCopyBase;

  TritonGPUCoalesceAsyncCopyBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUCoalesceAsyncCopyBase(const TritonGPUCoalesceAsyncCopyBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUCoalesceAsyncCopyBase& operator=(const TritonGPUCoalesceAsyncCopyBase &) = delete;
  TritonGPUCoalesceAsyncCopyBase(TritonGPUCoalesceAsyncCopyBase &&) = delete;
  TritonGPUCoalesceAsyncCopyBase& operator=(TritonGPUCoalesceAsyncCopyBase &&) = delete;
  ~TritonGPUCoalesceAsyncCopyBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-coalesce-async-copy");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-coalesce-async-copy"; }

  ::llvm::StringRef getDescription() const override { return "Improve coalescing for async global to local copies"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUCoalesceAsyncCopy");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUCoalesceAsyncCopy"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUCoalesceAsyncCopyBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TritonGPUCombineTensorSelectAndIfBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUCombineTensorSelectAndIfBase;

  TritonGPUCombineTensorSelectAndIfBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUCombineTensorSelectAndIfBase(const TritonGPUCombineTensorSelectAndIfBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUCombineTensorSelectAndIfBase& operator=(const TritonGPUCombineTensorSelectAndIfBase &) = delete;
  TritonGPUCombineTensorSelectAndIfBase(TritonGPUCombineTensorSelectAndIfBase &&) = delete;
  TritonGPUCombineTensorSelectAndIfBase& operator=(TritonGPUCombineTensorSelectAndIfBase &&) = delete;
  ~TritonGPUCombineTensorSelectAndIfBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-combine-tensor-select-and-if");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-combine-tensor-select-and-if"; }

  ::llvm::StringRef getDescription() const override { return "Combine tensor select and if"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUCombineTensorSelectAndIf");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUCombineTensorSelectAndIf"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUCombineTensorSelectAndIfBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TritonGPUF32DotTCBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUF32DotTCBase;

  TritonGPUF32DotTCBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUF32DotTCBase(const TritonGPUF32DotTCBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUF32DotTCBase& operator=(const TritonGPUF32DotTCBase &) = delete;
  TritonGPUF32DotTCBase(TritonGPUF32DotTCBase &&) = delete;
  TritonGPUF32DotTCBase& operator=(TritonGPUF32DotTCBase &&) = delete;
  ~TritonGPUF32DotTCBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-F32DotTC");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-F32DotTC"; }

  ::llvm::StringRef getDescription() const override { return "3xTF32 trick"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUF32DotTC");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUF32DotTC"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvidia_gpu::TritonNvidiaGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUF32DotTCBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TritonGPUFuseNestedLoopsBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUFuseNestedLoopsBase;

  TritonGPUFuseNestedLoopsBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUFuseNestedLoopsBase(const TritonGPUFuseNestedLoopsBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUFuseNestedLoopsBase& operator=(const TritonGPUFuseNestedLoopsBase &) = delete;
  TritonGPUFuseNestedLoopsBase(TritonGPUFuseNestedLoopsBase &&) = delete;
  TritonGPUFuseNestedLoopsBase& operator=(TritonGPUFuseNestedLoopsBase &&) = delete;
  ~TritonGPUFuseNestedLoopsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-fuse-nested-loops");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-fuse-nested-loops"; }

  ::llvm::StringRef getDescription() const override { return "fuse nested loops for pipelining"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUFuseNestedLoops");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUFuseNestedLoops"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::arith::ArithDialect>();
    registry.insert<mlir::ub::UBDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUFuseNestedLoopsBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TritonGPULoopSchedulingBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPULoopSchedulingBase;

  TritonGPULoopSchedulingBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPULoopSchedulingBase(const TritonGPULoopSchedulingBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPULoopSchedulingBase& operator=(const TritonGPULoopSchedulingBase &) = delete;
  TritonGPULoopSchedulingBase(TritonGPULoopSchedulingBase &&) = delete;
  TritonGPULoopSchedulingBase& operator=(TritonGPULoopSchedulingBase &&) = delete;
  ~TritonGPULoopSchedulingBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-loop-scheduling");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-loop-scheduling"; }

  ::llvm::StringRef getDescription() const override { return "Generate loop scheduling for SWP"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPULoopScheduling");
  }
  ::llvm::StringRef getName() const override { return "TritonGPULoopScheduling"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPULoopSchedulingBase<DerivedT>)

protected:
  ::mlir::Pass::Option<int32_t> numStages{*this, "num-stages", ::llvm::cl::desc("number of pipeline stages"), ::llvm::cl::init(3)};
};

template <typename DerivedT>
class TritonGPUOptimizeAccumulatorInitBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUOptimizeAccumulatorInitBase;

  TritonGPUOptimizeAccumulatorInitBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUOptimizeAccumulatorInitBase(const TritonGPUOptimizeAccumulatorInitBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUOptimizeAccumulatorInitBase& operator=(const TritonGPUOptimizeAccumulatorInitBase &) = delete;
  TritonGPUOptimizeAccumulatorInitBase(TritonGPUOptimizeAccumulatorInitBase &&) = delete;
  TritonGPUOptimizeAccumulatorInitBase& operator=(TritonGPUOptimizeAccumulatorInitBase &&) = delete;
  ~TritonGPUOptimizeAccumulatorInitBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-optimize-accumulator-init");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-optimize-accumulator-init"; }

  ::llvm::StringRef getDescription() const override { return "Replace accumulator zero-initialization with the flag indicating first use of the accumulator"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUOptimizeAccumulatorInit");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUOptimizeAccumulatorInit"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUOptimizeAccumulatorInitBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TritonGPUOptimizeDotOperandsBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUOptimizeDotOperandsBase;

  TritonGPUOptimizeDotOperandsBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUOptimizeDotOperandsBase(const TritonGPUOptimizeDotOperandsBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUOptimizeDotOperandsBase& operator=(const TritonGPUOptimizeDotOperandsBase &) = delete;
  TritonGPUOptimizeDotOperandsBase(TritonGPUOptimizeDotOperandsBase &&) = delete;
  TritonGPUOptimizeDotOperandsBase& operator=(TritonGPUOptimizeDotOperandsBase &&) = delete;
  ~TritonGPUOptimizeDotOperandsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-optimize-dot-operands");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-optimize-dot-operands"; }

  ::llvm::StringRef getDescription() const override { return "fuse transpositions"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUOptimizeDotOperands");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUOptimizeDotOperands"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvidia_gpu::TritonNvidiaGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUOptimizeDotOperandsBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> hoistLayoutConversion{*this, "hoist-layout-conversion", ::llvm::cl::desc("whether to move conver to dot operand earlier pass elementwise ops"), ::llvm::cl::init(true)};
};

template <typename DerivedT>
class TritonGPUOptimizeThreadLocalityBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUOptimizeThreadLocalityBase;

  TritonGPUOptimizeThreadLocalityBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUOptimizeThreadLocalityBase(const TritonGPUOptimizeThreadLocalityBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUOptimizeThreadLocalityBase& operator=(const TritonGPUOptimizeThreadLocalityBase &) = delete;
  TritonGPUOptimizeThreadLocalityBase(TritonGPUOptimizeThreadLocalityBase &&) = delete;
  TritonGPUOptimizeThreadLocalityBase& operator=(TritonGPUOptimizeThreadLocalityBase &&) = delete;
  ~TritonGPUOptimizeThreadLocalityBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-optimize-thread-locality");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-optimize-thread-locality"; }

  ::llvm::StringRef getDescription() const override { return "Reduce the cost of synchronization between threads in an SM"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUOptimizeThreadLocality");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUOptimizeThreadLocality"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUOptimizeThreadLocalityBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TritonGPUPipelineBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUPipelineBase;

  TritonGPUPipelineBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUPipelineBase(const TritonGPUPipelineBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUPipelineBase& operator=(const TritonGPUPipelineBase &) = delete;
  TritonGPUPipelineBase(TritonGPUPipelineBase &&) = delete;
  TritonGPUPipelineBase& operator=(TritonGPUPipelineBase &&) = delete;
  ~TritonGPUPipelineBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-pipeline");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-pipeline"; }

  ::llvm::StringRef getDescription() const override { return "pipeline"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUPipeline");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUPipeline"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvidia_gpu::TritonNvidiaGPUDialect>();
    registry.insert<mlir::scf::SCFDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUPipelineBase<DerivedT>)

protected:
  ::mlir::Pass::Option<int32_t> numStages{*this, "num-stages", ::llvm::cl::desc("number of pipeline stages"), ::llvm::cl::init(3)};
};

template <typename DerivedT>
class TritonGPUPrefetchBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUPrefetchBase;

  TritonGPUPrefetchBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUPrefetchBase(const TritonGPUPrefetchBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUPrefetchBase& operator=(const TritonGPUPrefetchBase &) = delete;
  TritonGPUPrefetchBase(TritonGPUPrefetchBase &&) = delete;
  TritonGPUPrefetchBase& operator=(TritonGPUPrefetchBase &&) = delete;
  ~TritonGPUPrefetchBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-prefetch");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-prefetch"; }

  ::llvm::StringRef getDescription() const override { return "prefetch"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUPrefetch");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUPrefetch"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::scf::SCFDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUPrefetchBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TritonGPUReduceDataDuplicationBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUReduceDataDuplicationBase;

  TritonGPUReduceDataDuplicationBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUReduceDataDuplicationBase(const TritonGPUReduceDataDuplicationBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUReduceDataDuplicationBase& operator=(const TritonGPUReduceDataDuplicationBase &) = delete;
  TritonGPUReduceDataDuplicationBase(TritonGPUReduceDataDuplicationBase &&) = delete;
  TritonGPUReduceDataDuplicationBase& operator=(TritonGPUReduceDataDuplicationBase &&) = delete;
  ~TritonGPUReduceDataDuplicationBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-reduce-data-duplication");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-reduce-data-duplication"; }

  ::llvm::StringRef getDescription() const override { return "Reduce data duplication in register by decomposing convert[distributed -> dotOperand] into convert[distributed -> shared -> dotOperand]"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUReduceDataDuplication");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUReduceDataDuplication"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUReduceDataDuplicationBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TritonGPURemoveLayoutConversionsBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPURemoveLayoutConversionsBase;

  TritonGPURemoveLayoutConversionsBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPURemoveLayoutConversionsBase(const TritonGPURemoveLayoutConversionsBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPURemoveLayoutConversionsBase& operator=(const TritonGPURemoveLayoutConversionsBase &) = delete;
  TritonGPURemoveLayoutConversionsBase(TritonGPURemoveLayoutConversionsBase &&) = delete;
  TritonGPURemoveLayoutConversionsBase& operator=(TritonGPURemoveLayoutConversionsBase &&) = delete;
  ~TritonGPURemoveLayoutConversionsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-remove-layout-conversions");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-remove-layout-conversions"; }

  ::llvm::StringRef getDescription() const override { return "remove superfluous layout conversions"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPURemoveLayoutConversions");
  }
  ::llvm::StringRef getName() const override { return "TritonGPURemoveLayoutConversions"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPURemoveLayoutConversionsBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TritonGPUReorderInstructionsBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUReorderInstructionsBase;

  TritonGPUReorderInstructionsBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUReorderInstructionsBase(const TritonGPUReorderInstructionsBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUReorderInstructionsBase& operator=(const TritonGPUReorderInstructionsBase &) = delete;
  TritonGPUReorderInstructionsBase(TritonGPUReorderInstructionsBase &&) = delete;
  TritonGPUReorderInstructionsBase& operator=(TritonGPUReorderInstructionsBase &&) = delete;
  ~TritonGPUReorderInstructionsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-reorder-instructions");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-reorder-instructions"; }

  ::llvm::StringRef getDescription() const override { return "Reorder instructions"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUReorderInstructions");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUReorderInstructions"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::TritonDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUReorderInstructionsBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TritonGPUTestPipelineAssignLatenciesBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUTestPipelineAssignLatenciesBase;

  TritonGPUTestPipelineAssignLatenciesBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUTestPipelineAssignLatenciesBase(const TritonGPUTestPipelineAssignLatenciesBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUTestPipelineAssignLatenciesBase& operator=(const TritonGPUTestPipelineAssignLatenciesBase &) = delete;
  TritonGPUTestPipelineAssignLatenciesBase(TritonGPUTestPipelineAssignLatenciesBase &&) = delete;
  TritonGPUTestPipelineAssignLatenciesBase& operator=(TritonGPUTestPipelineAssignLatenciesBase &&) = delete;
  ~TritonGPUTestPipelineAssignLatenciesBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-test-pipeline-assign-latencies");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-test-pipeline-assign-latencies"; }

  ::llvm::StringRef getDescription() const override { return "test assigning latencies to interesting ops ahead of pipelining"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUTestPipelineAssignLatencies");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUTestPipelineAssignLatencies"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvidia_gpu::TritonNvidiaGPUDialect>();
    registry.insert<mlir::scf::SCFDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUTestPipelineAssignLatenciesBase<DerivedT>)

protected:
  ::mlir::Pass::Option<int32_t> numStages{*this, "num-stages", ::llvm::cl::desc("number of pipeline stages"), ::llvm::cl::init(3)};
};

template <typename DerivedT>
class TritonGPUTestPipelineScheduleLoopBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TritonGPUTestPipelineScheduleLoopBase;

  TritonGPUTestPipelineScheduleLoopBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TritonGPUTestPipelineScheduleLoopBase(const TritonGPUTestPipelineScheduleLoopBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  TritonGPUTestPipelineScheduleLoopBase& operator=(const TritonGPUTestPipelineScheduleLoopBase &) = delete;
  TritonGPUTestPipelineScheduleLoopBase(TritonGPUTestPipelineScheduleLoopBase &&) = delete;
  TritonGPUTestPipelineScheduleLoopBase& operator=(TritonGPUTestPipelineScheduleLoopBase &&) = delete;
  ~TritonGPUTestPipelineScheduleLoopBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tritongpu-test-pipeline-schedule-loop");
  }
  ::llvm::StringRef getArgument() const override { return "tritongpu-test-pipeline-schedule-loop"; }

  ::llvm::StringRef getDescription() const override { return "test scheduling a loop for software pipelining"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TritonGPUTestPipelineScheduleLoop");
  }
  ::llvm::StringRef getName() const override { return "TritonGPUTestPipelineScheduleLoop"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvidia_gpu::TritonNvidiaGPUDialect>();
    registry.insert<mlir::scf::SCFDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TritonGPUTestPipelineScheduleLoopBase<DerivedT>)

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
