/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.awt.FontMetrics;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.CompareConditionAdapter;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.n3.nanoxml.XMLElement;

public class PriorityCompareCondition
extends CompareConditionAdapter {
    static final String COMPARATION_RESULT = "COMPARATION_RESULT";
    static final String NAME = "priority_compare_condition";
    static final String SUCCEED = "SUCCEED";
    static final String VALUE = "VALUE";
    private static final IconStore STORE = IconStoreFactory.ICON_STORE;
    private final int comparationResult;
    private final boolean succeed;

    static ASelectableCondition load(XMLElement element) {
        return new PriorityCompareCondition(element.getAttribute(VALUE, null), Integer.parseInt(element.getAttribute(COMPARATION_RESULT, null)), TreeXmlReader.xmlToBoolean(element.getAttribute(SUCCEED, null)));
    }

    PriorityCompareCondition(String value, int comparationResult, boolean succeed) {
        super(value, false, false, false);
        this.comparationResult = comparationResult;
        this.succeed = succeed;
    }

    @Override
    public boolean isEqualityCondition() {
        return this.comparationResult == 0;
    }

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        Icon icon = STORE.getMindIcon(this.getIconName()).getIcon();
        return Collections.singletonList(icon);
    }

    @Override
    public boolean checkNode(NodeModel node) {
        Collection<NamedIcon> icons = IconController.getController().getIcons(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        for (NamedIcon icon : icons) {
            String iconName = icon.getName();
            if (iconName.length() != 6 || !iconName.startsWith("full-") || iconName.charAt(5) < '0' || iconName.charAt(5) > '9') continue;
            String prio = iconName.substring(5, 6);
            this.compareTo(prio);
            return this.isComparisonOK() && this.succeed == (this.getComparisonResult() == this.comparationResult);
        }
        return false;
    }

    @Override
    protected String createDescription() {
        String priorityCondition = TextUtils.getText("filter_priority");
        return super.createDescription(priorityCondition, this.comparationResult, this.succeed);
    }

    private String getIconName() {
        return "full-" + this.conditionValue().toString();
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(COMPARATION_RESULT, Integer.toString(this.comparationResult));
        child.setAttribute(SUCCEED, TreeXmlWriter.BooleanToXml(this.succeed));
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

