---
stage: GitLab Delivery
group: Operate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Other upgrade paths
description: Move between different editions or installation methods.
---

Not all upgrades are from one version of GitLab to another.
Other paths are available.

## Convert to Enterprise Edition

You can convert your GitLab Community Edition (CE) instance to a GitLab Enterprise Edition (EE) instance:

- [Convert the Linux package to EE](package.md)
- [Convert self-compiled to EE](self_compiled.md)
- [Convert Helm chart to EE](https://docs.gitlab.com/charts/installation/deployment.html#convert-community-edition-to-enterprise-edition)

If you need to return to Community Edition from Enterprise Edition:

- [Revert from EE to CE](revert.md)

## Convert a self-compiled instance to a Linux package

If you have a self-compiled GitLab instance and want to convert it to a Linux package:

- [Convert self-compiled to Linux](https://docs.gitlab.com/omnibus/update/convert_to_omnibus/)
