/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter performs anisotropic diffusion on a scalar itk::Image using the classic Perona-Malik, gradient magnitude based equation.


For detailed information on anisotropic diffusion, see
itkAnisotropicDiffusionFunction and
itkGradientNDAnisotropicDiffusionFunction.

Inputs and Outputs
The input to this filter should be a scalar itk::Image of any dimensionality. The output image will be a diffused copy of
the input.
Parameters
Please see the description of parameters given in
itkAnisotropicDiffusionImageFilter.

See:
 AnisotropicDiffusionImageFilter

 AnisotropicDiffusionFunction

 GradientAnisotropicDiffusionFunction

 itk::simple::GradientAnisotropicDiffusion for the procedural interface

 itk::GradientAnisotropicDiffusionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGradientAnisotropicDiffusionImageFilter.h
*/
public class GradientAnisotropicDiffusionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GradientAnisotropicDiffusionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GradientAnisotropicDiffusionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GradientAnisotropicDiffusionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GradientAnisotropicDiffusionImageFilter::~GradientAnisotropicDiffusionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GradientAnisotropicDiffusionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GradientAnisotropicDiffusionImageFilter::GradientAnisotropicDiffusionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GradientAnisotropicDiffusionImageFilter() {
    this(SimpleITKJNI.new_GradientAnisotropicDiffusionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GradientAnisotropicDiffusionImageFilter::SetTimeStep(double TimeStep)
*/
public  void setTimeStep(double TimeStep) {
    SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_setTimeStep(swigCPtr, this, TimeStep);
  }

  /**
double itk::simple::GradientAnisotropicDiffusionImageFilter::GetTimeStep() const
*/
public  double getTimeStep() {
    return SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_getTimeStep(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GradientAnisotropicDiffusionImageFilter::SetConductanceParameter(double ConductanceParameter)
*/
public  void setConductanceParameter(double ConductanceParameter) {
    SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_setConductanceParameter(swigCPtr, this, ConductanceParameter);
  }

  /**
double itk::simple::GradientAnisotropicDiffusionImageFilter::GetConductanceParameter() const
*/
public  double getConductanceParameter() {
    return SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_getConductanceParameter(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GradientAnisotropicDiffusionImageFilter::SetConductanceScalingUpdateInterval(unsigned int ConductanceScalingUpdateInterval)
*/
public  void setConductanceScalingUpdateInterval(long ConductanceScalingUpdateInterval) {
    SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_setConductanceScalingUpdateInterval(swigCPtr, this, ConductanceScalingUpdateInterval);
  }

  /**
unsigned int itk::simple::GradientAnisotropicDiffusionImageFilter::GetConductanceScalingUpdateInterval() const
*/
public  long getConductanceScalingUpdateInterval() {
    return SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_getConductanceScalingUpdateInterval(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GradientAnisotropicDiffusionImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::GradientAnisotropicDiffusionImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
std::string itk::simple::GradientAnisotropicDiffusionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GradientAnisotropicDiffusionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GradientAnisotropicDiffusionImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
double itk::simple::GradientAnisotropicDiffusionImageFilter::EstimateOptimalTimeStep(Image &amp;inImage)

This method autmatically sets the optimal timestep for an image given
its spacing.

*/
public  double estimateOptimalTimeStep(Image inImage) {
    return SimpleITKJNI.GradientAnisotropicDiffusionImageFilter_estimateOptimalTimeStep(swigCPtr, this, Image.getCPtr(inImage), inImage);
  }

}
