/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implements pixel-wise generic operation of two images, or of an image
and a constant.


This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.

The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.


See:
 BinaryGeneratorImagFilter

 UnaryFunctorImageFilter TernaryFunctorImageFilter

 itk::simple::Greater for the procedural interface

 itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGreaterImageFilter.h
*/
public class GreaterImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GreaterImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GreaterImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GreaterImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GreaterImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GreaterImageFilter::~GreaterImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GreaterImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GreaterImageFilter::GreaterImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GreaterImageFilter() {
    this(SimpleITKJNI.new_GreaterImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GreaterImageFilter::SetBackgroundValue(uint8_t BackgroundValue)

Set/Get the value used to mark the false pixels of the operator.

*/
public  void setBackgroundValue(short BackgroundValue) {
    SimpleITKJNI.GreaterImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
uint8_t itk::simple::GreaterImageFilter::GetBackgroundValue() const

Set/Get the value used to mark the false pixels of the operator.

*/
public  short getBackgroundValue() {
    return SimpleITKJNI.GreaterImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GreaterImageFilter::SetForegroundValue(uint8_t ForegroundValue)

Set/Get the value used to mark the true pixels of the operator.

*/
public  void setForegroundValue(short ForegroundValue) {
    SimpleITKJNI.GreaterImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
uint8_t itk::simple::GreaterImageFilter::GetForegroundValue() const

Set/Get the value used to mark the true pixels of the operator.

*/
public  short getForegroundValue() {
    return SimpleITKJNI.GreaterImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::GreaterImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GreaterImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GreaterImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GreaterImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GreaterImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.GreaterImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::GreaterImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, double constant) {
    return new Image(SimpleITKJNI.GreaterImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::GreaterImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(double constant, Image image2) {
    return new Image(SimpleITKJNI.GreaterImageFilter_execute__SWIG_2(swigCPtr, this, constant, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::GreaterImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, double constant, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.GreaterImageFilter_execute__SWIG_3(swigCPtr, this, Image.getCPtr(image1), image1, constant, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::GreaterImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(double constant, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.GreaterImageFilter_execute__SWIG_4(swigCPtr, this, constant, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

}
