/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.Objects;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.io.Content;

public class ContentSourceRequestContent
implements Request.Content {
    private final Content.Source source;
    private final String contentType;

    public ContentSourceRequestContent(Content.Source source) {
        this(source, "application/octet-stream");
    }

    public ContentSourceRequestContent(Content.Source source, String contentType) {
        this.source = Objects.requireNonNull(source);
        this.contentType = contentType;
    }

    public Content.Source getContentSource() {
        return this.source;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public long getLength() {
        return this.getContentSource().getLength();
    }

    public Content.Chunk read() {
        return this.getContentSource().read();
    }

    public void demand(Runnable demandCallback) {
        this.getContentSource().demand(demandCallback);
    }

    public void fail(Throwable failure) {
        this.fail(failure, true);
    }

    public void fail(Throwable failure, boolean last) {
        this.getContentSource().fail(failure, last);
    }

    public boolean rewind() {
        return this.getContentSource().rewind();
    }
}

