/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.RebalancingStatus;

@Scope(value=Scopes.GLOBAL)
public interface ClusterTopologyManager {
    public List<Address> currentJoiners(String var1);

    public CompletionStage<CacheStatusResponse> handleJoin(String var1, Address var2, CacheJoinInfo var3, int var4) throws Exception;

    public CompletionStage<Void> handleLeave(String var1, Address var2, int var3) throws Exception;

    public CompletionStage<Void> handleRebalancePhaseConfirm(String var1, Address var2, int var3, Throwable var4, int var5) throws Exception;

    public boolean isRebalancingEnabled();

    public boolean isRebalancingEnabled(String var1);

    public CompletionStage<Void> setRebalancingEnabled(boolean var1);

    public CompletionStage<Void> setRebalancingEnabled(String var1, boolean var2);

    public RebalancingStatus getRebalancingStatus(String var1);

    public CompletionStage<Void> forceRebalance(String var1);

    public CompletionStage<Void> forceAvailabilityMode(String var1, AvailabilityMode var2);

    public CompletionStage<Void> handleShutdownRequest(String var1) throws Exception;

    public boolean useCurrentTopologyAsStable(String var1, boolean var2);

    public void setInitialCacheTopologyId(String var1, int var2);

    public ClusterManagerStatus getStatus();

    public static enum ClusterManagerStatus {
        INITIALIZING,
        REGULAR_MEMBER,
        COORDINATOR,
        RECOVERING_CLUSTER,
        STOPPING;


        boolean isRunning() {
            return this != STOPPING;
        }

        boolean isCoordinator() {
            return this == COORDINATOR || this == RECOVERING_CLUSTER;
        }
    }
}

