
# Introduction

The Launch Instances module (`aws_launch_instances`) can be used to launch a
Cloud host running metasploit-aggregator (a proxy for Meterpreter sessions).

## TLDR

Shell #1:

```
> use auxiliary/admin/aws/aws_launch_instances
> set AccessKeyId ...
> set SecretAccessKey ...
> set SSH_PUB_KEY ssh-rsa ABCDEDG123...
> set SEC_GROUP_CIDR <MY IP ADDRESS>/32
> run
[*] Created security group: sg-abcdefg
[*] Launching instance(s) in us-west-2, AMI: ami-1e299d7e, key pair name: admin, security group: sg-abcdefg, subnet ID: subnet-hijklmn
[*] Launched instance i-12345678 in us-west-2 account 012345678900
[*] instance i-12345678 status: initializing
...
[*] instance i-12345678 status: ok
[*] Instance i-12345678 has IP address 35.12.4.1
[*] Auxiliary module execution completed
```

Shell #2:

```
ssh ec2-user@35.12.4.1 -L 2447:127.0.0.1:2447
```

Shell #1 again:

```
> load aggregator
> aggregator_connect 127.0.0.1:2447
```

For more information on metasploit-aggregator, see
https://github.com/rapid7/metasploit-aggregator


# Background

## AWS API Access Keys

API access keys can be used to make calls against the AWS API, to say
retrieve deployment packages from S3.

## VPC

The VPC or Virtual Private Cloud, an isolated local area network. Network access
can be made available by assigning an Internet routable IP address to a host or
routing traffic to it through an ELB (Elastic Load Balancer). In either case
security-groups are used to open access to network ranges and specific TPC/UDP
ports. Security-groups provide much of the functionality of traditional firewalls
and can be configured by specifying a protocol, a CIDR and a port. 

## How it Works

Although hosts can be launched using the
Web console or the CLI, launching a host in the Cloud requires a fair
amount of configuration; this module does its best to abstract configuration
requirements away from the user by auto detecting the VPC, subnets, creating
security groups, etc. It performs several tasks to launch a host with
a public IP address, these are as follow: 1) select a VPC, 2) select a subnet, 3)
create/select a security group, 4) create/select a key-pair, and 5) launch
a host.

The module will attempt to launch the host in the first VPC it finds in the
given region (`Region` option). Most of the time there is only one VPC per
account per region, however one might find multiple VPCs within the same region.
In this case, one may use the `VPC_ID` advanced option to specify the VPC to
use. Selecting a subnet is a bit more complicated. To have traffic routed
between us and the Cloud host, a public subnet (a subnet that is routable to an
Internet gateway) must be selected and the Cloud host must be associated with
an Internet routable IP address. The module dynamically finds which subnet to
launch the host in. It will use the first subnet it finds having the
`Auto-assign Public IP` option set, if no such subnet exists, then it will
select the first subnet having an Internet gateway. To circumvent this process,
the `SUBNET_ID` advanced option can be set. 

When launching a Cloud host at least one security group is required. There are
several advanced options for creating/selecting a security group. The
`SEC_GROUP_ID` option works much in the same way the `VPC_ID` option does.
That is, the module will create a security group unless the `SEC_GROUP_ID`
options is set. If the `SEC_GROUP_ID` option is not set, the module will attempt
to create a security group using the values specified in the `SEC_GROUP_CIDR`,
`SEC_GROUP_NAME`, and `SEC_GROUP_PORT` options as configuration. 

The `KEY_NAME` and `SSH_PUB_KEY` options are used in conjunction to select or
create a key-pair (a named SSH public key). Key-pairs are used to authenticate
to the host once it is running. The `KEY_NAME` defaults to admin while
`SSH_PUB_KEY` is optional. If the `SSH_PUB_KEY` is left unset, then the module
will not attempt to create a key-pair and will simply attempt to launch the
instance using an existing key-pair denoted by `KEY_NAME`. To set the
`SSH_PUB_KEY` option, a public SSH key must be provided as can be generated by
`ssh-keygen -y -f <private key filename>`. Once a key-pair is created/selected,
the module launches the host via the AWS API specifying that it should
associate a public IP address.

As part of launching the host it passes user-data (shell script) that installs
metasploit-aggregator and runs it in a screen session.

## Options

The Launch Instances module is an auxiliary module that can be loaded using the
use command. To run the module, only the `AccessKeyId`, `SecretAccessKey`, and
`KEY_NAME` options are required.

Basic Options:

* `AMI_ID`: The Amazon Machine Image (AMI) ID (region dependent)
* `RHOST`: the AWS EC2 Endpoint (ec2.us-west-2.amazonaws.com), may change this to something closer to you
* `Region`: The default region (us-west-2), must match endpoint
* `AccessKeyId`: AWS API access key
* `SecretAccessKey`: AWS API secret access key
* `Token`: AWS API session token, optional
* `KEY_NAME`: The SSH key to be used for ec2-user
* `SSH_PUB_KEY`: The public SSH key to be used for ec2-user, e.g., "ssh-rsa ABCDE..."
* `USERDATA_FILE`: The script that will be executed on start

Advanced Options:

* `INSTANCE_TYPE`: The instance type
* `MaxCount`: Maximum number of instances to launch
* `MinCount`: Minimum number of instances to launch
* `ROLE_NAME`: The instance profile/role name
* `RPORT:` AWS EC2 Endpoint TCP Port
* `SEC_GROUP_ID`: the EC2 security group to use
* `SEC_GROUP_CIDR`: the EC2 security group network access CIDR, defaults to 0.0.0.0/0
* `SEC_GROUP_NAME`: the EC2 security group name
* `SEC_GROUP_PORT`: the EC2 security group network access port, defaults to tcp:22
* `SUBNET_ID`: The public subnet to use
* `UserAgent`: The User-Agent header to use for all requests
* `VPC_ID`: The EC2 VPC ID

# Usage

The Launch Instances module is an auxiliary module that can be loaded using the
use command. To run the module, only the `AccessKeyId`, `SecretAccessKey`, and
`KEY_NAME` options are required.

```
msf > use auxiliary/admin/aws/aws_launch_instances
msf auxiliary(aws_launch_instances) > show options

Module options (auxiliary/admin/aws/aws_launch_instances):

   Name             Current Setting              Required  Description
   ----             ---------------              --------  -----------
   AMI_ID           ami-1e299d7e                 yes       The Amazon Machine Image (AMI) ID
   AccessKeyId                                   yes       AWS access key
   KEY_NAME         admin                        yes       The SSH key to be used for ec2-user
   Proxies                                       no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOST            ec2.us-west-2.amazonaws.com  yes       AWS region specific EC2 endpoint
   Region           us-west-2                    yes       The default region
   SSH_PUB_KEY                                   no        The public SSH key to be used for ec2-user, e.g., "ssh-rsa ABCDE..."
   SecretAccessKey                               yes       AWS secret key
   Token                                         no        AWS session token
   USERDATA_FILE                                 no        The script that will be executed on start

msf auxiliary(aws_launch_instances) > set SecretAccessKey asdfasd+asdfasdfasd...
SecretAccessKey => asdfasd+asdfasdfasd...
msf auxiliary(aws_launch_instances) > set AccessKeyId AKIAAKIAAKIAAKIAAKIAA
AccessKeyId => AKIAJH47PFECK3EVTBKA
msf auxiliary(aws_launch_instances) > set KEY_NAME ec2-user-key
KEY_NAME => ec2-user-key
msf auxiliary(aws_launch_instances) > set SSH_PUB_KEY ssh-rsa ABCDEDG123...
SSH_PUB_KEY => ssh-rsa ABCDEDG123...
msf auxiliary(aws_launch_instances) > run

[*] Created ec2-user-key (ab:cd:ef:12:34:56:78:90:ab:ac:ad:ab:a1:23:45:67)
[*] Created security group: sg-12345678
[*] Launching instance(s) in us-west-2, AMI: ami-1e299d7e, key pair name: ec2-user, security group: sg-12345678, subnet ID: subnet-abcdefgh
[*] Launched instance i-12345678 in us-west-2 account 123456789012
[*] instance i-12345678 status: initializing
[*] instance i-12345678 status: initializing
...
[*] instance i-12345678 status: ok
[*] Instance i-12345678 has IP address 54.186.158.6
[*] Auxiliary module execution completed 
```

When the host has passed its primary system checks, the IP address will be
displayed. We can use this IP address to SSH to the host. Please note that
most users will want to set the `SEC_GROUP_CIDR` option to restrict access to
our new Cloud host.

To SSH into the host, you must specify the SSH key, and ec2-user username, e.g.,

```
$ ssh -i ec2-user-key ec2-user@54.186.158.6 -L 2447:127.0.0.1:2447
The authenticity of host '54.186.158.6 (54.186.158.6)' can't be established.
ECDSA key fingerprint is SHA256:ePj6WtCeK...
Are you sure you want to continue connecting (yes/no)? yes
Warning: Permanently added '54.186.158.6' (ECDSA) to the list of known hosts.
       __|  __|_  )
       _|  (     /   Amazon Linux AMI
      ___|\___|___|
https://aws.amazon.com/amazon-linux-ami/2016.09-release-notes/
5 package(s) needed for security, out of 9 available
Run "sudo yum update" to apply all updates.
[ec2-user@ip-172-31-8-176 ~]$
```

Back in the Metasploit console you can now connect via aggregator:

```
msf auxiliary(aws_launch_instances) > load aggregator
msf auxiliary(aws_launch_instances) > aggregator_connect 127.0.0.1:2447
[*] Connecting to Aggregator instance at 127.0.0.1:2447...
msf auxiliary(aws_launch_instances) >
```