/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDbNodeRequest
extends BmcRequest<Void> {
    private String dbNodeId;

    public String getDbNodeId() {
        return this.dbNodeId;
    }

    public Builder toBuilder() {
        return new Builder().dbNodeId(this.dbNodeId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbNodeId=").append(String.valueOf(this.dbNodeId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDbNodeRequest)) {
            return false;
        }
        GetDbNodeRequest other = (GetDbNodeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbNodeId, other.dbNodeId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbNodeId == null ? 43 : this.dbNodeId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDbNodeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbNodeId = null;

        public Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbNodeRequest o) {
            this.dbNodeId(o.getDbNodeId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbNodeRequest build() {
            GetDbNodeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDbNodeRequest buildWithoutInvocationCallback() {
            GetDbNodeRequest request = new GetDbNodeRequest();
            request.dbNodeId = this.dbNodeId;
            return request;
        }
    }
}

