/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingWorker;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.ToggleImportantInfo;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class CatalogNode
extends BaseNode
implements PropertyChangeListener {
    private static final String ICONBASE = "org/netbeans/modules/db/resources/database.gif";
    private static final String FOLDER = "Catalog";
    private String name = "";
    private String htmlName = null;
    private final DatabaseConnection connection;
    private final MetadataElementHandle<Catalog> catalogHandle;
    private final ToggleImportantInfo toggleImportantInfo = new ToggleImportantInfo(Catalog.class);

    public static CatalogNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        CatalogNode node = new CatalogNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private CatalogNode(NodeDataLookup lookup, NodeProvider provider) {
        super(new ChildNodeFactory((Lookup)lookup), lookup, FOLDER, provider);
        this.connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
        this.catalogHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
        lookup.add(this.toggleImportantInfo);
    }

    @Override
    protected void initialize() {
        this.refreshMetaData();
        this.connection.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.connection));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("defaultCatalog")) {
            this.updateProperties();
        }
    }

    private void refreshMetaData() {
        final MetadataModel metaDataModel = this.connection.getMetadataModel();
        boolean connected = this.connection.isConnected();
        if (connected && metaDataModel != null) {
            new SwingWorker(this){
                final /* synthetic */ CatalogNode this$0;
                {
                    this.this$0 = this$0;
                }

                protected Object doInBackground() throws Exception {
                    try {
                        metaDataModel.runReadAction((Action)new Action<Metadata>(){

                            public void run(Metadata metaData) {
                                Catalog catalog = (Catalog)this$0.catalogHandle.resolve(metaData);
                                this$0.toggleImportantInfo.setDefault(catalog.isDefault());
                                this$0.toggleImportantInfo.setImportant(this$0.connection.isImportantCatalog(this$0.name));
                                this$0.renderNames(catalog);
                            }
                        });
                        return null;
                    }
                    catch (MetadataModelException e) {
                        NodeRegistry.handleMetadataModelException(this.getClass(), this.this$0.connection, e, true);
                        return null;
                    }
                }
            }.run();
        }
    }

    @Override
    protected void updateProperties() {
        this.refreshMetaData();
        super.updateProperties();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getHtmlDisplayName() {
        return this.htmlName;
    }

    private void renderNames(Catalog catalog) {
        if (catalog == null) {
            this.name = "";
        } else {
            this.name = catalog.getName();
            if (this.name == null) {
                this.name = "Default";
            }
        }
        if (catalog != null) {
            String def = this.connection.getDefaultCatalog();
            boolean isDefault = def != null ? def.equals(this.name) : catalog.isDefault();
            this.htmlName = isDefault ? "<b>" + this.name + "</b>" : null;
        }
    }

    @Override
    public String getIconBase() {
        return ICONBASE;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(CatalogNode.class, (String)"ND_Catalog");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CatalogNode.class);
    }
}

