/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpFieldHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpFieldsTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityAndSessionHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.FinderMethodsTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.PropertyChangeSource;
import org.netbeans.modules.j2ee.ddloaders.multiview.QueryMethodHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.SelectMethodsTableModel;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;

public class EntityHelper
extends EntityAndSessionHelper {
    private final Entity entity;
    public final CmpFields cmpFields;
    public final Queries queries;
    private EntityMethodController entityMethodController;

    public EntityHelper(EjbJarMultiViewDataObject ejbJarMultiViewDataObject, Entity entity) {
        super(ejbJarMultiViewDataObject, (EntityAndSession)entity);
        this.entity = (Entity)this.ejb;
        this.cmpFields = new CmpFields();
        this.queries = new Queries();
        this.entityMethodController = null;
        this.abstractMethodController = this.entityMethodController;
    }

    public void removeQuery(Query query) {
        this.entity.removeQuery(query);
        this.modelUpdatedFromUI();
    }

    public boolean hasLocalInterface() {
        return this.ejb.getLocal() != null;
    }

    public boolean hasRemoteInterface() {
        return this.ejb.getRemote() != null;
    }

    public String getPrimkeyField() {
        return this.entity.getPrimkeyField();
    }

    public String getPrimKeyClass() {
        return this.entity.getPrimKeyClass();
    }

    public void setPrimkeyFieldName(String fieldName) {
        this.entity.setPrimkeyField(fieldName);
    }

    public void setPrimkeyField(String fieldName) throws ClassNotFoundException {
        this.setPrimkeyFieldName(fieldName);
        this.modelUpdatedFromUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (this.queries == null) {
            return;
        }
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (source == this.entity) {
            if (oldValue instanceof CmpField || newValue instanceof CmpField) {
                this.cmpFields.change(source, propertyName, oldValue, newValue);
            } else if (oldValue instanceof Query || newValue instanceof Query) {
                this.queries.change(source, propertyName, oldValue, newValue);
            }
        } else if (source instanceof CmpField) {
            this.cmpFields.change(source, propertyName, oldValue, newValue);
        } else if (source instanceof Query) {
            this.queries.change(source, propertyName, oldValue, newValue);
        }
    }

    public EntityMethodController getEntityMethodController() {
        return this.entityMethodController;
    }

    public void updateFieldAccessor(String fieldName, boolean getter, boolean local, boolean shouldExist) {
        if (local && this.hasLocalInterface() || !local && this.hasRemoteInterface()) {
            this.entityMethodController.updateFieldAccessor(fieldName, getter, local, shouldExist);
        }
    }

    public class CmpFields
    implements PropertyChangeSource {
        private List<PropertyChangeListener> listeners = new LinkedList<PropertyChangeListener>();
        private Map<CmpField, CmpFieldHelper> cmpFieldHelperMap = new HashMap<CmpField, CmpFieldHelper>();
        private CmpFieldsTableModel cmpFieldsTableModel = new CmpFieldsTableModel(this);

        public int getCmpFieldCount() {
            return EntityHelper.this.entity.getCmpField().length;
        }

        public CmpFieldHelper getCmpFieldHelper(int row) {
            CmpField field = this.getCmpField(row);
            CmpFieldHelper cmpFieldHelper = this.cmpFieldHelperMap.get(field);
            if (cmpFieldHelper == null) {
                cmpFieldHelper = this.createCmpFieldHelper(field);
            }
            return cmpFieldHelper;
        }

        private CmpFieldHelper getCmpFieldHelper(String fieldName) {
            CmpFieldHelper cmpFieldHelper = this.cmpFieldHelperMap.get(fieldName);
            if (cmpFieldHelper == null) {
                CmpField[] cmpFields = EntityHelper.this.entity.getCmpField();
                for (int i = 0; i < cmpFields.length; ++i) {
                    CmpField field = cmpFields[i];
                    if (!fieldName.equals(field.getFieldName())) continue;
                    cmpFieldHelper = this.createCmpFieldHelper(field);
                }
            }
            return cmpFieldHelper;
        }

        private CmpFieldHelper createCmpFieldHelper(CmpField field) {
            CmpFieldHelper cmpFieldHelper = new CmpFieldHelper(EntityHelper.this, field);
            this.cmpFieldHelperMap.put(field, cmpFieldHelper);
            return cmpFieldHelper;
        }

        private CmpField getCmpField(int row) {
            return this.getCmpFields()[row];
        }

        public CmpField[] getCmpFields() {
            CmpField[] cmpFields = EntityHelper.this.entity.getCmpField();
            Arrays.sort(cmpFields, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = ((CmpField)o1).getFieldName();
                    String s2 = ((CmpField)o2).getFieldName();
                    if (s1 == null) {
                        s1 = "";
                    }
                    if (s2 == null) {
                        s2 = "";
                    }
                    return s1.compareTo(s2);
                }
            });
            return cmpFields;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.remove(listener);
        }

        public void change(Object source, String propertyName, Object oldValue, Object newValue) {
            if (source instanceof Entity) {
                this.cmpFieldHelperMap.keySet().retainAll(Arrays.asList(EntityHelper.this.entity.getCmpField()));
            }
            this.firePropertyChange(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
        }

        protected void firePropertyChange(PropertyChangeEvent evt) {
            Iterator<PropertyChangeListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().propertyChange(evt);
            }
        }

        public void addCmpField() {
            EntityHelper.this.modelUpdatedFromUI();
        }

        public CmpFieldsTableModel getCmpFieldsTableModel() {
            return this.cmpFieldsTableModel;
        }

        public int getFieldRow(CmpField cmpField) {
            CmpField[] fields = this.getCmpFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equals((Object)cmpField)) continue;
                return i;
            }
            return -1;
        }
    }

    public class Queries
    implements PropertyChangeSource {
        private List<PropertyChangeListener> listeners = new LinkedList<PropertyChangeListener>();
        private Map<Query, QueryMethodHelper> queryMethodHelperMap = new HashMap<Query, QueryMethodHelper>();
        private Query[] selectMethods;
        private Query[] finderMethods;
        public static final String SELECT_PREFIX = "ejbSelect";
        public static final String FIND_PREFIX = "find";
        private FinderMethodsTableModel finderMethodsTableModel = new FinderMethodsTableModel(this);
        private SelectMethodsTableModel selectMethodsTableModel = new SelectMethodsTableModel(this);

        public Queries() {
            this.initQueryMethods();
        }

        private void initQueryMethods() {
            this.selectMethods = this.getQueries(SELECT_PREFIX);
            this.finderMethods = this.getQueries(FIND_PREFIX);
        }

        public QueryMethodHelper getQueryMethodHelper(Query query) {
            return null;
        }

        public QueryMethodHelper getFinderMethodHelper(int row) {
            return this.getQueryMethodHelper(this.finderMethods[row]);
        }

        public QueryMethodHelper getSelectMethodHelper(int row) {
            return this.getQueryMethodHelper(this.selectMethods[row]);
        }

        private Query[] getQueries(String s) {
            LinkedList<Query> list = new LinkedList<Query>();
            Query[] queries = EntityHelper.this.entity.getQuery();
            for (int i = 0; i < queries.length; ++i) {
                Query query = queries[i];
                if (!query.getQueryMethod().getMethodName().startsWith(s)) continue;
                list.add(query);
                QueryMethodHelper helper = this.queryMethodHelperMap.get(query);
                if (helper == null) continue;
                helper.init();
            }
            return list.toArray(new Query[0]);
        }

        public int getFinderMethodCount() {
            return this.finderMethods.length;
        }

        public int getSelectMethodCount() {
            return this.selectMethods.length;
        }

        public Query getFinderMethod(int rowIndex) {
            return this.finderMethods[rowIndex];
        }

        public Query getSelecMethod(int rowIndex) {
            return this.selectMethods[rowIndex];
        }

        public void change(Object source, String propertyName, Object oldValue, Object newValue) {
            this.initQueryMethods();
            this.queryMethodHelperMap.keySet().retainAll(Arrays.asList(EntityHelper.this.entity.getQuery()));
            this.firePropertyChange(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
        }

        public Query[] getQuery() {
            return EntityHelper.this.entity.getQuery();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.remove(listener);
        }

        protected void firePropertyChange(PropertyChangeEvent evt) {
            Iterator<PropertyChangeListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().propertyChange(evt);
            }
        }

        public String getLocal() {
            return EntityHelper.this.getLocal();
        }

        public String getRemote() {
            return EntityHelper.this.getRemote();
        }

        public FinderMethodsTableModel getFinderMethodsTableModel() {
            return this.finderMethodsTableModel;
        }

        public SelectMethodsTableModel getSelectMethodsTableModel() {
            return this.selectMethodsTableModel;
        }

        public int getSelectMethodRow(Query query) {
            for (int i = 0; i < this.selectMethods.length; ++i) {
                if (!query.equals((Object)this.selectMethods[i])) continue;
                return i;
            }
            return -1;
        }

        public int getFinderMethodRow(Query query) {
            for (int i = 0; i < this.finderMethods.length; ++i) {
                if (!query.equals((Object)this.finderMethods[i])) continue;
                return i;
            }
            return -1;
        }
    }
}

