/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.updatecenters.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.autoupdate.AutoupdateClusterCreator;
import org.openide.util.Utilities;

public final class NetBeansClusterCreator
extends AutoupdateClusterCreator {
    protected File findCluster(String clusterName) {
        AtomicReference<File> parent = new AtomicReference<File>();
        File conf = NetBeansClusterCreator.findConf(parent, new ArrayList());
        return conf != null && conf.isFile() && NetBeansClusterCreator.canWrite(conf) ? new File(parent.get(), clusterName) : null;
    }

    private static File findConf(AtomicReference<File> parent, List<? super File> clusters) {
        String nbdirs = System.getProperty("netbeans.dirs");
        if (nbdirs != null) {
            StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
            while (tok.hasMoreElements()) {
                File cluster = new File(tok.nextToken());
                clusters.add(cluster);
                if (!cluster.exists()) continue;
                if (parent.get() == null) {
                    parent.set(cluster.getParentFile());
                }
                if (parent.get().equals(cluster.getParentFile())) continue;
                return null;
            }
        }
        return new File(new File(parent.get(), "etc"), "netbeans.clusters");
    }

    protected File[] registerCluster(String clusterName, File cluster) throws IOException {
        AtomicReference<File> parent = new AtomicReference<File>();
        ArrayList<File> clusters = new ArrayList<File>();
        File conf = NetBeansClusterCreator.findConf(parent, clusters);
        assert (conf != null);
        clusters.add(cluster);
        Properties p = new Properties();
        try (FileInputStream is = new FileInputStream(conf);){
            p.load(is);
        }
        if (!p.containsKey(clusterName)) {
            try (FileOutputStream os = new FileOutputStream(conf, true);){
                ((OutputStream)os).write(10);
                ((OutputStream)os).write(clusterName.getBytes());
                ((OutputStream)os).write(10);
            }
        }
        return clusters.toArray(new File[0]);
    }

    public static boolean canWrite(File f) {
        if (Utilities.isWindows()) {
            boolean bl;
            FileWriter fw = new FileWriter(f, true);
            try {
                Logger.getLogger(NetBeansClusterCreator.class.getName()).log(Level.FINE, "{0} has write permission", f);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    Logger.getLogger(NetBeansClusterCreator.class.getName()).log(Level.FINE, f + " has no write permission", ioe);
                    return false;
                }
            }
            fw.close();
            return bl;
        }
        return f.canWrite();
    }
}

