/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.debugger.ui.actions.GestureSubmitter;
import org.netbeans.spi.debugger.ui.AttachType;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.PersistentController;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.netbeans.spi.project.ui.support.MainProjectSensitiveActions;
import org.openide.awt.Actions;
import org.openide.awt.DropDownButtonFactory;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.Presenter;

public class DebugMainProjectAction
implements Action,
Presenter.Toolbar,
PopupMenuListener {
    private static WeakSet<AttachHistorySupport> ahs = null;
    private final Action delegate = MainProjectSensitiveActions.mainProjectCommandAction((String)"debug", (String)NbBundle.getMessage(DebugMainProjectAction.class, (String)"LBL_DebugMainProjectAction_Name"), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/debugProject.png", (boolean)false));
    private final DebugHistorySupport debugHistorySupport;
    private final AttachHistorySupport attachHistorySupport;
    private boolean menuInitialized;

    public DebugMainProjectAction() {
        this.delegate.putValue("iconBase", "org/netbeans/modules/debugger/resources/debugProject.png");
        this.debugHistorySupport = new DebugHistorySupport();
        this.attachHistorySupport = new AttachHistorySupport();
    }

    @Override
    public Object getValue(String arg0) {
        return this.delegate.getValue(arg0);
    }

    @Override
    public void putValue(String arg0, Object arg1) {
        this.delegate.putValue(arg0, arg1);
    }

    @Override
    public void setEnabled(boolean arg0) {
        this.delegate.setEnabled(arg0);
    }

    @Override
    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener arg0) {
        this.delegate.addPropertyChangeListener(arg0);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener arg0) {
        this.delegate.removePropertyChangeListener(arg0);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Project p = OpenProjects.getDefault().getMainProject();
        GestureSubmitter.logDebugProject(p);
        this.delegate.actionPerformed(arg0);
    }

    public Component getToolbarPresenter() {
        JPopupMenu menu = new JPopupMenu();
        JButton button = DropDownButtonFactory.createDropDownButton((Icon)new ImageIcon(new BufferedImage(16, 16, 2)), (JPopupMenu)menu);
        final JMenuItem item = new JMenuItem(Actions.cutAmpersand((String)((String)this.delegate.getValue("menuText"))));
        item.setEnabled(this.delegate.isEnabled());
        this.delegate.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ DebugMainProjectAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("enabled".equals(propName)) {
                    item.setEnabled((Boolean)evt.getNewValue());
                } else if ("menuText".equals(propName)) {
                    item.setText(Actions.cutAmpersand((String)((String)evt.getNewValue())));
                } else if ("selectedProjects".equals(propName)) {
                    Project[] projects = (Project[])evt.getNewValue();
                    if (projects.length == 1) {
                        this.this$0.debugHistorySupport.setSelectedProject(projects[0].getProjectDirectory());
                    } else {
                        this.this$0.debugHistorySupport.setSelectedProject(null);
                    }
                }
            }
        });
        menu.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugMainProjectAction.this.actionPerformed(e);
            }
        });
        try {
            Action ca = Actions.forID((String)"Debug", (String)"org.netbeans.modules.debugger.ui.actions.ConnectAction");
            JMenuItem item2 = new JMenuItem(Actions.cutAmpersand((String)((String)ca.getValue("Name"))));
            Actions.connect((AbstractButton)item2, (Action)ca);
            menu.add(item2);
        }
        catch (Exception nsee) {
            Exceptions.printStackTrace((Throwable)nsee);
        }
        menu.addPopupMenuListener(this);
        Actions.connect((AbstractButton)button, (Action)this);
        return button;
    }

    static synchronized void attachHistoryChanged() {
        if (ahs == null) {
            return;
        }
        for (AttachHistorySupport support : ahs) {
            support.computeItems();
        }
    }

    private static synchronized void addAttachHistorySupport(AttachHistorySupport support) {
        if (ahs == null) {
            ahs = new WeakSet();
        }
        ahs.add((Object)support);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        if (!this.menuInitialized) {
            JPopupMenu menu = (JPopupMenu)e.getSource();
            this.debugHistorySupport.init(menu);
            this.attachHistorySupport.init(menu);
            this.menuInitialized = true;
        } else {
            this.debugHistorySupport.refreshItems();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    static class AttachHistorySupport
    implements ActionListener {
        private JPopupMenu menu;
        private JMenuItem[] items = new JMenuItem[0];
        private JSeparator separator = new JPopupMenu.Separator();
        private static final RequestProcessor RP = new RequestProcessor(AttachHistorySupport.class.getName());

        AttachHistorySupport() {
        }

        public void init(JPopupMenu menu) {
            this.menu = menu;
            DebugMainProjectAction.addAttachHistorySupport(this);
            this.computeItems();
        }

        public void computeItems() {
            this.menu.remove(this.separator);
            for (int x = 0; x < this.items.length; ++x) {
                this.menu.remove(this.items[x]);
            }
            Properties props = Properties.getDefault().getProperties("debugger").getProperties("last_attaches");
            Integer[] usedSlots = (Integer[])props.getArray("used_slots", (Object[])new Integer[0]);
            if (usedSlots.length > 0) {
                this.menu.add(this.separator);
            }
            this.items = new JMenuItem[usedSlots.length];
            for (int x = 0; x < usedSlots.length; ++x) {
                String dispName = props.getProperties("slot_" + usedSlots[x]).getString("display_name", "<???>");
                this.items[x] = new JMenuItem(dispName);
                this.items[x].addActionListener(this);
                this.menu.add(this.items[x]);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            int index = -1;
            for (int x = 0; x < this.items.length; ++x) {
                if (this.items[x] != item) continue;
                index = x;
                break;
            }
            if (index == -1) {
                return;
            }
            final int findex = index;
            RP.post(new Runnable(){
                final /* synthetic */ AttachHistorySupport this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.perform(findex);
                }
            });
        }

        private void perform(int index) {
            Properties props = Properties.getDefault().getProperties("debugger").getProperties("last_attaches");
            Integer[] usedSlots = (Integer[])props.getArray("used_slots", (Object[])new Integer[0]);
            String attachTypeName = props.getProperties("slot_" + usedSlots[index]).getString("attach_type", "???");
            List types = DebuggerManager.getDebuggerManager().lookup(null, AttachType.class);
            AttachType att = null;
            for (Object t : types) {
                AttachType at = (AttachType)t;
                if (!attachTypeName.equals(at.getTypeDisplayName())) continue;
                att = at;
                break;
            }
            if (att != null) {
                final AttachType attachType = att;
                final PersistentController[] controllerPtr = new PersistentController[]{null};
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){
                        final /* synthetic */ AttachHistorySupport this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            JComponent customizer = attachType.getCustomizer();
                            Controller controller = attachType.getController();
                            if (controller == null && customizer instanceof Controller) {
                                Exceptions.printStackTrace((Throwable)new IllegalStateException("FIXME: JComponent " + customizer + " must not implement Controller interface!"));
                                controller = (Controller)((Object)customizer);
                            }
                            if (controller instanceof PersistentController) {
                                controllerPtr[0] = (PersistentController)controller;
                            }
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
                final PersistentController controller = controllerPtr[0];
                if (controller == null) {
                    return;
                }
                boolean result = controller.load(props.getProperties("slot_" + usedSlots[index]).getProperties("values"));
                if (!result) {
                    return;
                }
                final boolean[] passedPtr = new boolean[]{false};
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){
                        final /* synthetic */ AttachHistorySupport this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            passedPtr[0] = controller.ok();
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
                if (passedPtr[0]) {
                    this.makeFirst(index);
                    GestureSubmitter.logAttach(attachTypeName);
                }
            } else {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DebugMainProjectAction.class, (String)"CTL_Attach_Type_Not_Found"));
            }
        }

        private void makeFirst(int index) {
            if (index == 0) {
                return;
            }
            Properties props = Properties.getDefault().getProperties("debugger").getProperties("last_attaches");
            Object[] usedSlots = (Integer[])props.getArray("used_slots", (Object[])new Integer[0]);
            int temp = usedSlots[index];
            for (int x = index; x > 0; --x) {
                usedSlots[x] = usedSlots[x - 1];
            }
            usedSlots[0] = temp;
            props.setArray("used_slots", usedSlots);
            DebugMainProjectAction.attachHistoryChanged();
        }
    }

    private static class DebugHistorySupport
    implements ActionListener,
    ChangeListener {
        private JPopupMenu menu;
        private JMenuItem[] items = new JMenuItem[0];
        private final JSeparator separator1 = new JPopupMenu.Separator();
        private final JSeparator separator2 = new JPopupMenu.Separator();
        private final BuildExecutionSupportChangeSupport besc;
        private final OpenProjectsListener opl;
        private final LinkedList<DebugActionItem> debugItems = new LinkedList();
        private volatile FileObject selectedProjectRoot;
        private static final int MAX_ITEMS_COUNT = 7;
        private static final String DEBUG_ACTION_ITEM_PROP_NAME = "debug action item";
        private static final RequestProcessor RP = new RequestProcessor(DebugHistorySupport.class.getName());

        public DebugHistorySupport() {
            this.besc = new BuildExecutionSupportChangeSupport();
            this.besc.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.besc));
            this.opl = new OpenProjectsListener();
            OpenProjects.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.opl, (Object)OpenProjects.getDefault()));
        }

        void init(JPopupMenu menu) {
            this.menu = menu;
            this.computeItems();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeItems() {
            if (this.menu == null) {
                return;
            }
            boolean wasSeparator = this.items.length > 0;
            for (int i = 0; i < this.items.length; ++i) {
                this.menu.remove(this.items[i]);
            }
            LinkedList<DebugActionItem> i = this.debugItems;
            synchronized (i) {
                if (this.debugItems.isEmpty()) {
                    this.items = new JMenuItem[0];
                } else {
                    int n = this.debugItems.size();
                    this.items = new JMenuItem[n];
                    int j = 0;
                    for (int i2 = 0; i2 < n; ++i2) {
                        DebugActionItem dai = this.debugItems.get(i2);
                        String dispName = dai.getDisplayName();
                        if (Objects.equals(this.selectedProjectRoot, dai.getRoot())) continue;
                        this.items[j] = new JMenuItem(dispName);
                        this.items[j].putClientProperty(DEBUG_ACTION_ITEM_PROP_NAME, dai.getActionItem());
                        this.items[j].addActionListener(this);
                        ++j;
                    }
                    if (j < this.items.length) {
                        this.items = Arrays.copyOf(this.items, j);
                    }
                }
            }
            if (this.items.length == 0) {
                if (wasSeparator) {
                    this.menu.remove(this.separator1);
                    this.menu.remove(this.separator2);
                }
            } else {
                int i3;
                if (!wasSeparator) {
                    this.menu.insert(this.separator1, 1);
                }
                for (i3 = 0; i3 < this.items.length; ++i3) {
                    this.menu.insert(this.items[i3], i3 + 2);
                }
                this.menu.insert(this.separator2, i3 + 2);
            }
        }

        private void refreshItems() {
            this.computeItems();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            final BuildExecutionSupport.ActionItem ai = (BuildExecutionSupport.ActionItem)item.getClientProperty(DEBUG_ACTION_ITEM_PROP_NAME);
            RP.post(new Runnable(){
                final /* synthetic */ DebugHistorySupport this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    ai.repeatExecution();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            BuildExecutionSupport.ActionItem ai;
            String action;
            BuildExecutionSupport.Item lastItem = BuildExecutionSupport.getLastFinishedItem();
            if (lastItem instanceof BuildExecutionSupport.ActionItem && "debug".equals(action = (ai = (BuildExecutionSupport.ActionItem)lastItem).getAction())) {
                boolean changed = false;
                LinkedList<DebugActionItem> linkedList = this.debugItems;
                synchronized (linkedList) {
                    if (this.debugItems.isEmpty() || ai != this.debugItems.getFirst().getActionItem()) {
                        DebugActionItem dai = new DebugActionItem(ai);
                        this.debugItems.remove(dai);
                        this.debugItems.addFirst(dai);
                        if (this.debugItems.size() > 7) {
                            this.debugItems.removeLast();
                        }
                        changed = true;
                    }
                }
                if (changed) {
                    // empty if block
                }
            }
        }

        private void setSelectedProject(FileObject projectDirectory) {
            this.selectedProjectRoot = projectDirectory;
        }

        private final class OpenProjectsListener
        implements PropertyChangeListener {
            private OpenProjectsListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("openProjects")) {
                    Project[] opened = (Project[])evt.getNewValue();
                    HashSet<FileObject> openRoots = new HashSet<FileObject>();
                    for (Project p : opened) {
                        if (p == null) continue;
                        openRoots.add(p.getProjectDirectory());
                    }
                    LinkedList linkedList = DebugHistorySupport.this.debugItems;
                    synchronized (linkedList) {
                        int n = DebugHistorySupport.this.debugItems.size();
                        for (int i = 0; i < n; ++i) {
                            FileObject root = ((DebugActionItem)DebugHistorySupport.this.debugItems.get(i)).getRoot();
                            if (root == null || openRoots.contains(root)) continue;
                            DebugHistorySupport.this.debugItems.remove(i--);
                            --n;
                        }
                    }
                }
            }
        }

        private static final class DebugActionItem {
            private final BuildExecutionSupport.ActionItem ai;
            private final FileObject prjRoot;

            DebugActionItem(BuildExecutionSupport.ActionItem ai) {
                this.ai = ai;
                this.prjRoot = ai.getProjectDirectory();
            }

            FileObject getRoot() {
                return this.prjRoot;
            }

            String getDisplayName() {
                return this.ai.getDisplayName();
            }

            BuildExecutionSupport.ActionItem getActionItem() {
                return this.ai;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof DebugActionItem)) {
                    return false;
                }
                DebugActionItem dai = (DebugActionItem)obj;
                return Objects.equals(this.prjRoot, dai.prjRoot) && Objects.equals(this.getDisplayName(), dai.getDisplayName());
            }

            public int hashCode() {
                return Objects.hash(this.prjRoot);
            }
        }
    }

    private static class BuildExecutionSupportChangeSupport {
        private BuildExecutionSupportChangeSupport() {
        }

        public void addChangeListener(ChangeListener listener) {
            BuildExecutionSupport.addChangeListener((ChangeListener)listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            BuildExecutionSupport.removeChangeListener((ChangeListener)listener);
        }
    }
}

