/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.osmand.PlatformUtil;
import net.osmand.StringMatcher;
import net.osmand.data.Amenity;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiFilter;
import net.osmand.osm.PoiType;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MapPoiTypes {
    private static MapPoiTypes DEFAULT_INSTANCE = null;
    private static final Log log = PlatformUtil.getLog(MapRenderingTypes.class);
    private String resourceName;
    private List<PoiCategory> categories = new ArrayList<PoiCategory>();
    private PoiCategory otherCategory;
    private PoiCategory otherMapCategory;
    static final String OSM_WIKI_CATEGORY = "osmwiki";
    private PoiTranslator poiTranslator = null;
    private boolean init;
    Map<String, PoiType> poiTypesByTag = new LinkedHashMap<String, PoiType>();

    public MapPoiTypes(String fileName) {
        this.resourceName = fileName;
    }

    public static MapPoiTypes getDefaultNoInit() {
        if (DEFAULT_INSTANCE == null) {
            DEFAULT_INSTANCE = new MapPoiTypes(null);
        }
        return DEFAULT_INSTANCE;
    }

    public static void setDefault(MapPoiTypes types) {
        DEFAULT_INSTANCE = types;
        DEFAULT_INSTANCE.init();
    }

    public static MapPoiTypes getDefault() {
        if (DEFAULT_INSTANCE == null) {
            DEFAULT_INSTANCE = new MapPoiTypes(null);
            DEFAULT_INSTANCE.init();
        }
        return DEFAULT_INSTANCE;
    }

    public boolean isInit() {
        return this.init;
    }

    public PoiCategory getOtherPoiCategory() {
        return this.otherCategory;
    }

    public PoiCategory getOtherMapCategory() {
        if (this.otherMapCategory == null) {
            this.otherMapCategory = this.getPoiCategoryByName("Other", true);
        }
        return this.otherMapCategory;
    }

    public List<PoiFilter> getTopVisibleFilters() {
        ArrayList<PoiFilter> lf = new ArrayList<PoiFilter>();
        for (PoiCategory pc : this.categories) {
            if (pc.isTopVisible()) {
                lf.add(pc);
            }
            for (PoiFilter p : pc.getPoiFilters()) {
                if (!p.isTopVisible()) continue;
                lf.add(p);
            }
        }
        this.sortList(lf);
        return lf;
    }

    private void sortList(List<? extends PoiFilter> lf) {
        final Collator instance = Collator.getInstance();
        Collections.sort(lf, new Comparator<PoiFilter>(){

            @Override
            public int compare(PoiFilter object1, PoiFilter object2) {
                return instance.compare(object1.getTranslation(), object2.getTranslation());
            }
        });
    }

    public PoiCategory getUserDefinedCategory() {
        return this.otherCategory;
    }

    public PoiType getPoiTypeByKey(String name) {
        for (PoiCategory pc : this.categories) {
            PoiType pt = pc.getPoiTypeByKeyName(name);
            if (pt == null || pt.isReference()) continue;
            return pt;
        }
        return null;
    }

    public AbstractPoiType getAnyPoiTypeByKey(String name) {
        for (PoiCategory pc : this.categories) {
            if (pc.getKeyName().equals(name)) {
                return pc;
            }
            for (PoiFilter pf : pc.getPoiFilters()) {
                if (!pf.getKeyName().equals(name)) continue;
                return pf;
            }
            PoiType pt = pc.getPoiTypeByKeyName(name);
            if (pt == null || pt.isReference()) continue;
            return pt;
        }
        return null;
    }

    public Map<String, PoiType> getAllTranslatedNames(boolean skipNonEditable) {
        HashMap<String, PoiType> translation = new HashMap<String, PoiType>();
        for (PoiCategory pc : this.categories) {
            if (skipNonEditable && pc.isNotEditableOsm()) continue;
            for (PoiType pt : pc.getPoiTypes()) {
                if (pt.isReference() || pt.getBaseLangType() != null || skipNonEditable && pt.isNotEditableOsm()) continue;
                translation.put(pt.getKeyName().replace('_', ' ').toLowerCase(), pt);
                translation.put(pt.getTranslation().toLowerCase(), pt);
            }
        }
        return translation;
    }

    public List<AbstractPoiType> getAllTypesTranslatedNames(StringMatcher matcher) {
        ArrayList<AbstractPoiType> tm = new ArrayList<AbstractPoiType>();
        for (PoiCategory pc : this.categories) {
            if (pc == this.otherMapCategory) continue;
            this.addIf(tm, pc, matcher);
            for (PoiFilter poiFilter : pc.getPoiFilters()) {
                this.addIf(tm, poiFilter, matcher);
            }
            for (PoiType poiType : pc.getPoiTypes()) {
                if (poiType.isReference()) continue;
                this.addIf(tm, poiType, matcher);
            }
        }
        return tm;
    }

    private void addIf(List<AbstractPoiType> tm, AbstractPoiType pc, StringMatcher matcher) {
        List<PoiType> additionals;
        if (matcher.matches(pc.getTranslation()) || matcher.matches(pc.getKeyName().replace('_', ' '))) {
            tm.add(pc);
        }
        if ((additionals = pc.getPoiAdditionals()) != null) {
            for (PoiType a : additionals) {
                this.addIf(tm, a, matcher);
            }
        }
    }

    public Map<String, PoiType> getAllTranslatedNames(PoiCategory pc, boolean onlyTranslation) {
        TreeMap<String, PoiType> translation = new TreeMap<String, PoiType>();
        for (PoiType pt : pc.getPoiTypes()) {
            translation.put(pt.getTranslation(), pt);
            if (onlyTranslation) continue;
            translation.put(Algorithms.capitalizeFirstLetterAndLowercase(pt.getKeyName().replace('_', ' ')), pt);
        }
        return translation;
    }

    public PoiCategory getPoiCategoryByName(String name) {
        return this.getPoiCategoryByName(name, false);
    }

    public PoiCategory getPoiCategoryByName(String name, boolean create) {
        if (name.equals("leisure") && !create) {
            name = "entertainment";
        }
        if (name.equals("historic") && !create) {
            name = "tourism";
        }
        for (PoiCategory p : this.categories) {
            if (!p.getKeyName().equalsIgnoreCase(name)) continue;
            return p;
        }
        if (create) {
            PoiCategory lastCategory = new PoiCategory(this, name, this.categories.size());
            this.categories.add(lastCategory);
            return lastCategory;
        }
        return this.otherCategory;
    }

    public PoiTranslator getPoiTranslator() {
        return this.poiTranslator;
    }

    public void setPoiTranslator(PoiTranslator poiTranslator) {
        this.poiTranslator = poiTranslator;
        this.sortList(this.categories);
    }

    public void init() {
        this.init(null);
    }

    public void init(String resourceName) {
        long time = System.currentTimeMillis();
        ArrayList<AbstractPoiType> referenceTypes = new ArrayList<AbstractPoiType>();
        LinkedHashMap<String, PoiType> allTypes = new LinkedHashMap<String, PoiType>();
        if (resourceName != null) {
            this.resourceName = resourceName;
        }
        try {
            int n;
            InputStream is = this.resourceName == null ? OsmWindow.getInstance().getResource("net/osmand/osm/poi_types.xml") : new FileInputStream(this.resourceName);
            time = System.currentTimeMillis();
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput(is, "UTF-8");
            PoiCategory lastCategory = null;
            AbstractPoiType lastFilter = null;
            PoiType lastType = null;
            while ((n = parser.next()) != 1) {
                String name;
                if (n == 2) {
                    AbstractPoiType tp;
                    name = parser.getName();
                    if (name.equals("poi_category")) {
                        lastCategory = new PoiCategory(this, parser.getAttributeValue("", "name"), this.categories.size());
                        lastCategory.setTopVisible(Boolean.parseBoolean(parser.getAttributeValue("", "top")));
                        lastCategory.setNotEditableOsm("true".equals(parser.getAttributeValue("", "no_edit")));
                        lastCategory.setDefaultTag(parser.getAttributeValue("", "default_tag"));
                        this.categories.add(lastCategory);
                        continue;
                    }
                    if (name.equals("poi_filter")) {
                        tp = new PoiFilter(this, lastCategory, parser.getAttributeValue("", "name"));
                        tp.setTopVisible(Boolean.parseBoolean(parser.getAttributeValue("", "top")));
                        lastFilter = tp;
                        lastCategory.addPoiType((PoiFilter)tp);
                        continue;
                    }
                    if (name.equals("poi_reference")) {
                        tp = new PoiType(this, lastCategory, parser.getAttributeValue("", "name"));
                        referenceTypes.add(tp);
                        ((PoiType)tp).setReferenceType((PoiType)tp);
                        if (lastFilter != null) {
                            ((PoiFilter)lastFilter).addPoiType((PoiType)tp);
                        }
                        lastCategory.addPoiType((PoiType)tp);
                        continue;
                    }
                    if (name.equals("poi_additional")) {
                        if (lastCategory == null) {
                            lastCategory = this.getOtherMapCategory();
                        }
                        PoiType baseType = this.parsePoiAdditional(parser, lastCategory, (PoiFilter)lastFilter, lastType, null, null);
                        if (!"true".equals(parser.getAttributeValue("", "lang"))) continue;
                        String[] stringArray = MapRenderingTypes.langs;
                        int n2 = stringArray.length;
                        for (int i = 0; i < n2; ++i) {
                            String lng = stringArray[i];
                            this.parsePoiAdditional(parser, lastCategory, (PoiFilter)lastFilter, lastType, lng, baseType);
                        }
                        this.parsePoiAdditional(parser, lastCategory, (PoiFilter)lastFilter, lastType, "en", baseType);
                        continue;
                    }
                    if (!name.equals("poi_type")) continue;
                    if (lastCategory == null) {
                        lastCategory = this.getOtherMapCategory();
                    }
                    lastType = this.parsePoiType(allTypes, parser, lastCategory, (PoiFilter)lastFilter, null, null);
                    if (!"true".equals(parser.getAttributeValue("", "lang"))) continue;
                    for (String lng : MapRenderingTypes.langs) {
                        this.parsePoiType(allTypes, parser, lastCategory, (PoiFilter)lastFilter, lng, lastType);
                    }
                    continue;
                }
                if (n != 3) continue;
                name = parser.getName();
                if (name.equals("poi_filter")) {
                    lastFilter = null;
                    continue;
                }
                if (name.equals("poi_type")) {
                    lastType = null;
                    continue;
                }
                if (!name.equals("poi_category")) continue;
                lastCategory = null;
            }
            is.close();
        }
        catch (IOException e) {
            log.error((Object)"Unexpected error", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            log.error((Object)"Unexpected error", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        catch (XmlPullParserException e) {
            log.error((Object)"Unexpected error", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        for (PoiType poiType : referenceTypes) {
            PoiType pt = (PoiType)allTypes.get(poiType.getKeyName());
            if (pt == null || pt.getOsmTag() == null) {
                throw new IllegalStateException("Can't find poi type for poi reference '" + poiType.keyName + "'");
            }
            poiType.setReferenceType(pt);
        }
        this.findDefaultOtherCategory();
        this.init = true;
        log.info((Object)("Time to init poi types " + (System.currentTimeMillis() - time)));
    }

    private PoiType parsePoiAdditional(XmlPullParser parser, PoiCategory lastCategory, PoiFilter lastFilter, PoiType lastType, String lang, PoiType langBaseType) {
        String oname = parser.getAttributeValue("", "name");
        if (lang != null) {
            oname = oname + ":" + lang;
        }
        String otag = parser.getAttributeValue("", "tag");
        if (lang != null) {
            otag = otag + ":" + lang;
        }
        PoiType tp = new PoiType(this, lastCategory, oname);
        tp.setBaseLangType(langBaseType);
        tp.setLang(lang);
        tp.setAdditional(lastType != null ? lastType : (lastFilter != null ? lastFilter : lastCategory));
        tp.setTopVisible(Boolean.parseBoolean(parser.getAttributeValue("", "top")));
        tp.setText("text".equals(parser.getAttributeValue("", "type")));
        String orderStr = parser.getAttributeValue("", "order");
        if (!Algorithms.isEmpty(orderStr)) {
            tp.setOrder(Integer.parseInt(orderStr));
        }
        tp.setOsmTag(otag);
        tp.setNotEditableOsm("true".equals(parser.getAttributeValue("", "no_edit")));
        tp.setOsmValue(parser.getAttributeValue("", "value"));
        tp.setOsmTag2(parser.getAttributeValue("", "tag2"));
        tp.setOsmValue2(parser.getAttributeValue("", "value2"));
        if (lastType != null) {
            lastType.addPoiAdditional(tp);
        } else if (lastFilter != null) {
            lastFilter.addPoiAdditional(tp);
        } else if (lastCategory != null) {
            lastCategory.addPoiAdditional(tp);
        }
        return tp;
    }

    private PoiType parsePoiType(Map<String, PoiType> allTypes, XmlPullParser parser, PoiCategory lastCategory, PoiFilter lastFilter, String lang, PoiType langBaseType) {
        String oname = parser.getAttributeValue("", "name");
        if (lang != null) {
            oname = oname + ":" + lang;
        }
        PoiType tp = new PoiType(this, lastCategory, oname);
        String otag = parser.getAttributeValue("", "tag");
        if (lang != null) {
            otag = otag + ":" + lang;
        }
        tp.setBaseLangType(langBaseType);
        tp.setLang(lang);
        tp.setOsmTag(otag);
        tp.setOsmValue(parser.getAttributeValue("", "value"));
        tp.setOsmTag2(parser.getAttributeValue("", "tag2"));
        tp.setOsmValue2(parser.getAttributeValue("", "value2"));
        tp.setText("text".equals(parser.getAttributeValue("", "type")));
        String orderStr = parser.getAttributeValue("", "order");
        if (!Algorithms.isEmpty(orderStr)) {
            tp.setOrder(Integer.parseInt(orderStr));
        }
        tp.setNameOnly("true".equals(parser.getAttributeValue("", "name_only")));
        tp.setNameTag(parser.getAttributeValue("", "name_tag"));
        tp.setRelation("true".equals(parser.getAttributeValue("", "relation")));
        tp.setNotEditableOsm("true".equals(parser.getAttributeValue("", "no_edit")));
        if (lastFilter != null) {
            lastFilter.addPoiType(tp);
        }
        allTypes.put(tp.getKeyName(), tp);
        lastCategory.addPoiType(tp);
        if ("true".equals(parser.getAttributeValue("", "basemap"))) {
            lastCategory.addBasemapPoi(tp);
        }
        return tp;
    }

    private void findDefaultOtherCategory() {
        PoiCategory pc = this.getPoiCategoryByName("user_defined_other");
        if (pc == null) {
            throw new IllegalArgumentException("No poi category other");
        }
        this.otherCategory = pc;
    }

    public List<PoiCategory> getCategories(boolean includeMapCategory) {
        ArrayList<PoiCategory> lst = new ArrayList<PoiCategory>(this.categories);
        if (!includeMapCategory) {
            lst.remove(this.getOtherMapCategory());
        }
        return lst;
    }

    private static void print(MapPoiTypes df) {
        List<PoiCategory> pc = df.getCategories(true);
        for (PoiCategory p : pc) {
            System.out.println("Category " + p.getKeyName());
            for (PoiFilter f : p.getPoiFilters()) {
                System.out.println(" Filter " + f.getKeyName());
                MapPoiTypes.print("  ", f);
            }
            MapPoiTypes.print(" ", p);
        }
    }

    private PoiType getPoiAdditionalByKey(AbstractPoiType p, String name) {
        List<PoiType> pp = p.getPoiAdditionals();
        if (pp != null) {
            for (PoiType pt : pp) {
                if (!pt.getKeyName().equals(name)) continue;
                return pt;
            }
        }
        return null;
    }

    public AbstractPoiType getAnyPoiAdditionalTypeByKey(String name) {
        PoiType add = null;
        for (PoiCategory pc : this.categories) {
            add = this.getPoiAdditionalByKey(pc, name);
            if (add != null) {
                return add;
            }
            for (PoiFilter pf : pc.getPoiFilters()) {
                add = this.getPoiAdditionalByKey(pf, name);
                if (add == null) continue;
                return add;
            }
            for (PoiType p : pc.getPoiTypes()) {
                add = this.getPoiAdditionalByKey(p, name);
                if (add == null) continue;
                return add;
            }
        }
        return null;
    }

    private static void print(String indent, PoiFilter f) {
        for (PoiType pt : f.getPoiTypes()) {
            System.out.println(indent + " Type " + pt.getKeyName() + (pt.isReference() ? " -> " + pt.getReferenceType().getCategory().getKeyName() : ""));
        }
    }

    public static void main(String[] args) {
        DEFAULT_INSTANCE = new MapPoiTypes("/Users/victorshcherb/osmand/repos/resources/poi/poi_types.xml");
        DEFAULT_INSTANCE.init();
        List<PoiFilter> lf = DEFAULT_INSTANCE.getTopVisibleFilters();
        for (PoiFilter l : lf) {
            System.out.println("----------------- " + l.getKeyName());
            Map<PoiCategory, LinkedHashSet<String>> map = l.putTypes(new LinkedHashMap<PoiCategory, LinkedHashSet<String>>());
        }
    }

    public String getTranslation(AbstractPoiType abstractPoiType) {
        String translation;
        if (this.poiTranslator != null && !Algorithms.isEmpty(translation = this.poiTranslator.getTranslation(abstractPoiType))) {
            return translation;
        }
        return Algorithms.capitalizeFirstLetterAndLowercase(abstractPoiType.getKeyName().replace('_', ' '));
    }

    public boolean isRegisteredType(PoiCategory t) {
        return this.getPoiCategoryByName(t.getKeyName()) != this.otherCategory;
    }

    public void initPoiTypesByTag() {
        if (!this.poiTypesByTag.isEmpty()) {
            return;
        }
        for (PoiCategory poic : this.categories) {
            for (PoiType p : poic.getPoiTypes()) {
                this.initPoiType(p);
                for (PoiType pts : p.getPoiAdditionals()) {
                    this.initPoiType(pts);
                }
            }
            for (PoiType p : poic.getPoiAdditionals()) {
                this.initPoiType(p);
            }
        }
    }

    private void initPoiType(PoiType p) {
        if (!p.isReference()) {
            String key = null;
            key = p.isAdditional() ? (p.isText() ? p.getOsmTag() : p.getOsmTag() + "/" + p.getOsmValue()) : p.getOsmTag() + "/" + p.getOsmValue();
            if (this.poiTypesByTag.containsKey(key)) {
                throw new UnsupportedOperationException("!! Duplicate poi type " + key);
            }
            this.poiTypesByTag.put(key, p);
        }
    }

    public Amenity parseAmenity(String tag, String val, boolean relation, Map<String, String> otherTags) {
        boolean hasName;
        this.initPoiTypesByTag();
        PoiType pt = this.poiTypesByTag.get(tag + "/" + val);
        if (pt == null) {
            pt = this.poiTypesByTag.get(tag);
        }
        if (pt == null || pt.isAdditional()) {
            return null;
        }
        if (!Algorithms.isEmpty(pt.getOsmTag2()) && !Algorithms.objectEquals(otherTags.get(pt.getOsmTag2()), pt.getOsmValue2())) {
            return null;
        }
        if (pt.getCategory() == this.getOtherMapCategory()) {
            return null;
        }
        String nameValue = otherTags.get("name");
        if (pt.getNameTag() != null) {
            nameValue = otherTags.get(pt.getNameTag());
        }
        boolean bl = hasName = !Algorithms.isEmpty(nameValue);
        if (!hasName && pt.isNameOnly()) {
            return null;
        }
        if (relation && !pt.isRelation()) {
            return null;
        }
        Amenity a = new Amenity();
        a.setType(pt.getCategory());
        a.setSubType(pt.getKeyName());
        if (pt.getNameTag() != null) {
            a.setName(nameValue);
        }
        for (Map.Entry<String, String> e : otherTags.entrySet()) {
            String otag = e.getKey();
            if (otag.equals(tag) || otag.equals("name")) continue;
            PoiType pat = this.poiTypesByTag.get(otag + "/" + e.getValue());
            if (pat == null) {
                pat = this.poiTypesByTag.get(otag);
            }
            if (pat == null || !pat.isAdditional()) continue;
            a.setAdditionalInfo(pat.getKeyName(), e.getValue());
        }
        return a;
    }

    public boolean isTextAdditionalInfo(String key, String value) {
        if (key.startsWith("name:") || key.equals("name")) {
            return true;
        }
        PoiType pat = (PoiType)this.getAnyPoiAdditionalTypeByKey(key);
        if (pat == null) {
            return true;
        }
        return pat.isText();
    }

    public static interface PoiTranslator {
        public String getTranslation(AbstractPoiType var1);
    }
}

