/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.opensearch.Version;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.controller.MLRateLimiter;
import org.opensearch.ml.common.model.BaseModelConfig;
import org.opensearch.ml.common.model.Guardrails;
import org.opensearch.ml.common.model.MLDeploySetting;
import org.opensearch.ml.common.model.MLModelConfig;
import org.opensearch.ml.common.model.MLModelFormat;
import org.opensearch.ml.common.model.MLModelState;
import org.opensearch.ml.common.model.MetricsCorrelationModelConfig;
import org.opensearch.ml.common.model.QuestionAnsweringModelConfig;
import org.opensearch.ml.common.model.RemoteModelConfig;
import org.opensearch.ml.common.model.TextEmbeddingModelConfig;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.repackage.com.google.common.annotations.VisibleForTesting;
import org.opensearch.telemetry.metrics.tags.Tags;

public class MLModel
implements ToXContentObject {
    @Generated
    private static final Logger log = LogManager.getLogger(MLModel.class);
    @Deprecated
    public static final String ALGORITHM_FIELD = "algorithm";
    public static final String FUNCTION_NAME_FIELD = "function_name";
    public static final String MODEL_NAME_FIELD = "name";
    public static final String MODEL_GROUP_ID_FIELD = "model_group_id";
    public static final String OLD_MODEL_VERSION_FIELD = "version";
    public static final String MODEL_VERSION_FIELD = "model_version";
    public static final String OLD_MODEL_CONTENT_FIELD = "content";
    public static final String MODEL_CONTENT_FIELD = "model_content";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String MODEL_FORMAT_FIELD = "model_format";
    public static final String MODEL_STATE_FIELD = "model_state";
    public static final String MODEL_CONTENT_SIZE_IN_BYTES_FIELD = "model_content_size_in_bytes";
    public static final String MODEL_CONTENT_HASH_VALUE_FIELD = "model_content_hash_value";
    public static final String IS_ENABLED_FIELD = "is_enabled";
    public static final String RATE_LIMITER_FIELD = "rate_limiter";
    public static final String IS_CONTROLLER_ENABLED_FIELD = "is_controller_enabled";
    public static final String MODEL_CONFIG_FIELD = "model_config";
    public static final String DEPLOY_SETTING_FIELD = "deploy_setting";
    public static final String CREATED_TIME_FIELD = "created_time";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    @Deprecated
    public static final String LAST_UPLOADED_TIME_FIELD = "last_uploaded_time";
    @Deprecated
    public static final String LAST_LOADED_TIME_FIELD = "last_loaded_time";
    @Deprecated
    public static final String LAST_UNLOADED_TIME_FIELD = "last_unloaded_time";
    public static final String LAST_REGISTERED_TIME_FIELD = "last_registered_time";
    public static final String LAST_DEPLOYED_TIME_FIELD = "last_deployed_time";
    public static final String LAST_UNDEPLOYED_TIME_FIELD = "last_undeployed_time";
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String AUTO_REDEPLOY_RETRY_TIMES_FIELD = "auto_redeploy_retry_times";
    public static final String CHUNK_NUMBER_FIELD = "chunk_number";
    public static final String TOTAL_CHUNKS_FIELD = "total_chunks";
    public static final String PLANNING_WORKER_NODE_COUNT_FIELD = "planning_worker_node_count";
    public static final String CURRENT_WORKER_NODE_COUNT_FIELD = "current_worker_node_count";
    public static final String PLANNING_WORKER_NODES_FIELD = "planning_worker_nodes";
    public static final String DEPLOY_TO_ALL_NODES_FIELD = "deploy_to_all_nodes";
    public static final String IS_HIDDEN_FIELD = "is_hidden";
    public static final String CONNECTOR_FIELD = "connector";
    public static final String CONNECTOR_ID_FIELD = "connector_id";
    public static final String GUARDRAILS_FIELD = "guardrails";
    public static final String INTERFACE_FIELD = "interface";
    private static final String TAG_DEPLOYMENT = "deployment";
    private static final String TAG_REMOTE_DEPLOYMENT_VALUE = "remote";
    private static final String TAG_PRE_TRAINED_DEPLOYMENT_VALUE = "local:pre_trained";
    private static final String TAG_CUSTOM_DEPLOYMENT_VALUE = "local:custom";
    private static final String TAG_ALGORITHM = "algorithm";
    private static final String TAG_MODEL = "model";
    private static final String TAG_SERVICE_PROVIDER = "service_provider";
    private static final String TAG_VALUE_UNKNOWN = "unknown";
    private static final String TAG_TYPE = "type";
    private static final String TAG_MODEL_FORMAT = "model_format";
    private static final String TAG_URL = "url";
    private static final String BEDROCK = "bedrock";
    private static final String SAGEMAKER = "sagemaker";
    private static final String AZURE = "azure";
    private static final String GOOGLE = "google";
    private static final String OPENAI = "openai";
    private static final String DEEPSEEK = "deepseek";
    private static final String COHERE = "cohere";
    private static final String VERTEXAI = "vertexai";
    private static final String ALEPH_ALPHA = "aleph-alpha";
    private static final String COMPREHEND = "comprehend";
    private static final String TEXTRACT = "textract";
    private static final String ANTHROPIC = "anthropic";
    private static final String MISTRAL = "mistral";
    private static final String X_AI = "x.ai";
    private static final List<String> MODEL_SERVICE_PROVIDER_KEYWORDS = Arrays.asList("bedrock", "sagemaker", "azure", "google", "anthropic", "openai", "deepseek", "cohere", "vertexai", "aleph-alpha", "comprehend", "textract", "mistral", "x.ai");
    private static final String LLM_MODEL_TYPE = "llm";
    private static final String EMBEDDING_MODEL_TYPE = "embedding";
    private static final String IMAGE_GENERATION_MODEL_TYPE = "image_generation";
    private static final String SPEECH_AUDIO_MODEL_TYPE = "speech_audio";
    private static final List<String> LLM_KEYWORDS = Arrays.asList("gpt", "o3", "o4-mini", "claude", "llama", "mistral", "mixtral", "gemini", "palm", "bard", "j1-", "j2-", "jurassic", "command", "grok", "chat", "llm");
    private static final List<String> EMBEDDING_KEYWORDS = Arrays.asList("embedding", "embed", "ada", "text-similarity-");
    private static final List<String> IMAGE_GEN_KEYWORDS = Arrays.asList("diffusion", "dall-e", "imagen", "midjourney", "image");
    private static final List<String> SPEECH_AUDIO_KEYWORDS = Arrays.asList("whisper", "audio", "speech");
    public static final Set<String> allowedInterfaceFieldKeys = new HashSet<String>(Arrays.asList("input", "output"));
    private String name;
    private String modelGroupId;
    private FunctionName algorithm;
    private String version;
    private String content;
    private User user;
    private String description;
    private MLModelFormat modelFormat;
    private MLModelState modelState;
    private Long modelContentSizeInBytes;
    private String modelContentHash;
    private MLModelConfig modelConfig;
    private MLDeploySetting deploySetting;
    private Boolean isEnabled;
    private Boolean isControllerEnabled;
    private MLRateLimiter rateLimiter;
    private Instant createdTime;
    private Instant lastUpdateTime;
    private Instant lastRegisteredTime;
    private Instant lastDeployedTime;
    private Instant lastUndeployedTime;
    private String modelId;
    private Integer autoRedeployRetryTimes;
    private Integer chunkNumber;
    private Integer totalChunks;
    private Integer planningWorkerNodeCount;
    private Integer currentWorkerNodeCount;
    private String[] planningWorkerNodes;
    private boolean deployToAllNodes;
    private Boolean isHidden;
    private Connector connector;
    private String connectorId;
    private Guardrails guardrails;
    private String tenantId;
    private Map<String, String> modelInterface;

    public MLModel(String name, String modelGroupId, FunctionName algorithm, String version, String content, User user, String description, MLModelFormat modelFormat, MLModelState modelState, Long modelContentSizeInBytes, String modelContentHash, Boolean isEnabled, Boolean isControllerEnabled, MLRateLimiter rateLimiter, MLModelConfig modelConfig, MLDeploySetting deploySetting, Instant createdTime, Instant lastUpdateTime, Instant lastRegisteredTime, Instant lastDeployedTime, Instant lastUndeployedTime, Integer autoRedeployRetryTimes, String modelId, Integer chunkNumber, Integer totalChunks, Integer planningWorkerNodeCount, Integer currentWorkerNodeCount, String[] planningWorkerNodes, boolean deployToAllNodes, Boolean isHidden, Connector connector, String connectorId, Guardrails guardrails, Map<String, String> modelInterface, String tenantId) {
        this.name = name;
        this.modelGroupId = modelGroupId;
        this.algorithm = algorithm;
        this.version = version;
        this.content = content;
        this.user = user;
        this.description = description;
        this.modelFormat = modelFormat;
        this.modelState = modelState;
        this.modelContentSizeInBytes = modelContentSizeInBytes;
        this.modelContentHash = modelContentHash;
        this.isEnabled = isEnabled;
        this.isControllerEnabled = isControllerEnabled;
        this.rateLimiter = rateLimiter;
        this.modelConfig = modelConfig;
        this.deploySetting = deploySetting;
        this.createdTime = createdTime;
        this.lastUpdateTime = lastUpdateTime;
        this.lastRegisteredTime = lastRegisteredTime;
        this.lastDeployedTime = lastDeployedTime;
        this.lastUndeployedTime = lastUndeployedTime;
        this.modelId = modelId;
        this.autoRedeployRetryTimes = autoRedeployRetryTimes;
        this.chunkNumber = chunkNumber;
        this.totalChunks = totalChunks;
        this.planningWorkerNodeCount = planningWorkerNodeCount;
        this.currentWorkerNodeCount = currentWorkerNodeCount;
        this.planningWorkerNodes = planningWorkerNodes;
        this.deployToAllNodes = deployToAllNodes;
        this.isHidden = isHidden;
        this.connector = connector;
        this.connectorId = connectorId;
        this.guardrails = guardrails;
        this.modelInterface = modelInterface;
        this.tenantId = tenantId;
    }

    public MLModel(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.name = input.readOptionalString();
        this.algorithm = (FunctionName)input.readEnum(FunctionName.class);
        this.version = input.readString();
        this.content = input.readOptionalString();
        this.user = input.readBoolean() ? new User(input) : null;
        if (input.available() > 0) {
            this.description = input.readOptionalString();
            if (input.readBoolean()) {
                this.modelFormat = (MLModelFormat)input.readEnum(MLModelFormat.class);
            }
            if (input.readBoolean()) {
                this.modelState = (MLModelState)input.readEnum(MLModelState.class);
            }
            this.modelContentSizeInBytes = input.readOptionalLong();
            this.modelContentHash = input.readOptionalString();
            if (input.readBoolean()) {
                this.modelConfig = this.algorithm.equals((Object)FunctionName.METRICS_CORRELATION) ? new MetricsCorrelationModelConfig(input) : (this.algorithm.equals((Object)FunctionName.QUESTION_ANSWERING) ? new QuestionAnsweringModelConfig(input) : (this.algorithm.equals((Object)FunctionName.TEXT_EMBEDDING) ? new TextEmbeddingModelConfig(input) : (this.algorithm.equals((Object)FunctionName.REMOTE) ? new RemoteModelConfig(input) : new BaseModelConfig(input))));
            }
            if (input.readBoolean()) {
                this.deploySetting = new MLDeploySetting(input);
            }
            this.isEnabled = input.readOptionalBoolean();
            this.isControllerEnabled = input.readOptionalBoolean();
            if (input.readBoolean()) {
                this.rateLimiter = new MLRateLimiter(input);
            }
            this.createdTime = input.readOptionalInstant();
            this.lastUpdateTime = input.readOptionalInstant();
            this.lastRegisteredTime = input.readOptionalInstant();
            this.lastDeployedTime = input.readOptionalInstant();
            this.lastUndeployedTime = input.readOptionalInstant();
            this.modelId = input.readOptionalString();
            this.autoRedeployRetryTimes = input.readOptionalInt();
            this.chunkNumber = input.readOptionalInt();
            this.totalChunks = input.readOptionalInt();
            this.planningWorkerNodeCount = input.readOptionalInt();
            this.currentWorkerNodeCount = input.readOptionalInt();
            this.planningWorkerNodes = input.readOptionalStringArray();
            this.deployToAllNodes = input.readBoolean();
            this.isHidden = input.readOptionalBoolean();
            this.modelGroupId = input.readOptionalString();
            if (input.readBoolean()) {
                this.connector = Connector.fromStream(input);
            }
            this.connectorId = input.readOptionalString();
            if (input.readBoolean()) {
                this.guardrails = new Guardrails(input);
            }
            if (input.readBoolean()) {
                this.modelInterface = input.readMap(StreamInput::readString, StreamInput::readString);
            }
            this.tenantId = streamInputVersion.onOrAfter(CommonValue.VERSION_2_19_0) ? input.readOptionalString() : null;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalString(this.name);
        out.writeEnum((Enum)this.algorithm);
        out.writeString(this.version);
        out.writeOptionalString(this.content);
        if (this.user != null) {
            out.writeBoolean(true);
            this.user.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.description);
        if (this.modelFormat != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelFormat);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelState != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelState);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalLong(this.modelContentSizeInBytes);
        out.writeOptionalString(this.modelContentHash);
        if (this.modelConfig != null) {
            out.writeBoolean(true);
            this.modelConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.deploySetting != null) {
            out.writeBoolean(true);
            this.deploySetting.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.isEnabled);
        out.writeOptionalBoolean(this.isControllerEnabled);
        if (this.rateLimiter != null) {
            out.writeBoolean(true);
            this.rateLimiter.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdateTime);
        out.writeOptionalInstant(this.lastRegisteredTime);
        out.writeOptionalInstant(this.lastDeployedTime);
        out.writeOptionalInstant(this.lastUndeployedTime);
        out.writeOptionalString(this.modelId);
        out.writeOptionalInt(this.autoRedeployRetryTimes);
        out.writeOptionalInt(this.chunkNumber);
        out.writeOptionalInt(this.totalChunks);
        out.writeOptionalInt(this.planningWorkerNodeCount);
        out.writeOptionalInt(this.currentWorkerNodeCount);
        out.writeOptionalStringArray(this.planningWorkerNodes);
        out.writeBoolean(this.deployToAllNodes);
        out.writeOptionalBoolean(this.isHidden);
        out.writeOptionalString(this.modelGroupId);
        if (this.connector != null) {
            out.writeBoolean(true);
            this.connector.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.connectorId);
        if (this.guardrails != null) {
            out.writeBoolean(true);
            this.guardrails.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelInterface != null) {
            out.writeBoolean(true);
            out.writeMap(this.modelInterface, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (streamOutputVersion.onOrAfter(CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(MODEL_NAME_FIELD, this.name);
        }
        if (this.modelGroupId != null) {
            builder.field(MODEL_GROUP_ID_FIELD, this.modelGroupId);
        }
        if (this.algorithm != null) {
            builder.field("algorithm", (Object)this.algorithm);
        }
        if (this.version != null) {
            builder.field(MODEL_VERSION_FIELD, this.version);
        }
        if (this.content != null) {
            builder.field(MODEL_CONTENT_FIELD, this.content);
        }
        if (this.user != null) {
            builder.field("user", (ToXContent)this.user);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.modelFormat != null) {
            builder.field("model_format", (Object)this.modelFormat);
        }
        if (this.modelState != null) {
            builder.field(MODEL_STATE_FIELD, (Object)this.modelState);
        }
        if (this.modelContentSizeInBytes != null) {
            builder.field(MODEL_CONTENT_SIZE_IN_BYTES_FIELD, this.modelContentSizeInBytes);
        }
        if (this.modelContentHash != null) {
            builder.field(MODEL_CONTENT_HASH_VALUE_FIELD, this.modelContentHash);
        }
        if (this.modelConfig != null) {
            builder.field(MODEL_CONFIG_FIELD, (ToXContent)this.modelConfig);
        }
        if (this.deploySetting != null) {
            builder.field(DEPLOY_SETTING_FIELD, (ToXContent)this.deploySetting);
        }
        if (this.isEnabled != null) {
            builder.field(IS_ENABLED_FIELD, this.isEnabled);
        }
        if (this.isControllerEnabled != null) {
            builder.field(IS_CONTROLLER_ENABLED_FIELD, this.isControllerEnabled);
        }
        if (this.rateLimiter != null) {
            builder.field(RATE_LIMITER_FIELD, (ToXContent)this.rateLimiter);
        }
        if (this.createdTime != null) {
            builder.field(CREATED_TIME_FIELD, this.createdTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field(LAST_UPDATED_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        if (this.lastRegisteredTime != null) {
            builder.field(LAST_REGISTERED_TIME_FIELD, this.lastRegisteredTime.toEpochMilli());
        }
        if (this.lastDeployedTime != null) {
            builder.field(LAST_DEPLOYED_TIME_FIELD, this.lastDeployedTime.toEpochMilli());
        }
        if (this.lastUndeployedTime != null) {
            builder.field(LAST_UNDEPLOYED_TIME_FIELD, this.lastUndeployedTime.toEpochMilli());
        }
        if (this.modelId != null) {
            builder.field(MODEL_ID_FIELD, this.modelId);
        }
        if (this.autoRedeployRetryTimes != null) {
            builder.field(AUTO_REDEPLOY_RETRY_TIMES_FIELD, this.autoRedeployRetryTimes);
        }
        if (this.chunkNumber != null) {
            builder.field(CHUNK_NUMBER_FIELD, this.chunkNumber);
        }
        if (this.totalChunks != null) {
            builder.field(TOTAL_CHUNKS_FIELD, this.totalChunks);
        }
        if (this.planningWorkerNodeCount != null) {
            builder.field(PLANNING_WORKER_NODE_COUNT_FIELD, this.planningWorkerNodeCount);
        }
        if (this.currentWorkerNodeCount != null) {
            builder.field(CURRENT_WORKER_NODE_COUNT_FIELD, this.currentWorkerNodeCount);
        }
        if (this.planningWorkerNodes != null && this.planningWorkerNodes.length > 0) {
            builder.field(PLANNING_WORKER_NODES_FIELD, (Object)this.planningWorkerNodes);
        }
        if (this.deployToAllNodes) {
            builder.field(DEPLOY_TO_ALL_NODES_FIELD, this.deployToAllNodes);
        }
        if (this.isHidden != null) {
            builder.field(IS_HIDDEN_FIELD, this.isHidden);
        }
        if (this.connector != null) {
            builder.field(CONNECTOR_FIELD, (ToXContent)this.connector);
        }
        if (this.connectorId != null) {
            builder.field(CONNECTOR_ID_FIELD, this.connectorId);
        }
        if (this.guardrails != null) {
            builder.field(GUARDRAILS_FIELD, (ToXContent)this.guardrails);
        }
        if (this.modelInterface != null) {
            builder.field(INTERFACE_FIELD, this.modelInterface);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public static MLModel parse(XContentParser parser, String algorithmName) throws IOException {
        String name = null;
        String modelGroupId = null;
        FunctionName algorithm = null;
        Object version = null;
        Integer oldVersion = null;
        String content = null;
        String oldContent = null;
        User user = null;
        String description = null;
        MLModelFormat modelFormat = null;
        MLModelState modelState = null;
        Long modelContentSizeInBytes = null;
        String modelContentHash = null;
        MLModelConfig modelConfig = null;
        MLDeploySetting deploySetting = null;
        Boolean isEnabled = null;
        Boolean isControllerEnabled = null;
        MLRateLimiter rateLimiter = null;
        Instant createdTime = null;
        Instant lastUpdateTime = null;
        Instant lastUploadedTime = null;
        Instant lastLoadedTime = null;
        Instant lastUnloadedTime = null;
        Instant lastRegisteredTime = null;
        Instant lastDeployedTime = null;
        Instant lastUndeployedTime = null;
        String modelId = null;
        Integer autoRedeployRetryTimes = null;
        Integer chunkNumber = null;
        Integer totalChunks = null;
        Integer planningWorkerNodeCount = null;
        Integer currentWorkerNodeCount = null;
        ArrayList<String> planningWorkerNodes = new ArrayList<String>();
        boolean deployToAllNodes = false;
        boolean isHidden = false;
        Connector connector = null;
        String connectorId = null;
        Guardrails guardrails = null;
        Map<String, String> modelInterface = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block85: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block85;
                }
                case "model_group_id": {
                    modelGroupId = parser.text();
                    continue block85;
                }
                case "model_content": {
                    content = parser.text();
                    continue block85;
                }
                case "content": {
                    oldContent = parser.text();
                    continue block85;
                }
                case "model_version": {
                    version = parser.text();
                    continue block85;
                }
                case "version": {
                    oldVersion = parser.intValue(false);
                    continue block85;
                }
                case "chunk_number": {
                    chunkNumber = parser.intValue(false);
                    continue block85;
                }
                case "total_chunks": {
                    totalChunks = parser.intValue(false);
                    continue block85;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    continue block85;
                }
                case "algorithm": 
                case "function_name": {
                    algorithm = FunctionName.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block85;
                }
                case "model_id": {
                    modelId = parser.text();
                    continue block85;
                }
                case "auto_redeploy_retry_times": {
                    autoRedeployRetryTimes = parser.intValue();
                    continue block85;
                }
                case "description": {
                    description = parser.text();
                    continue block85;
                }
                case "model_format": {
                    modelFormat = MLModelFormat.from(parser.text());
                    continue block85;
                }
                case "model_state": {
                    modelState = MLModelState.from(parser.text());
                    continue block85;
                }
                case "model_content_size_in_bytes": {
                    modelContentSizeInBytes = parser.longValue();
                    continue block85;
                }
                case "model_content_hash_value": {
                    modelContentHash = parser.text();
                    continue block85;
                }
                case "model_config": {
                    if (FunctionName.METRICS_CORRELATION.name().equals(algorithmName)) {
                        modelConfig = MetricsCorrelationModelConfig.parse(parser);
                        continue block85;
                    }
                    if (FunctionName.QUESTION_ANSWERING.name().equals(algorithmName)) {
                        modelConfig = QuestionAnsweringModelConfig.parse(parser);
                        continue block85;
                    }
                    if (FunctionName.TEXT_EMBEDDING.name().equals(algorithmName)) {
                        modelConfig = TextEmbeddingModelConfig.parse(parser);
                        continue block85;
                    }
                    if (FunctionName.REMOTE.name().equals(algorithmName)) {
                        modelConfig = RemoteModelConfig.parse(parser);
                        continue block85;
                    }
                    modelConfig = BaseModelConfig.parse(parser);
                    continue block85;
                }
                case "deploy_setting": {
                    deploySetting = MLDeploySetting.parse(parser);
                    continue block85;
                }
                case "is_enabled": {
                    isEnabled = parser.booleanValue();
                    continue block85;
                }
                case "is_controller_enabled": {
                    isControllerEnabled = parser.booleanValue();
                    continue block85;
                }
                case "rate_limiter": {
                    rateLimiter = MLRateLimiter.parse(parser);
                    continue block85;
                }
                case "planning_worker_node_count": {
                    planningWorkerNodeCount = parser.intValue();
                    continue block85;
                }
                case "current_worker_node_count": {
                    currentWorkerNodeCount = parser.intValue();
                    continue block85;
                }
                case "planning_worker_nodes": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        planningWorkerNodes.add(parser.text());
                    }
                    continue block85;
                }
                case "deploy_to_all_nodes": {
                    deployToAllNodes = parser.booleanValue();
                    continue block85;
                }
                case "is_hidden": {
                    isHidden = parser.booleanValue();
                    continue block85;
                }
                case "connector": {
                    connector = Connector.createConnector(parser);
                    continue block85;
                }
                case "connector_id": {
                    connectorId = parser.text();
                    continue block85;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block85;
                }
                case "last_updated_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block85;
                }
                case "last_uploaded_time": {
                    lastUploadedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block85;
                }
                case "last_loaded_time": {
                    lastLoadedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block85;
                }
                case "last_unloaded_time": {
                    lastUnloadedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block85;
                }
                case "last_registered_time": {
                    lastRegisteredTime = Instant.ofEpochMilli(parser.longValue());
                    continue block85;
                }
                case "last_deployed_time": {
                    lastDeployedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block85;
                }
                case "last_undeployed_time": {
                    lastUndeployedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block85;
                }
                case "guardrails": {
                    guardrails = Guardrails.parse(parser);
                    continue block85;
                }
                case "interface": {
                    modelInterface = StringUtils.filteredParameterMap(parser.map(), allowedInterfaceFieldKeys);
                    continue block85;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block85;
                }
            }
            parser.skipChildren();
        }
        return MLModel.builder().name(name).modelGroupId(modelGroupId).algorithm(algorithm).version((String)(version == null ? "" + oldVersion : version)).content(content == null ? oldContent : content).user(user).description(description).modelFormat(modelFormat).modelState(modelState).modelContentSizeInBytes(modelContentSizeInBytes).modelContentHash(modelContentHash).modelConfig(modelConfig).deploySetting(deploySetting).isEnabled(isEnabled).isControllerEnabled(isControllerEnabled).rateLimiter(rateLimiter).createdTime(createdTime).lastUpdateTime(lastUpdateTime).lastRegisteredTime(lastRegisteredTime == null ? lastUploadedTime : lastRegisteredTime).lastDeployedTime(lastDeployedTime == null ? lastLoadedTime : lastDeployedTime).lastUndeployedTime(lastUndeployedTime == null ? lastUnloadedTime : lastUndeployedTime).modelId(modelId).autoRedeployRetryTimes(autoRedeployRetryTimes).chunkNumber(chunkNumber).totalChunks(totalChunks).planningWorkerNodeCount(planningWorkerNodeCount).currentWorkerNodeCount(currentWorkerNodeCount).planningWorkerNodes(planningWorkerNodes.toArray(new String[0])).deployToAllNodes(deployToAllNodes).isHidden(isHidden).connector(connector).connectorId(connectorId).guardrails(guardrails).modelInterface(modelInterface).tenantId(tenantId).build();
    }

    public static MLModel fromStream(StreamInput in) throws IOException {
        return new MLModel(in);
    }

    public Tags getTags() {
        return this.getTags(this.connector);
    }

    public Tags getTags(Connector connector) {
        if (this.algorithm == FunctionName.REMOTE && connector != null) {
            return this.getRemoteModelTags(connector);
        }
        if (this.name != null && (this.name.startsWith("amazon/") || this.name.startsWith("huggingface/")) && this.name.split("/").length >= 3) {
            return this.getPreTrainedModelTags();
        }
        return this.getCustomModelTags();
    }

    @VisibleForTesting
    Tags getRemoteModelTags(Connector connector) {
        String serviceProvider = TAG_VALUE_UNKNOWN;
        String model = TAG_VALUE_UNKNOWN;
        String modelType = TAG_VALUE_UNKNOWN;
        String url = TAG_VALUE_UNKNOWN;
        Optional<ConnectorAction> predictAction = connector.findAction(ConnectorAction.ActionType.PREDICT.name());
        if (predictAction.isPresent()) {
            try {
                StringSubstitutor stringSubstitutor = new StringSubstitutor(connector.getParameters(), "${parameters.", "}");
                url = stringSubstitutor.replace(predictAction.get().getUrl()).toLowerCase();
                JSONObject requestBody = null;
                if (predictAction.get().getRequestBody() != null) {
                    try {
                        String body = stringSubstitutor.replace(predictAction.get().getRequestBody());
                        requestBody = new JSONObject(body);
                    }
                    catch (Exception e) {
                        log.error("Failed to parse request body as JSON: {}", (Object)e.getMessage());
                    }
                }
                serviceProvider = this.identifyServiceProvider(url);
                model = this.identifyModel(serviceProvider, url, requestBody, connector);
                modelType = this.identifyModelType(model);
            }
            catch (Exception e) {
                log.warn("Error identifying model provider and model from connector: {}", (Object)e.getMessage());
            }
        }
        Tags tags = Tags.create().addTag(TAG_DEPLOYMENT, TAG_REMOTE_DEPLOYMENT_VALUE).addTag(TAG_SERVICE_PROVIDER, serviceProvider).addTag("algorithm", this.algorithm.name()).addTag(TAG_MODEL, model).addTag(TAG_TYPE, modelType);
        if ((serviceProvider.equals(TAG_VALUE_UNKNOWN) || model.equals(TAG_VALUE_UNKNOWN)) && !url.equals(TAG_VALUE_UNKNOWN)) {
            tags.addTag(TAG_URL, url);
        }
        return tags;
    }

    @VisibleForTesting
    String identifyServiceProvider(String url) {
        for (String provider : MODEL_SERVICE_PROVIDER_KEYWORDS) {
            if (!url.contains(provider)) continue;
            return provider;
        }
        return TAG_VALUE_UNKNOWN;
    }

    @VisibleForTesting
    String identifyModel(String provider, String url, JSONObject requestBody, Connector connector) {
        try {
            Pattern bedrockPattern;
            Matcher bedrockMatcher;
            if (provider.equals(BEDROCK) && (bedrockMatcher = (bedrockPattern = Pattern.compile("/model/([^/]+)/")).matcher(url)).find()) {
                return bedrockMatcher.group(1);
            }
        }
        catch (Exception e) {
            log.error("Error extracting model information: {}", (Object)e.getMessage());
        }
        if (requestBody != null) {
            if (requestBody.keySet().contains(TAG_MODEL)) {
                return requestBody.getString(TAG_MODEL);
            }
            if (requestBody.keySet().contains("ModelName")) {
                return requestBody.getString("ModelName");
            }
        }
        if (connector.getParameters() != null && connector.getParameters().containsKey(TAG_MODEL)) {
            return connector.getParameters().get(TAG_MODEL);
        }
        return TAG_VALUE_UNKNOWN;
    }

    private static boolean containsAny(String target, List<String> keywords) {
        for (String key : keywords) {
            if (!target.contains(key)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    String identifyModelType(String model) {
        if (model == null || TAG_VALUE_UNKNOWN.equals(model)) {
            return TAG_VALUE_UNKNOWN;
        }
        String modelLower = model.toLowerCase();
        if (MLModel.containsAny(modelLower, LLM_KEYWORDS)) {
            return LLM_MODEL_TYPE;
        }
        if (MLModel.containsAny(modelLower, EMBEDDING_KEYWORDS)) {
            return EMBEDDING_MODEL_TYPE;
        }
        if (MLModel.containsAny(modelLower, IMAGE_GEN_KEYWORDS)) {
            return IMAGE_GENERATION_MODEL_TYPE;
        }
        if (MLModel.containsAny(modelLower, SPEECH_AUDIO_KEYWORDS)) {
            return SPEECH_AUDIO_MODEL_TYPE;
        }
        return TAG_VALUE_UNKNOWN;
    }

    @VisibleForTesting
    Tags getPreTrainedModelTags() {
        String modelType = TAG_VALUE_UNKNOWN;
        if (this.modelConfig != null && this.modelConfig.getModelType() != null) {
            modelType = this.modelConfig.getModelType();
        }
        String[] nameParts = this.name.split("/");
        Tags tags = Tags.create().addTag(TAG_DEPLOYMENT, TAG_PRE_TRAINED_DEPLOYMENT_VALUE).addTag(TAG_SERVICE_PROVIDER, nameParts[0]).addTag("algorithm", this.algorithm.name()).addTag(TAG_MODEL, nameParts[2]).addTag(TAG_TYPE, modelType);
        if (this.modelFormat != null) {
            tags.addTag("model_format", this.modelFormat.name());
        }
        return tags;
    }

    @VisibleForTesting
    Tags getCustomModelTags() {
        String modelType = TAG_VALUE_UNKNOWN;
        if (this.modelConfig != null && this.modelConfig.getModelType() != null) {
            modelType = this.modelConfig.getModelType();
        }
        Tags tags = Tags.create().addTag(TAG_DEPLOYMENT, TAG_CUSTOM_DEPLOYMENT_VALUE).addTag("algorithm", this.algorithm.name()).addTag(TAG_TYPE, modelType);
        if (this.modelFormat != null) {
            tags.addTag("model_format", this.modelFormat.name());
        }
        return tags;
    }

    @Generated
    public static MLModelBuilder builder() {
        return new MLModelBuilder();
    }

    @Generated
    public MLModelBuilder toBuilder() {
        return new MLModelBuilder().name(this.name).modelGroupId(this.modelGroupId).algorithm(this.algorithm).version(this.version).content(this.content).user(this.user).description(this.description).modelFormat(this.modelFormat).modelState(this.modelState).modelContentSizeInBytes(this.modelContentSizeInBytes).modelContentHash(this.modelContentHash).isEnabled(this.isEnabled).isControllerEnabled(this.isControllerEnabled).rateLimiter(this.rateLimiter).modelConfig(this.modelConfig).deploySetting(this.deploySetting).createdTime(this.createdTime).lastUpdateTime(this.lastUpdateTime).lastRegisteredTime(this.lastRegisteredTime).lastDeployedTime(this.lastDeployedTime).lastUndeployedTime(this.lastUndeployedTime).autoRedeployRetryTimes(this.autoRedeployRetryTimes).modelId(this.modelId).chunkNumber(this.chunkNumber).totalChunks(this.totalChunks).planningWorkerNodeCount(this.planningWorkerNodeCount).currentWorkerNodeCount(this.currentWorkerNodeCount).planningWorkerNodes(this.planningWorkerNodes).deployToAllNodes(this.deployToAllNodes).isHidden(this.isHidden).connector(this.connector).connectorId(this.connectorId).guardrails(this.guardrails).modelInterface(this.modelInterface).tenantId(this.tenantId);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getModelGroupId() {
        return this.modelGroupId;
    }

    @Generated
    public FunctionName getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public MLModelFormat getModelFormat() {
        return this.modelFormat;
    }

    @Generated
    public MLModelState getModelState() {
        return this.modelState;
    }

    @Generated
    public Long getModelContentSizeInBytes() {
        return this.modelContentSizeInBytes;
    }

    @Generated
    public String getModelContentHash() {
        return this.modelContentHash;
    }

    @Generated
    public MLModelConfig getModelConfig() {
        return this.modelConfig;
    }

    @Generated
    public MLDeploySetting getDeploySetting() {
        return this.deploySetting;
    }

    @Generated
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    @Generated
    public Boolean getIsControllerEnabled() {
        return this.isControllerEnabled;
    }

    @Generated
    public MLRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public Instant getLastRegisteredTime() {
        return this.lastRegisteredTime;
    }

    @Generated
    public Instant getLastDeployedTime() {
        return this.lastDeployedTime;
    }

    @Generated
    public Instant getLastUndeployedTime() {
        return this.lastUndeployedTime;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public Integer getAutoRedeployRetryTimes() {
        return this.autoRedeployRetryTimes;
    }

    @Generated
    public Integer getChunkNumber() {
        return this.chunkNumber;
    }

    @Generated
    public Integer getTotalChunks() {
        return this.totalChunks;
    }

    @Generated
    public Integer getPlanningWorkerNodeCount() {
        return this.planningWorkerNodeCount;
    }

    @Generated
    public Integer getCurrentWorkerNodeCount() {
        return this.currentWorkerNodeCount;
    }

    @Generated
    public String[] getPlanningWorkerNodes() {
        return this.planningWorkerNodes;
    }

    @Generated
    public boolean isDeployToAllNodes() {
        return this.deployToAllNodes;
    }

    @Generated
    public Boolean getIsHidden() {
        return this.isHidden;
    }

    @Generated
    public Connector getConnector() {
        return this.connector;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public Guardrails getGuardrails() {
        return this.guardrails;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public Map<String, String> getModelInterface() {
        return this.modelInterface;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Generated
    public static class MLModelBuilder {
        @Generated
        private String name;
        @Generated
        private String modelGroupId;
        @Generated
        private FunctionName algorithm;
        @Generated
        private String version;
        @Generated
        private String content;
        @Generated
        private User user;
        @Generated
        private String description;
        @Generated
        private MLModelFormat modelFormat;
        @Generated
        private MLModelState modelState;
        @Generated
        private Long modelContentSizeInBytes;
        @Generated
        private String modelContentHash;
        @Generated
        private Boolean isEnabled;
        @Generated
        private Boolean isControllerEnabled;
        @Generated
        private MLRateLimiter rateLimiter;
        @Generated
        private MLModelConfig modelConfig;
        @Generated
        private MLDeploySetting deploySetting;
        @Generated
        private Instant createdTime;
        @Generated
        private Instant lastUpdateTime;
        @Generated
        private Instant lastRegisteredTime;
        @Generated
        private Instant lastDeployedTime;
        @Generated
        private Instant lastUndeployedTime;
        @Generated
        private Integer autoRedeployRetryTimes;
        @Generated
        private String modelId;
        @Generated
        private Integer chunkNumber;
        @Generated
        private Integer totalChunks;
        @Generated
        private Integer planningWorkerNodeCount;
        @Generated
        private Integer currentWorkerNodeCount;
        @Generated
        private String[] planningWorkerNodes;
        @Generated
        private boolean deployToAllNodes;
        @Generated
        private Boolean isHidden;
        @Generated
        private Connector connector;
        @Generated
        private String connectorId;
        @Generated
        private Guardrails guardrails;
        @Generated
        private Map<String, String> modelInterface;
        @Generated
        private String tenantId;

        @Generated
        MLModelBuilder() {
        }

        @Generated
        public MLModelBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLModelBuilder modelGroupId(String modelGroupId) {
            this.modelGroupId = modelGroupId;
            return this;
        }

        @Generated
        public MLModelBuilder algorithm(FunctionName algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Generated
        public MLModelBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public MLModelBuilder content(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public MLModelBuilder user(User user) {
            this.user = user;
            return this;
        }

        @Generated
        public MLModelBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLModelBuilder modelFormat(MLModelFormat modelFormat) {
            this.modelFormat = modelFormat;
            return this;
        }

        @Generated
        public MLModelBuilder modelState(MLModelState modelState) {
            this.modelState = modelState;
            return this;
        }

        @Generated
        public MLModelBuilder modelContentSizeInBytes(Long modelContentSizeInBytes) {
            this.modelContentSizeInBytes = modelContentSizeInBytes;
            return this;
        }

        @Generated
        public MLModelBuilder modelContentHash(String modelContentHash) {
            this.modelContentHash = modelContentHash;
            return this;
        }

        @Generated
        public MLModelBuilder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        @Generated
        public MLModelBuilder isControllerEnabled(Boolean isControllerEnabled) {
            this.isControllerEnabled = isControllerEnabled;
            return this;
        }

        @Generated
        public MLModelBuilder rateLimiter(MLRateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return this;
        }

        @Generated
        public MLModelBuilder modelConfig(MLModelConfig modelConfig) {
            this.modelConfig = modelConfig;
            return this;
        }

        @Generated
        public MLModelBuilder deploySetting(MLDeploySetting deploySetting) {
            this.deploySetting = deploySetting;
            return this;
        }

        @Generated
        public MLModelBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public MLModelBuilder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public MLModelBuilder lastRegisteredTime(Instant lastRegisteredTime) {
            this.lastRegisteredTime = lastRegisteredTime;
            return this;
        }

        @Generated
        public MLModelBuilder lastDeployedTime(Instant lastDeployedTime) {
            this.lastDeployedTime = lastDeployedTime;
            return this;
        }

        @Generated
        public MLModelBuilder lastUndeployedTime(Instant lastUndeployedTime) {
            this.lastUndeployedTime = lastUndeployedTime;
            return this;
        }

        @Generated
        public MLModelBuilder autoRedeployRetryTimes(Integer autoRedeployRetryTimes) {
            this.autoRedeployRetryTimes = autoRedeployRetryTimes;
            return this;
        }

        @Generated
        public MLModelBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public MLModelBuilder chunkNumber(Integer chunkNumber) {
            this.chunkNumber = chunkNumber;
            return this;
        }

        @Generated
        public MLModelBuilder totalChunks(Integer totalChunks) {
            this.totalChunks = totalChunks;
            return this;
        }

        @Generated
        public MLModelBuilder planningWorkerNodeCount(Integer planningWorkerNodeCount) {
            this.planningWorkerNodeCount = planningWorkerNodeCount;
            return this;
        }

        @Generated
        public MLModelBuilder currentWorkerNodeCount(Integer currentWorkerNodeCount) {
            this.currentWorkerNodeCount = currentWorkerNodeCount;
            return this;
        }

        @Generated
        public MLModelBuilder planningWorkerNodes(String[] planningWorkerNodes) {
            this.planningWorkerNodes = planningWorkerNodes;
            return this;
        }

        @Generated
        public MLModelBuilder deployToAllNodes(boolean deployToAllNodes) {
            this.deployToAllNodes = deployToAllNodes;
            return this;
        }

        @Generated
        public MLModelBuilder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            return this;
        }

        @Generated
        public MLModelBuilder connector(Connector connector) {
            this.connector = connector;
            return this;
        }

        @Generated
        public MLModelBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public MLModelBuilder guardrails(Guardrails guardrails) {
            this.guardrails = guardrails;
            return this;
        }

        @Generated
        public MLModelBuilder modelInterface(Map<String, String> modelInterface) {
            this.modelInterface = modelInterface;
            return this;
        }

        @Generated
        public MLModelBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLModel build() {
            return new MLModel(this.name, this.modelGroupId, this.algorithm, this.version, this.content, this.user, this.description, this.modelFormat, this.modelState, this.modelContentSizeInBytes, this.modelContentHash, this.isEnabled, this.isControllerEnabled, this.rateLimiter, this.modelConfig, this.deploySetting, this.createdTime, this.lastUpdateTime, this.lastRegisteredTime, this.lastDeployedTime, this.lastUndeployedTime, this.autoRedeployRetryTimes, this.modelId, this.chunkNumber, this.totalChunks, this.planningWorkerNodeCount, this.currentWorkerNodeCount, this.planningWorkerNodes, this.deployToAllNodes, this.isHidden, this.connector, this.connectorId, this.guardrails, this.modelInterface, this.tenantId);
        }

        @Generated
        public String toString() {
            return "MLModel.MLModelBuilder(name=" + this.name + ", modelGroupId=" + this.modelGroupId + ", algorithm=" + String.valueOf((Object)this.algorithm) + ", version=" + this.version + ", content=" + this.content + ", user=" + String.valueOf(this.user) + ", description=" + this.description + ", modelFormat=" + String.valueOf((Object)this.modelFormat) + ", modelState=" + String.valueOf((Object)this.modelState) + ", modelContentSizeInBytes=" + this.modelContentSizeInBytes + ", modelContentHash=" + this.modelContentHash + ", isEnabled=" + this.isEnabled + ", isControllerEnabled=" + this.isControllerEnabled + ", rateLimiter=" + String.valueOf(this.rateLimiter) + ", modelConfig=" + String.valueOf(this.modelConfig) + ", deploySetting=" + String.valueOf(this.deploySetting) + ", createdTime=" + String.valueOf(this.createdTime) + ", lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + ", lastRegisteredTime=" + String.valueOf(this.lastRegisteredTime) + ", lastDeployedTime=" + String.valueOf(this.lastDeployedTime) + ", lastUndeployedTime=" + String.valueOf(this.lastUndeployedTime) + ", autoRedeployRetryTimes=" + this.autoRedeployRetryTimes + ", modelId=" + this.modelId + ", chunkNumber=" + this.chunkNumber + ", totalChunks=" + this.totalChunks + ", planningWorkerNodeCount=" + this.planningWorkerNodeCount + ", currentWorkerNodeCount=" + this.currentWorkerNodeCount + ", planningWorkerNodes=" + Arrays.deepToString(this.planningWorkerNodes) + ", deployToAllNodes=" + this.deployToAllNodes + ", isHidden=" + this.isHidden + ", connector=" + String.valueOf(this.connector) + ", connectorId=" + this.connectorId + ", guardrails=" + String.valueOf(this.guardrails) + ", modelInterface=" + String.valueOf(this.modelInterface) + ", tenantId=" + this.tenantId + ")";
        }
    }
}

