/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.implementation.util.ValidationUtil;

public class ManagedIdentityCredentialBuilder
extends CredentialBuilderBase<ManagedIdentityCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedIdentityCredentialBuilder.class);
    private String clientId;
    private String resourceId;
    private String objectId;

    public ManagedIdentityCredentialBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public ManagedIdentityCredentialBuilder resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public ManagedIdentityCredentialBuilder objectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    public ManagedIdentityCredential build() {
        ValidationUtil.validateManagedIdentityIdParams(this.clientId, this.resourceId, this.objectId, LOGGER);
        return new ManagedIdentityCredential(this.clientId, this.resourceId, this.objectId, this.identityClientOptions);
    }
}

