/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.state;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import org.opensearch.Version;
import org.opensearch.cluster.AbstractNamedDiffable;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.security.state.SecurityConfig;

public final class SecurityMetadata
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "security";
    private final Instant created;
    private final Set<SecurityConfig> configuration;

    public SecurityMetadata(Instant created, Set<SecurityConfig> configuration) {
        this.created = created;
        this.configuration = configuration;
    }

    public SecurityMetadata(StreamInput in) throws IOException {
        this.created = in.readInstant();
        this.configuration = in.readSet(SecurityConfig::new);
    }

    public Instant created() {
        return this.created;
    }

    public Set<SecurityConfig> configuration() {
        return this.configuration;
    }

    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public String getWriteableName() {
        return TYPE;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInstant(this.created);
        out.writeCollection(this.configuration);
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        xContentBuilder.field("created", DateTimeFormatter.ISO_INSTANT.format(this.created));
        xContentBuilder.startObject("configuration");
        for (SecurityConfig securityConfig : this.configuration) {
            securityConfig.toXContent(xContentBuilder, EMPTY_PARAMS);
        }
        return xContentBuilder.endObject();
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return SecurityMetadata.readDiffFrom(ClusterState.Custom.class, (String)TYPE, (StreamInput)in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SecurityMetadata that = (SecurityMetadata)((Object)o);
        return Objects.equals(this.created, that.created) && Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.configuration);
    }

    public static Builder from(SecurityMetadata securityMetadata) {
        return new Builder(securityMetadata);
    }

    public static final class Builder {
        private final Instant created;
        private final ImmutableSet.Builder<SecurityConfig> configuration = new ImmutableSortedSet.Builder(Comparator.comparing(SecurityConfig::type));

        Builder(SecurityMetadata oldMetadata) {
            this.created = oldMetadata.created;
            this.configuration.addAll(oldMetadata.configuration);
        }

        public Builder withSecurityConfig(SecurityConfig securityConfig) {
            this.configuration.add((Object)securityConfig);
            return this;
        }

        public SecurityMetadata build() {
            return new SecurityMetadata(this.created, (Set<SecurityConfig>)this.configuration.build());
        }
    }
}

