/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static void copyFileToDirectory(File file, File directory) throws IOException {
        FileUtils.copyFile(file, directory);
    }

    public static void copyFile(File inputFile, File outputFile) throws IOException {
        if (inputFile.isDirectory()) {
            throw new IOException("Cannot copy file: " + String.valueOf(inputFile) + " as this is a directory");
        }
        if (outputFile.isDirectory()) {
            outputFile = new File(outputFile, inputFile.getName());
        }
        outputFile.getParentFile().mkdirs();
        outputFile.createNewFile();
        FileInputStream in = new FileInputStream(inputFile);
        FileOutputStream out = new FileOutputStream(outputFile);
        FileChannel inc = in.getChannel();
        FileChannel outc = out.getChannel();
        inc.transferTo(0L, inc.size(), outc);
        inc.close();
        outc.close();
        in.close();
        out.close();
    }

    public static void showFile(File file) throws IOException {
        if (System.getProperty("os.name").contains("Mac")) {
            FileUtils.showInFinder(file);
        } else if (System.getProperty("os.name").contains("Windows")) {
            FileUtils.showInExplorer(file);
        } else {
            logger.debug("showFile not implemented for " + System.getProperty("os.name"));
        }
    }

    private static void showInFinder(File file) throws IOException {
        String[] params = new String[]{"osascript", "-e", "set p to \"" + file.getCanonicalPath() + "\"", "-e", "tell application \"Finder\"", "-e", "reveal (POSIX file p) as alias", "-e", "activate", "-e", "end tell"};
        Runtime.getRuntime().exec(params);
    }

    private static void showInExplorer(File file) throws IOException {
        Object path = file.getCanonicalPath();
        if (((String)path).contains(" ")) {
            path = "\"" + (String)path + "\"";
        }
        String[] params = new String[]{"explorer", "/n,/select," + (String)path};
        Runtime.getRuntime().exec(params);
    }

    public static void deleteRecursively(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                FileUtils.deleteRecursively(f);
            }
        }
        file.delete();
    }

    public static File createTempFile(File targetFile) throws IOException {
        String targetName = targetFile.getName();
        int extensionIndex = targetName.lastIndexOf(".");
        Object filename = targetName.substring(0, extensionIndex);
        for (int i = ((String)filename).length(); i < 3; ++i) {
            filename = (String)filename + "_";
        }
        return Files.createTempFile((String)filename, targetName.substring(extensionIndex), new FileAttribute[0]).toFile();
    }

    public static void showLogFile() {
        try {
            String userHome = System.getProperty("user.home");
            Path logFilePath = Paths.get(userHome, ".Protege", "logs", "protege.log");
            FileUtils.showFile(logFilePath.toFile());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "An error occurred whilst trying to show the log file: " + e.getMessage(), "Error", 0);
            logger.error("An error occurred whilst trying to show a file in the OS: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

