/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ActionType;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsExceptionsHotFixer;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.actions.DescindingFilesFilter;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.VcsStatisticsCollector;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateActionKt;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.update.RestoreUpdateTree;
import com.intellij.openapi.vcs.update.ScopeInfo;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdateOrStatusOptionsDialog;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.UpdatedFilesListener;
import com.intellij.openapi.vcs.update.UpdatedFilesReverseSide;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.OptionsDialog;
import com.intellij.vcs.VcsActivity;
import com.intellij.vcs.ViewUpdateInfoNotification;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0006\b&\u0018\u0000 .2\u00020\u0001:\u0002./B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\b\u0010\u0013\u001a\u00020\rH\u0014J6\u0010\u0014\u001a\u00020\r2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J#\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 J>\u0010!\u001a\u001e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00170\"j\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u0017`$2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016H\u0002J*\u0010%\u001a\u001e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00170\"j\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u0017`$2\u0006\u0010\u0011\u001a\u00020\u0012J5\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00162\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010(J)\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190*H\u0002\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\u0007H$J\u0010\u0010-\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/openapi/vcs/update/AbstractCommonUpdateAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "actionInfo", "Lcom/intellij/openapi/vcs/update/ActionInfo;", "scopeInfo", "Lcom/intellij/openapi/vcs/update/ScopeInfo;", "alwaysVisible", "", "<init>", "(Lcom/intellij/openapi/vcs/update/ActionInfo;Lcom/intellij/openapi/vcs/update/ScopeInfo;Z)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isShowOptions", "project", "Lcom/intellij/openapi/project/Project;", "onSuccess", "showOptionsDialog", "updateEnvToVirtualFiles", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "", "Lcom/intellij/openapi/vcs/FilePath;", "scopeName", "", "getRoots", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/actionSystem/DataContext;)[Lcom/intellij/openapi/vcs/FilePath;", "createConfigurableToEnvMap", "Ljava/util/LinkedHashMap;", "Lcom/intellij/openapi/options/Configurable;", "Lkotlin/collections/LinkedHashMap;", "getConfigurableToEnvMap", "createVcsToFilesMap", "roots", "([Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/project/Project;)Ljava/util/Map;", "filterRoots", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)[Lcom/intellij/openapi/vcs/FilePath;", "filterRootsBeforeAction", "update", "Companion", "Updater", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nAbstractCommonUpdateAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCommonUpdateAction.kt\ncom/intellij/openapi/vcs/update/AbstractCommonUpdateAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,615:1\n61#2,5:616\n61#2,5:621\n61#2,5:626\n37#3:631\n36#3,3:632\n*S KotlinDebug\n*F\n+ 1 AbstractCommonUpdateAction.kt\ncom/intellij/openapi/vcs/update/AbstractCommonUpdateAction\n*L\n74#1:616,5\n92#1:621,5\n140#1:626,5\n212#1:631\n212#1:632,3\n*E\n"})
public abstract class AbstractCommonUpdateAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActionInfo actionInfo;
    @NotNull
    private final ScopeInfo scopeInfo;
    private final boolean alwaysVisible;

    protected AbstractCommonUpdateAction(@NotNull ActionInfo actionInfo, @NotNull ScopeInfo scopeInfo, boolean alwaysVisible) {
        Intrinsics.checkNotNullParameter((Object)actionInfo, (String)"actionInfo");
        Intrinsics.checkNotNullParameter((Object)scopeInfo, (String)"scopeInfo");
        this.actionInfo = actionInfo;
        this.scopeInfo = scopeInfo;
        this.alwaysVisible = alwaysVisible;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        boolean showUpdateOptions = this.isShowOptions(project);
        Logger $this$debug_u24default$iv = AbstractCommonUpdateActionKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("project: " + project + ", show update options: " + showUpdateOptions, e$iv);
        }
        if (project == null) {
            return;
        }
        try {
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            FilePath[] roots = this.getRoots(project, dataContext);
            if (roots.length == 0) {
                AbstractCommonUpdateActionKt.access$getLOG$p().debug("No roots found.");
                return;
            }
            Map<AbstractVcs, Collection<FilePath>> vcsToVirtualFiles = this.createVcsToFilesMap(roots, project);
            for (AbstractVcs vcs : vcsToVirtualFiles.keySet()) {
                UpdateEnvironment updateEnvironment = this.actionInfo.getEnvironment(vcs);
                if (updateEnvironment == null || updateEnvironment.validateOptions(vcsToVirtualFiles.get(vcs))) continue;
                Logger $this$debug_u24default$iv2 = AbstractCommonUpdateActionKt.access$getLOG$p();
                Throwable e$iv2 = null;
                boolean $i$f$debug2 = false;
                if ($this$debug_u24default$iv2.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv2;
                    boolean bl = false;
                    logger.debug("Options not valid for files: " + vcsToVirtualFiles, e$iv2);
                }
                return;
            }
            if (showUpdateOptions || OptionsDialog.shiftIsPressed((int)e.getModifiers())) {
                String scopeName = this.scopeInfo.getScopeName(e.getDataContext(), this.actionInfo);
                this.showOptionsDialog(vcsToVirtualFiles, project, scopeName);
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                FileDocumentManager.getInstance().saveAllDocuments();
                StoreUtilKt.forPoorJavaClientOnlySaveProjectIndEdtDoNotUseThisMethod((Project)project, (boolean)false);
            }
            ActionInfo actionInfo = this.actionInfo;
            String string = this.getTemplatePresentation().getText();
            Updater task2 = new Updater(project, roots, vcsToVirtualFiles, this, actionInfo, string){
                final /* synthetic */ AbstractCommonUpdateAction this$0;
                {
                    this.this$0 = $receiver;
                    Intrinsics.checkNotNull((Object)$super_call_param$2);
                    super($project, $roots, $vcsToVirtualFiles, $super_call_param$1, $super_call_param$2);
                }

                public void onSuccess() {
                    super.onSuccess();
                    this.this$0.onSuccess();
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                task2.run((ProgressIndicator)new EmptyProgressIndicator());
            } else {
                ProgressManager.getInstance().run((Task)task2);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    protected boolean isShowOptions(@Nullable Project project) {
        return this.actionInfo.showOptions(project);
    }

    protected void onSuccess() {
    }

    private final void showOptionsDialog(Map<AbstractVcs, ? extends Collection<? extends FilePath>> updateEnvToVirtualFiles, Project project, String scopeName) {
        UpdateOrStatusOptionsDialog dialogOrStatus;
        LinkedHashMap<Configurable, AbstractVcs> envToConfMap = this.createConfigurableToEnvMap(updateEnvToVirtualFiles);
        Logger $this$debug_u24default$iv = AbstractCommonUpdateActionKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("configurables map: " + envToConfMap, e$iv);
        }
        if (!envToConfMap.isEmpty() && !(dialogOrStatus = this.actionInfo.createOptionsDialog(project, envToConfMap, scopeName)).showAndGet()) {
            throw new ProcessCanceledException();
        }
    }

    private final FilePath[] getRoots(Project project, DataContext context) {
        List<FilePath> filePaths = this.scopeInfo.getRoots(context, this.actionInfo);
        Intrinsics.checkNotNull(filePaths);
        FilePath[] filePathArray = DescindingFilesFilter.filterDescindingFiles(this.filterRoots(project, filePaths), project);
        Intrinsics.checkNotNullExpressionValue((Object)filePathArray, (String)"filterDescindingFiles(...)");
        return filePathArray;
    }

    private final LinkedHashMap<Configurable, AbstractVcs> createConfigurableToEnvMap(Map<AbstractVcs, ? extends Collection<? extends FilePath>> updateEnvToVirtualFiles) {
        LinkedHashMap<Configurable, AbstractVcs> envToConfMap = new LinkedHashMap<Configurable, AbstractVcs>();
        for (AbstractVcs vcs : updateEnvToVirtualFiles.keySet()) {
            Configurable configurable = this.actionInfo.getEnvironment(vcs).createConfigurable(updateEnvToVirtualFiles.get(vcs));
            if (configurable == null) continue;
            envToConfMap.put(configurable, vcs);
        }
        return envToConfMap;
    }

    @NotNull
    public final LinkedHashMap<Configurable, AbstractVcs> getConfigurableToEnvMap(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getProjectContext(...)");
        FilePath[] roots = this.getRoots(project, dataContext);
        Map<AbstractVcs, Collection<FilePath>> vcsToFilesMap = this.createVcsToFilesMap(roots, project);
        return this.createConfigurableToEnvMap(vcsToFilesMap);
    }

    private final Map<AbstractVcs, Collection<FilePath>> createVcsToFilesMap(FilePath[] roots, Project project) {
        AbstractVcs vcs;
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet(...)");
        MultiMap resultPrep = multiMap;
        for (FilePath file : roots) {
            UpdateEnvironment updateEnvironment;
            if (VcsUtil.getVcsFor((Project)project, (FilePath)file) == null || (updateEnvironment = this.actionInfo.getEnvironment(vcs)) == null) continue;
            resultPrep.putValue((Object)vcs, (Object)file);
        }
        HashMap<AbstractVcs, List> result2 = new HashMap<AbstractVcs, List>();
        for (Map.Entry entry : resultPrep.entrySet()) {
            vcs = (AbstractVcs)entry.getKey();
            result2.put(vcs, vcs.filterUniqueRoots((List)new ArrayList((Collection)entry.getValue()), arg_0 -> AbstractCommonUpdateAction.createVcsToFilesMap$lambda$4(AbstractCommonUpdateAction::createVcsToFilesMap$lambda$3, arg_0)));
        }
        return result2;
    }

    private final FilePath[] filterRoots(Project project, List<FilePath> roots) {
        ArrayList<FilePath> result2 = new ArrayList<FilePath>();
        for (FilePath file : roots) {
            if (VcsUtil.getVcsFor((Project)project, (FilePath)file) == null) continue;
            if (!this.scopeInfo.filterExistsInVcs() || AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)file)) {
                AbstractVcs vcs;
                UpdateEnvironment updateEnvironment = this.actionInfo.getEnvironment(vcs);
                if (updateEnvironment == null) continue;
                result2.add(file);
                continue;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null || !virtualFile.isDirectory()) continue;
            Object[] vcsRoots = ProjectLevelVcsManager.getInstance((Project)project).getAllVersionedRoots();
            Iterator iterator = ArrayIteratorKt.iterator((Object[])vcsRoots);
            while (iterator.hasNext()) {
                VirtualFile vcsRoot = (VirtualFile)iterator.next();
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)vcsRoot, (boolean)false)) continue;
                result2.add(file);
            }
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FilePath[0]);
    }

    protected abstract boolean filterRootsBeforeAction();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Project project = e.getProject();
        if (project == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        boolean underVcs = vcsManager.hasActiveVcss();
        if (!underVcs) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        String scopeName = this.scopeInfo.getScopeName(e.getDataContext(), this.actionInfo);
        Object actionName = this.actionInfo.getActionName(scopeName);
        if (this.actionInfo.showOptions(project) || OptionsDialog.shiftIsPressed((int)e.getModifiers())) {
            actionName = (String)actionName + "...";
        }
        presentation2.setText((String)actionName);
        Intrinsics.checkNotNull((Object)vcsManager);
        if (AbstractCommonUpdateActionKt.access$supportingVcsesAreEmpty(vcsManager, this.actionInfo)) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        if (this.filterRootsBeforeAction()) {
            List<FilePath> filePaths = this.scopeInfo.getRoots(e.getDataContext(), this.actionInfo);
            Intrinsics.checkNotNull(filePaths);
            FilePath[] roots = this.filterRoots(project, filePaths);
            if (roots.length == 0) {
                presentation2.setVisible(this.alwaysVisible);
                presentation2.setEnabled(false);
                return;
            }
        }
        AbstractVcs singleVcs = vcsManager.getSingleVCS();
        presentation2.setVisible(true);
        presentation2.setEnabled(!vcsManager.isBackgroundVcsOperationRunning() && (singleVcs == null || !singleVcs.isUpdateActionDisabled()));
    }

    private static final VirtualFile createVcsToFilesMap$lambda$3(FilePath it) {
        return it.getVirtualFile();
    }

    private static final VirtualFile createVcsToFilesMap$lambda$4(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }

    @JvmStatic
    public static final boolean showsCustomNotification(@NotNull Collection<? extends AbstractVcs> vcss) {
        return Companion.showsCustomNotification(vcss);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Companion;", "", "<init>", "()V", "showsCustomNotification", "", "vcss", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nAbstractCommonUpdateAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCommonUpdateAction.kt\ncom/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,615:1\n1740#2,3:616\n*S KotlinDebug\n*F\n+ 1 AbstractCommonUpdateAction.kt\ncom/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Companion\n*L\n60#1:616,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean showsCustomNotification(@NotNull Collection<? extends AbstractVcs> vcss) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(vcss, (String)"vcss");
                Iterable $this$all$iv = vcss;
                boolean $i$f$all = false;
                if (((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        AbstractVcs vcs = (AbstractVcs)element$iv;
                        boolean bl2 = false;
                        UpdateEnvironment environment = vcs.getUpdateEnvironment();
                        if (environment != null && environment.hasCustomNotification()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0010\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u0002042\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000204H\u0002J6\u00109\u001a\u00020%2\b\u0010:\u001a\u0004\u0018\u0001072\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020*0?H\u0014J\u001e\u0010@\u001a\u0002042\u0006\u0010A\u001a\u00020\t2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\"\u0010C\u001a\u0002042\u0018\u0010D\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0E0\bH\u0002J \u0010C\u001a\u0002042\b\u0010F\u001a\u0004\u0018\u00010\u001f2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020!0EH\u0002J\b\u0010H\u001a\u000204H\u0002J\b\u0010I\u001a\u000204H\u0002J&\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0EH\u0002J\b\u0010P\u001a\u000204H\u0016J\u0010\u0010Q\u001a\u0002042\u0006\u0010R\u001a\u00020OH\u0002J\b\u0010S\u001a\u000204H\u0002J\b\u0010T\u001a\u000204H\u0002J\u0018\u0010U\u001a\u00020M2\u0006\u0010V\u001a\u00020O2\u0006\u0010R\u001a\u00020OH\u0002J\u0016\u0010W\u001a\u00020O2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\t0YH\u0002J\b\u0010Z\u001a\u000204H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR:\u0010\u001d\u001a.\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001ej\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 `\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u0012\u0012\u0004\u0012\u00020%0$j\b\u0012\u0004\u0012\u00020%`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010)\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010*0\u001ej\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010*`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010+\u001a\u00070,\u00a2\u0006\u0002\b-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vcs/FilePath;", "vcsToVirtualFiles", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "", "actionInfo", "Lcom/intellij/openapi/vcs/update/ActionInfo;", "actionName", "", "Lorg/jetbrains/annotations/Nls;", "Lcom/intellij/openapi/util/NlsContexts$ProgressTitle;", "<init>", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vcs/FilePath;Ljava/util/Map;Lcom/intellij/openapi/vcs/update/ActionInfo;Ljava/lang/String;)V", "[Lcom/intellij/openapi/vcs/FilePath;", "projectLevelVcsManager", "Lcom/intellij/openapi/vcs/ex/ProjectLevelVcsManagerEx;", "kotlin.jvm.PlatformType", "updatedFiles", "Lcom/intellij/openapi/vcs/update/UpdatedFiles;", "getUpdatedFiles", "()Lcom/intellij/openapi/vcs/update/UpdatedFiles;", "setUpdatedFiles", "(Lcom/intellij/openapi/vcs/update/UpdatedFiles;)V", "groupedExceptions", "Ljava/util/HashMap;", "Lcom/intellij/ide/errorTreeView/HotfixData;", "", "Lcom/intellij/openapi/vcs/VcsException;", "Lkotlin/collections/HashMap;", "updateSessions", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/vcs/update/UpdateSession;", "Lkotlin/collections/ArrayList;", "updateNumber", "", "contextInfo", "Lcom/intellij/openapi/vcs/update/SequentialUpdatesContext;", "dirtyScopeManager", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeManager;", "Lorg/jetbrains/annotations/NotNull;", "before", "Lcom/intellij/history/Label;", "after", "localHistoryAction", "Lcom/intellij/history/LocalHistoryAction;", "reset", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runImpl", "performUpdate", "progressIndicator", "updateEnvironment", "Lcom/intellij/openapi/vcs/update/UpdateEnvironment;", "files", "refContext", "Lcom/intellij/openapi/util/Ref;", "gatherExceptions", "vcs", "exceptionList", "putExceptions", "map", "", "key", "list", "doVfsRefresh", "notifyAnnotations", "prepareNotification", "Lcom/intellij/notification/Notification;", "tree", "Lcom/intellij/openapi/vcs/update/UpdateInfoTree;", "someSessionWasCancelled", "", "onSuccess", "onSuccessImpl", "wasCanceled", "showContextInterruptedError", "gatherContextInterruptedMessages", "showUpdateTree", "willBeContinued", "canGroupByChangelist", "abstractVcses", "", "onCancel", "intellij.platform.vcs.impl"})
    @ApiStatus.Internal
    @SourceDebugExtension(value={"SMAP\nAbstractCommonUpdateAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCommonUpdateAction.kt\ncom/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,615:1\n37#2:616\n36#2,3:617\n1#3:620\n*S KotlinDebug\n*F\n+ 1 AbstractCommonUpdateAction.kt\ncom/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater\n*L\n352#1:616\n352#1:617,3\n*E\n"})
    public static class Updater
    extends Task.Backgroundable {
        @NotNull
        private final FilePath[] roots;
        @NotNull
        private final Map<AbstractVcs, Collection<FilePath>> vcsToVirtualFiles;
        @NotNull
        private final ActionInfo actionInfo;
        @NotNull
        private final String actionName;
        private final ProjectLevelVcsManagerEx projectLevelVcsManager;
        @NotNull
        private UpdatedFiles updatedFiles;
        @NotNull
        private final HashMap<HotfixData, List<VcsException>> groupedExceptions;
        @NotNull
        private final ArrayList<UpdateSession> updateSessions;
        private int updateNumber;
        @NotNull
        private final HashMap<AbstractVcs, SequentialUpdatesContext> contextInfo;
        @NotNull
        private final VcsDirtyScopeManager dirtyScopeManager;
        @Nullable
        private Label before;
        @Nullable
        private Label after;
        @Nullable
        private LocalHistoryAction localHistoryAction;

        public Updater(@NotNull Project project, @NotNull FilePath[] roots, @NotNull Map<AbstractVcs, ? extends Collection<? extends FilePath>> vcsToVirtualFiles, @NotNull ActionInfo actionInfo, @NotNull String actionName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
            Intrinsics.checkNotNullParameter(vcsToVirtualFiles, (String)"vcsToVirtualFiles");
            Intrinsics.checkNotNullParameter((Object)actionInfo, (String)"actionInfo");
            Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
            super(project, actionName, true);
            this.roots = roots;
            this.vcsToVirtualFiles = vcsToVirtualFiles;
            this.actionInfo = actionInfo;
            this.actionName = actionName;
            this.projectLevelVcsManager = ProjectLevelVcsManagerEx.getInstanceEx(project);
            this.updatedFiles = UpdatedFiles.Companion.create();
            this.groupedExceptions = new HashMap();
            this.updateSessions = new ArrayList();
            this.updateNumber = 1;
            this.contextInfo = new HashMap();
            Project project2 = this.myProject;
            Intrinsics.checkNotNull((Object)project2);
            VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)vcsDirtyScopeManager, (String)"getInstance(...)");
            this.dirtyScopeManager = vcsDirtyScopeManager;
        }

        @NotNull
        protected final UpdatedFiles getUpdatedFiles() {
            return this.updatedFiles;
        }

        protected final void setUpdatedFiles(@NotNull UpdatedFiles updatedFiles) {
            Intrinsics.checkNotNullParameter((Object)updatedFiles, (String)"<set-?>");
            this.updatedFiles = updatedFiles;
        }

        private final void reset() {
            this.updatedFiles = UpdatedFiles.Companion.create();
            this.groupedExceptions.clear();
            this.updateSessions.clear();
            ++this.updateNumber;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.runImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void runImpl() {
            Project project = this.myProject;
            if (project != null) {
                StoreReloadManager.Companion.getInstance(project).blockReloadingProjectOnExternalChanges();
            }
            this.projectLevelVcsManager.startBackgroundVcsOperation();
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            LocalHistory localHistory = LocalHistory.Companion.getInstance();
            Project project2 = project;
            Intrinsics.checkNotNull((Object)project2);
            String string = VcsBundle.message((String)"update.label.before.update", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.before = localHistory.putSystemLabel(project2, string);
            this.localHistoryAction = LocalHistory.Companion.getInstance().startAction(VcsBundle.message((String)"activity.name.update", (Object[])new Object[0]), VcsActivity.Update);
            ProgressIndicator progressIndicator2 = progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setIndeterminate(false);
            }
            StructuredIdeActivity activity = IdeActivityDefinition.started$default((IdeActivityDefinition)VcsStatisticsCollector.UPDATE_ACTIVITY, (Project)project, null, (int)2, null);
            try {
                int toBeProcessed = this.vcsToVirtualFiles.size();
                int processed = 0;
                for (AbstractVcs vcs : this.vcsToVirtualFiles.keySet()) {
                    List exceptionList;
                    Collection<FilePath> files;
                    UpdateEnvironment updateEnvironment = this.actionInfo.getEnvironment(vcs);
                    updateEnvironment.fillGroups(this.updatedFiles);
                    Intrinsics.checkNotNull(this.vcsToVirtualFiles.get(vcs));
                    SequentialUpdatesContext context = this.contextInfo.get(vcs);
                    Ref refContext = new Ref((Object)context);
                    Intrinsics.checkNotNull((Object)updateEnvironment);
                    UpdateSession updateSession = this.performUpdate(progressIndicator, updateEnvironment, files, (Ref<SequentialUpdatesContext>)refContext);
                    this.contextInfo.put(vcs, (SequentialUpdatesContext)refContext.get());
                    ++processed;
                    if (progressIndicator != null) {
                        progressIndicator.setFraction((double)processed / (double)toBeProcessed);
                        progressIndicator.setText2("");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)updateSession.getExceptions(), (String)"getExceptions(...)");
                    this.gatherExceptions(vcs, exceptionList);
                    this.updateSessions.add(updateSession);
                }
            }
            finally {
                try {
                    ProgressManager.progress((String)VcsBundle.message((String)"progress.text.synchronizing.files", (Object[])new Object[0]));
                    this.doVfsRefresh();
                }
                finally {
                    this.projectLevelVcsManager.stopBackgroundVcsOperation();
                    MessageBus messageBus = project.getMessageBus();
                    Topic<UpdatedFilesListener> topic = UpdatedFilesListener.UPDATED_FILES;
                    Intrinsics.checkNotNullExpressionValue(topic, (String)"UPDATED_FILES");
                    ((UpdatedFilesListener)messageBus.syncPublisher(topic)).consume(UpdatedFilesReverseSide.getPathsFromUpdatedFiles((UpdatedFiles)this.updatedFiles));
                    StructuredIdeActivity.finished$default((StructuredIdeActivity)activity, null, (int)1, null);
                }
            }
        }

        @NotNull
        protected UpdateSession performUpdate(@Nullable ProgressIndicator progressIndicator, @NotNull UpdateEnvironment updateEnvironment, @NotNull Collection<? extends FilePath> files, @NotNull Ref<SequentialUpdatesContext> refContext) {
            Intrinsics.checkNotNullParameter((Object)updateEnvironment, (String)"updateEnvironment");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter(refContext, (String)"refContext");
            Collection<? extends FilePath> $this$toTypedArray$iv = files;
            boolean $i$f$toTypedArray = false;
            Collection<? extends FilePath> thisCollection$iv = $this$toTypedArray$iv;
            UpdateSession updateSession = updateEnvironment.updateDirectories(thisCollection$iv.toArray(new FilePath[0]), this.updatedFiles, progressIndicator, refContext);
            Intrinsics.checkNotNullExpressionValue((Object)updateSession, (String)"updateDirectories(...)");
            return updateSession;
        }

        private final void gatherExceptions(AbstractVcs vcs, List<VcsException> exceptionList) {
            VcsExceptionsHotFixer fixer = vcs.getVcsExceptionsHotFixer();
            if (fixer == null) {
                this.putExceptions(null, exceptionList);
            } else {
                Map map = fixer.groupExceptions(ActionType.update, exceptionList);
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"groupExceptions(...)");
                this.putExceptions(map);
            }
        }

        private final void putExceptions(Map<HotfixData, ? extends List<? extends VcsException>> map) {
            for (Map.Entry<HotfixData, ? extends List<? extends VcsException>> entry : map.entrySet()) {
                this.putExceptions(entry.getKey(), entry.getValue());
            }
        }

        private final void putExceptions(HotfixData key, List<? extends VcsException> list) {
            if (list.isEmpty()) {
                return;
            }
            this.groupedExceptions.computeIfAbsent(key, arg_0 -> Updater.putExceptions$lambda$1(Updater::putExceptions$lambda$0, arg_0)).addAll((Collection)list);
        }

        private final void doVfsRefresh() {
            Logger logger = AbstractCommonUpdateActionKt.access$getLOG$p();
            String string = Arrays.toString(this.roots);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            logger.info("Calling refresh files after update for roots: " + string);
            RefreshVFsSynchronously.INSTANCE.updateAllChanged(this.updatedFiles);
            this.notifyAnnotations();
        }

        private final void notifyAnnotations() {
            Project project = this.myProject;
            Intrinsics.checkNotNull((Object)project);
            MessageBus messageBus = project.getMessageBus();
            Topic<VcsAnnotationRefresher> topic = VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"LOCAL_CHANGES_CHANGED");
            VcsAnnotationRefresher refresher = (VcsAnnotationRefresher)messageBus.syncPublisher(topic);
            UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(this.updatedFiles, (arg_0, arg_1) -> Updater.notifyAnnotations$lambda$2(refresher, arg_0, arg_1));
        }

        /*
         * WARNING - void declaration
         */
        private final Notification prepareNotification(UpdateInfoTree tree, boolean someSessionWasCancelled, List<? extends UpdateSession> updateSessions) {
            HtmlChunk htmlChunk;
            Object[] objectArray;
            String string;
            Iterable iterable = this.updatedFiles.getTopLevelGroups();
            int n = 0;
            for (Object t : iterable) {
                void it;
                FileGroup fileGroup = (FileGroup)t;
                int n2 = n;
                boolean bl = false;
                int n3 = AbstractCommonUpdateActionKt.access$getFilesCount((FileGroup)it);
                n = n2 + n3;
            }
            int allFilesCount = n;
            if (someSessionWasCancelled) {
                string = VcsBundle.message((String)"update.notification.title.project.partially.updated", (Object[])new Object[0]);
            } else {
                objectArray = new Object[]{allFilesCount};
                string = VcsBundle.message((String)"update.notification.title.count.files.updated", (Object[])objectArray);
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String title = string2;
            HtmlBuilder content = new HtmlBuilder();
            if (someSessionWasCancelled) {
                objectArray = new Object[]{allFilesCount};
                htmlChunk = HtmlChunk.text((String)VcsBundle.message((String)"update.notification.content.files.updated", (Object[])objectArray));
            } else {
                htmlChunk = AbstractCommonUpdateActionKt.access$prepareScopeUpdatedText(tree);
            }
            content.append(htmlChunk);
            List additionalContent = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)updateSessions), Updater::prepareNotification$lambda$4)), Updater::prepareNotification$lambda$5));
            if (!additionalContent.isEmpty()) {
                if (!content.isEmpty()) {
                    content.append((HtmlChunk)HtmlChunk.br());
                }
                content.appendWithSeparators(HtmlChunk.text((String)", "), (Iterable)additionalContent);
            }
            NotificationType type = someSessionWasCancelled ? NotificationType.WARNING : NotificationType.INFORMATION;
            NotificationGroup notificationGroup = VcsNotifier.standardNotification();
            String string3 = content.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            Notification notification = notificationGroup.createNotification(title, string3, type).setDisplayId("vcs.project.partially.updated");
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setDisplayId(...)");
            return notification;
        }

        public void onSuccess() {
            this.onSuccessImpl(false);
        }

        private final void onSuccessImpl(boolean wasCanceled) {
            boolean updateSuccess;
            Object[] revisionsCache;
            Project project = this.myProject;
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            if (!project2.isOpen() || project2.isDisposed()) {
                LocalHistory localHistory = LocalHistory.Companion.getInstance();
                String string = VcsBundle.message((String)"activity.name.update", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                localHistory.putSystemLabel(project2, string);
                return;
            }
            boolean continueChain = false;
            for (SequentialUpdatesContext context : this.contextInfo.values()) {
                continueChain |= context != null && context.shouldFail();
            }
            boolean continueChainFinal = continueChain;
            boolean someSessionWasCancelled = wasCanceled || AbstractCommonUpdateActionKt.access$someSessionWasCanceled(this.updateSessions);
            Iterator<UpdateSession> iterator = this.updateSessions.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<UpdateSession> iterator2 = iterator;
            while (iterator2.hasNext()) {
                UpdateSession updateSession;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                updateSession.onRefreshFilesCompleted();
            }
            LocalHistoryAction localHistoryAction = this.localHistoryAction;
            if (localHistoryAction != null) {
                localHistoryAction.finish();
            }
            LocalHistory localHistory = LocalHistory.Companion.getInstance();
            String string = VcsBundle.message((String)"update.label.after.update", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.after = localHistory.putSystemLabel(project2, string);
            if (this.actionInfo.canChangeFileStatus()) {
                ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
                revisionsCache = RemoteRevisionsCache.getInstance(project2);
                revisionsCache.invalidate(this.updatedFiles);
                UpdateFilesHelper.iterateFileGroupFiles(this.updatedFiles, new UpdateFilesHelper.Callback(files){
                    final /* synthetic */ ArrayList<VirtualFile> $files;
                    {
                        this.$files = $files;
                    }

                    public void onFile(String filePath, String groupId) {
                        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                        String string = VfsUtilCore.pathToUrl((String)StringsKt.replace$default((String)filePath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathToUrl(...)");
                        String path = string;
                        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(path);
                        if (virtualFile == null) {
                            return;
                        }
                        VirtualFile file = virtualFile;
                        this.$files.add(file);
                    }
                });
                this.dirtyScopeManager.filesDirty((Collection)files, null);
            }
            boolean bl = updateSuccess = !someSessionWasCancelled && this.groupedExceptions.isEmpty();
            if (project2.isDisposed()) {
                StoreReloadManager.Companion.getInstance(project2).unblockReloadingProjectOnExternalChanges();
                return;
            }
            if (!this.groupedExceptions.isEmpty()) {
                if (continueChainFinal) {
                    this.gatherContextInterruptedMessages();
                }
                revisionsCache = new Object[]{this.actionName};
                AbstractVcsHelper.getInstance((Project)project2).showErrors((Map)this.groupedExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])revisionsCache));
            } else if (someSessionWasCancelled) {
                ProgressManager.progress((String)VcsBundle.message((String)"progress.text.updating.canceled", (Object[])new Object[0]));
            } else {
                ProgressManager.progress((String)VcsBundle.message((String)"progress.text.updating.done", (Object[])new Object[0]));
            }
            FileGroup fileGroup = this.updatedFiles.getGroupById("MERGED_WITH_CONFLICTS");
            Intrinsics.checkNotNull((Object)fileGroup);
            boolean noMerged = fileGroup.isEmpty();
            if (this.updatedFiles.isEmpty() && this.groupedExceptions.isEmpty()) {
                NotificationType type = null;
                String content = null;
                if (someSessionWasCancelled) {
                    content = VcsBundle.message((String)"progress.text.updating.canceled", (Object[])new Object[0]);
                    type = NotificationType.WARNING;
                } else {
                    content = AbstractCommonUpdateActionKt.access$getAllFilesAreUpToDateMessage(this.roots);
                    type = NotificationType.INFORMATION;
                }
                VcsNotifier.getInstance(project2).notify(VcsNotifier.standardNotification().createNotification(content, type).setDisplayId("vcs.project.update.finished"));
            } else if (!this.updatedFiles.isEmpty()) {
                if (this.updateSessions.size() == 1 && Companion.showsCustomNotification((Collection<? extends AbstractVcs>)this.vcsToVirtualFiles.keySet())) {
                    this.updateSessions.get(0).showNotification();
                } else {
                    UpdateInfoTree tree = this.showUpdateTree(continueChainFinal && updateSuccess && noMerged, someSessionWasCancelled);
                    CommittedChangesCache cache = CommittedChangesCache.getInstance(project2);
                    cache.processUpdatedFiles(this.updatedFiles, (Consumer<? super List<CommittedChangeList>>)((Consumer)arg_0 -> Updater.onSuccessImpl$lambda$7(arg_0 -> Updater.onSuccessImpl$lambda$6(tree, arg_0), arg_0)));
                    Notification notification = this.prepareNotification(tree, someSessionWasCancelled, (List<? extends UpdateSession>)this.updateSessions);
                    notification.addAction((AnAction)new ViewUpdateInfoNotification(project2, tree, VcsBundle.message((String)"update.notification.content.view", (Object[])new Object[0]), notification));
                    Notification notification2 = VcsNotifier.getInstance(project2).notify(notification);
                    Intrinsics.checkNotNull((Object)notification2);
                }
            }
            StoreReloadManager.Companion.getInstance(project2).unblockReloadingProjectOnExternalChanges();
            if (continueChainFinal && updateSuccess) {
                if (noMerged) {
                    this.reset();
                    ProgressManager.getInstance().run((Task)this);
                } else {
                    this.showContextInterruptedError();
                }
            }
        }

        private final void showContextInterruptedError() {
            this.gatherContextInterruptedMessages();
            Object[] objectArray = new Object[]{this.actionName};
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors((Map)this.groupedExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])objectArray));
        }

        private final void gatherContextInterruptedMessages() {
            Iterator<Map.Entry<AbstractVcs, SequentialUpdatesContext>> iterator = this.contextInfo.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<AbstractVcs, SequentialUpdatesContext> entry;
                Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
                SequentialUpdatesContext context = entry.getValue();
                if (context == null || !context.shouldFail()) continue;
                VcsException exception = new VcsException(context.getMessageWhenInterruptedBeforeStart());
                AbstractVcs abstractVcs = entry.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)abstractVcs, (String)"<get-key>(...)");
                VcsException[] vcsExceptionArray = new VcsException[]{exception};
                this.gatherExceptions(abstractVcs, CollectionsKt.mutableListOf((Object[])vcsExceptionArray));
            }
        }

        private final UpdateInfoTree showUpdateTree(boolean willBeContinued, boolean wasCanceled) {
            Project project = this.myProject;
            Intrinsics.checkNotNull((Object)project);
            RestoreUpdateTree restoreUpdateTree = RestoreUpdateTree.Companion.getInstance(project);
            restoreUpdateTree.registerUpdateInformation(this.updatedFiles, this.actionInfo);
            String text = this.actionName + (String)(willBeContinued || this.updateNumber > 1 ? "#" + this.updateNumber : "");
            UpdateInfoTree updateInfoTree = this.projectLevelVcsManager.showUpdateProjectInfo(this.updatedFiles, text, this.actionInfo, wasCanceled);
            Intrinsics.checkNotNull((Object)((Object)updateInfoTree));
            UpdateInfoTree updateInfoTree2 = updateInfoTree;
            updateInfoTree2.setBefore(this.before);
            updateInfoTree2.setAfter(this.after);
            updateInfoTree2.setCanGroupByChangeList(this.canGroupByChangelist(this.vcsToVirtualFiles.keySet()));
            return updateInfoTree2;
        }

        private final boolean canGroupByChangelist(Set<? extends AbstractVcs> abstractVcses) {
            if (this.actionInfo.canGroupByChangelist()) {
                for (AbstractVcs abstractVcs : abstractVcses) {
                    if (abstractVcs.getCachingCommittedChangesProvider() == null) continue;
                    return true;
                }
            }
            return false;
        }

        public void onCancel() {
            this.onSuccessImpl(true);
        }

        private static final List putExceptions$lambda$0(HotfixData it) {
            return new ArrayList();
        }

        private static final List putExceptions$lambda$1(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }

        private static final void notifyAnnotations$lambda$2(VcsAnnotationRefresher $refresher, String filePath, String string) {
            $refresher.dirty(filePath);
        }

        private static final String prepareNotification$lambda$4(UpdateSession it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getAdditionalNotificationContent();
        }

        private static final HtmlChunk prepareNotification$lambda$5(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return HtmlChunk.raw((String)it);
        }

        private static final Unit onSuccessImpl$lambda$6(UpdateInfoTree $tree, List it) {
            $tree.setChangeLists(it);
            return Unit.INSTANCE;
        }

        private static final void onSuccessImpl$lambda$7(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }
}

