/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;

public class ScaleInterpolator
extends TransformInterpolator {
    float minimumScale;
    float maximumScale;
    private Transform3D scale = new Transform3D();
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    ScaleInterpolator() {
    }

    public ScaleInterpolator(Alpha alpha, TransformGroup transformGroup) {
        super(alpha, transformGroup);
        this.minimumScale = 0.1f;
        this.maximumScale = 1.0f;
    }

    public ScaleInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float f, float f2) {
        super(alpha, transformGroup, transform3D);
        this.minimumScale = f;
        this.maximumScale = f2;
    }

    public void setMinimumScale(float f) {
        this.minimumScale = f;
    }

    public float getMinimumScale() {
        return this.minimumScale;
    }

    public void setMaximumScale(float f) {
        this.maximumScale = f;
    }

    public float getMaximumScale() {
        return this.maximumScale;
    }

    public void setAxisOfScale(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfScale() {
        return this.getTransformAxis();
    }

    @Override
    public void computeTransform(float f, Transform3D transform3D) {
        double d = (1.0 - (double)f) * (double)this.minimumScale + (double)(f * this.maximumScale);
        this.scale.set(d);
        transform3D.mul(this.axis, this.scale);
        transform3D.mul(transform3D, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean bl) {
        ScaleInterpolator scaleInterpolator = new ScaleInterpolator();
        scaleInterpolator.duplicateNode(this, bl);
        return scaleInterpolator;
    }

    @Override
    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        ScaleInterpolator scaleInterpolator = (ScaleInterpolator)node;
        this.setMinimumScale(scaleInterpolator.getMinimumScale());
        this.setMaximumScale(scaleInterpolator.getMaximumScale());
    }
}

