# (c) Copyright 2022. CodeWeavers, Inc.

from gi.repository import GLib
from gi.repository import Gtk

import bottlecollection
import cxguitools
import iconview


class ApplicationsViewController(iconview.IconViewController):

    def __init__(self, parent_window):
        iconview.IconViewController.__init__(self)

        self.xml = Gtk.Builder()
        self.xml.set_translation_domain('crossover')
        self.xml.add_from_file(cxguitools.get_ui_path('applicationsview'))
        self.xml.connect_signals(self)

        self.parent_window = parent_window
        self.bottle = None

        self.xml.get_object('IconView').set_model(self.launcher_list_store)
        self.setup_icon_view(self.xml.get_object('IconView'), True)

        self.bottles = bottlecollection.sharedCollection(('basic',))
        self.bottles.addChangeDelegate(self)
        self.bottles.addBottleChangeDelegate(self)

        self.update_launchers()

    def get_view(self):
        return self.xml.get_object('ApplicationsView')

    def get_icon_view(self):
        return self.xml.get_object('IconView')

    def can_use_bottle(self, bottle_name):
        try:
            bottle = self.bottles.bottleObject(bottle_name)
        except KeyError:
            return False
        else:
            return bottle.is_usable

        return True

    def update_launchers_for_bottle(self, bottle_name):
        if not self.can_use_bottle(bottle_name):
            return

        self.launchers[bottle_name] = {}
        new_launchers = self.launchers_for_bottle(bottle_name, False)
        for key, launcher in new_launchers.items():
            if key not in self.hidden_launchers:
                self.launchers[bottle_name][key] = launcher

        launchers = {}
        for new_launchers in self.launchers.values():
            launchers.update(new_launchers)

        self.set_launchers(launchers)

    def update_launchers(self):
        self.launchers = {}
        launchers = {}
        bottles = self.bottles.bottleList()

        for bottle_name in bottles:
            if not self.can_use_bottle(bottle_name):
                continue

            self.launchers[bottle_name] = {}
            new_launchers = self.launchers_for_bottle(bottle_name, False)
            for key, launcher in new_launchers.items():
                if key not in self.hidden_launchers:
                    self.launchers[bottle_name][key] = launcher
                    launchers[key] = launcher

        self.update_observed_bottles(bottles)
        self.set_launchers(launchers)

    def on_ApplicationsView_show(self, _widget):
        self.update_launchers()

    # BottleCollection delegate functions
    def bottleCollectionChanged(self):
        self.update_launchers()

    # BottleWrapper delegate functions
    def bottleChanged(self, bottle):
        GLib.idle_add(self.update_launchers_for_bottle, bottle.name)
